/*
 * Decompiled with CFR 0.152.
 */
package utilt;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.NetworkInterface;
import java.net.URLConnection;
import java.rmi.Naming;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.server.UnicastRemoteObject;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.TimeZone;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import mlib.MCharColl;
import mlib.MEncrypter;
import mlib.MLogging;
import mlib.MString;
import mlib.MWildcard;
import org.apache.commons.net.ntp.NTPUDPClient;
import org.apache.commons.net.ntp.NtpV3Packet;
import org.apache.commons.net.ntp.TimeInfo;

public abstract class Utility {
    public static final String COMMENT = "//";
    public static final String FILEPROTOCOL = "file://";
    public static final String ALL = "All";
    public static final SimpleDateFormat DMY = new SimpleDateFormat("dd-MMM-yyyy");
    private static final TimeZone UTC = TimeZone.getTimeZone("UTC");
    private static final long SEEDOFFSET = 736298441L;

    public static void main(String[] args) {
        try {
            Calendar now = Utility.UTC();
            String str = new Date(now.getTime().getTime()).toString();
            System.out.println(str);
            str = Utility.makeKey(str);
            System.out.println(str);
            str = "dlmj203-dl;jk30.dat";
            str = Utility.scrambleFileName(str);
            System.out.println(str);
            String string = Utility.capFirstChar("abc");
        }
        catch (Exception xcp) {
            System.out.println(xcp);
        }
    }

    public static String javaEnv() {
        String javaEnv = "Java: " + System.getProperty("java.version");
        javaEnv = String.valueOf(javaEnv) + " " + System.getProperty("java.vendor");
        javaEnv = String.valueOf(javaEnv) + ", " + System.getProperty("os.name");
        javaEnv = String.valueOf(javaEnv) + " " + System.getProperty("os.version");
        return javaEnv;
    }

    public static String tempPath() {
        String path = System.getProperty("java.io.tmpdir");
        if (!path.endsWith(File.separator)) {
            path = String.valueOf(path) + File.separator;
        }
        return path;
    }

    public static boolean isUnixFilesystem() {
        String osName = System.getProperty("os.name").toLowerCase();
        boolean isUnix = osName.indexOf("inux") >= 0;
        isUnix |= osName.indexOf("unix") >= 0;
        return isUnix |= osName.indexOf("os x") >= 0;
    }

    public static String setupPath(String path) {
        path = Utility.isUnixFilesystem() ? path.replace('\\', File.separatorChar) : path.replace('/', File.separatorChar);
        return path;
    }

    public static Calendar calFromStr(String date) throws Exception {
        GregorianCalendar cal = null;
        StringTokenizer tken = new StringTokenizer(date, "/");
        if (tken.countTokens() == 3) {
            int mm = Integer.parseInt(tken.nextToken()) - 1;
            boolean error = mm < 0 || mm > 11;
            int dd = Integer.parseInt(tken.nextToken());
            if (error |= dd < 1 || dd > 31) {
                Utility.throwError("invalid date: " + date);
            }
            cal = new GregorianCalendar();
            int yyyy = Integer.parseInt(tken.nextToken());
            if (yyyy < 2000) {
                yyyy += 2000;
            }
            cal.set(yyyy, mm, dd, 0, 0, 0);
            cal.set(14, 0);
        }
        return cal;
    }

    public static void showColl(Collection<? extends Object> coll, MLogging logger) {
        logger.writeln("Collection:", false);
        for (Object object : coll) {
            logger.writeln("   " + object, false);
        }
    }

    public static boolean bindToRegistry(UnicastRemoteObject server, String bindId, int port) throws MalformedURLException, RemoteException {
        boolean registryStarted = false;
        try {
            Naming.rebind(bindId, server);
        }
        catch (Exception xcp) {
            LocateRegistry.createRegistry(port);
            Naming.rebind(bindId, server);
            registryStarted = true;
        }
        return registryStarted;
    }

    public static int stdFontSize() {
        Toolkit tKit = Toolkit.getDefaultToolkit();
        int dpi = tKit.getScreenResolution();
        int fontSize = (int)(0.5f + 0.175f * (float)dpi);
        return fontSize;
    }

    public static Font stdFont() {
        return new Font("SansSerif", 0, Utility.stdFontSize());
    }

    public static Font stdFixedFont() {
        return new Font("Monospaced", 1, Utility.stdFontSize() - 2);
    }

    public static boolean widescreen() {
        Toolkit tKit = Toolkit.getDefaultToolkit();
        Dimension screen = tKit.getScreenSize();
        double ratio = (double)screen.width / (double)screen.height;
        boolean wide = ratio > 1.4;
        return wide;
    }

    public static String makeKey(String str) throws Exception {
        String key = null;
        StringTokenizer tken = new StringTokenizer(str, " -");
        if (tken.countTokens() > 0) {
            String[] tokens = new String[tken.countTokens()];
            int i = 0;
            while (tken.hasMoreTokens()) {
                tokens[i++] = tken.nextToken();
            }
            key = String.valueOf(tokens[0]) + "-" + tokens[1] + "-" + tokens[tokens.length - 1] + ":";
            i = 2;
            while (i < tokens.length - 1) {
                key = String.valueOf(key) + tokens[i].charAt(0);
                ++i;
            }
        } else {
            throw new Exception("Empty string for key");
        }
        return key;
    }

    public static String scrambleFileName(String name) {
        int index = name.indexOf(".");
        String ext = name.substring(index);
        name = name.substring(0, index - 1);
        MString work = new MString();
        int offset = 2;
        int i = 0;
        while (i < name.length()) {
            int chr = Character.toLowerCase(name.charAt(i));
            if ((chr += offset++) == 32) {
                chr = 36;
            } else if (chr > 122) {
                chr = 122;
            }
            work.concat((char)chr);
            if (offset > 7) {
                offset = 2;
            }
            ++i;
        }
        return String.valueOf(work.toString()) + ext;
    }

    public static LinkedList<String> readTextFileFromStream(InputStream stream) throws Exception {
        LinkedList<String> lines = new LinkedList<String>();
        BufferedReader in = new BufferedReader(new InputStreamReader(stream));
        String line = null;
        while ((line = in.readLine()) != null) {
            lines.add(line);
        }
        in.close();
        return lines;
    }

    public static LinkedList<String> readTextFile(String path) throws Exception {
        LinkedList<String> result = null;
        try (FileInputStream stream = null;){
            stream = new FileInputStream(path);
            result = Utility.readTextFileFromStream(stream);
        }
        return result;
    }

    public static MString readFileAsText(String path) throws Exception {
        MString text = new MString();
        String line = null;
        BufferedReader in = new BufferedReader(new FileReader(path));
        while ((line = in.readLine()) != null) {
            text.concat(String.valueOf(line) + "\r\n");
        }
        in.close();
        return text;
    }

    public static MCharColl.Queue readFileAsQueue(String path, boolean removeWhitespace) throws Exception {
        int c;
        File file = new File(path);
        char[] buffer = new char[(int)file.length()];
        BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
        int index = 0;
        while ((c = reader.read()) != -1) {
            buffer[index++] = (char)c;
        }
        reader.close();
        MCharColl.Queue queue = new MCharColl.Queue(new MString(buffer), removeWhitespace);
        return queue;
    }

    public static LinkedList<byte[]> readBinaryFile(String pathName) throws Exception {
        int numRead;
        byte[] buffer = new byte[10000];
        LinkedList<byte[]> bytes = new LinkedList<byte[]>();
        DataInputStream in = new DataInputStream(new BufferedInputStream(new FileInputStream(pathName)));
        while ((numRead = in.read(buffer)) >= 0) {
            byte[] more = new byte[numRead];
            int i = 0;
            while (i < numRead) {
                more[i] = buffer[i];
                ++i;
                ++i;
            }
            bytes.add(more);
        }
        in.close();
        return bytes;
    }

    public static void writeBinaryFile(String pathName, LinkedList<byte[]> bytes) throws IOException {
        DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(pathName)));
        for (byte[] more : bytes) {
            out.write(more, 0, more.length);
        }
        out.close();
    }

    public static void obtainFiles(Collection<File> files, MWildcard wildcard, File dir, boolean recurse) {
        File[] list = dir.listFiles();
        if (list != null) {
            int i = 0;
            while (i < list.length) {
                if (list[i].isDirectory() && recurse) {
                    Utility.obtainFiles(files, wildcard, list[i], recurse);
                } else if (wildcard.matchesAny(list[i].getName())) {
                    files.add(list[i]);
                }
                ++i;
            }
        }
    }

    public static long compareFiles(File file1, File file2) throws Exception {
        long diff = 0L;
        if (!file1.exists() || !file2.exists()) {
            Utility.throwError("File not found");
        } else if (file1.length() != file2.length()) {
            Utility.throwError("Files not same size");
        } else {
            Iterator file1Iter = Utility.readBinaryFile(file1.getAbsolutePath()).iterator();
            Iterator file2Iter = Utility.readBinaryFile(file2.getAbsolutePath()).iterator();
            while (file1Iter.hasNext()) {
                byte[] buf1 = (byte[])file1Iter.next();
                byte[] buf2 = (byte[])file2Iter.next();
                int i = 0;
                while (i < buf1.length) {
                    if (buf1[i] != buf2[i]) {
                        ++diff;
                    }
                    ++i;
                }
            }
        }
        return diff;
    }

    public static long copyFile(File from, File to) throws IOException {
        long result = Utility.copyFile(from.getPath(), to.getPath());
        return result;
    }

    public static long copyFile(String source, String target) throws IOException {
        long size;
        byte[] buffer = Utility.buffer();
        File file = new File(source);
        long bytesLeft = size = file.length();
        DataInputStream in = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
        DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(target)));
        while (bytesLeft > 0L) {
            long bytesToRead = buffer.length;
            if (bytesLeft < bytesToRead) {
                bytesToRead = bytesLeft;
            }
            in.read(buffer, 0, (int)bytesToRead);
            out.write(buffer, 0, (int)bytesToRead);
            bytesLeft -= bytesToRead;
        }
        in.close();
        out.close();
        return size;
    }

    public static void encryptFile(String source, String target, MEncrypter encrypter) throws IOException {
        long size;
        byte[] buffer = Utility.buffer();
        File file = new File(source);
        long bytesLeft = size = file.length();
        DataInputStream in = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
        DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(target)));
        long seed = encrypter.getSeed() + 736298441L;
        out.writeLong(seed);
        while (bytesLeft > 0L) {
            long bytesToRead = buffer.length;
            if (bytesLeft < bytesToRead) {
                bytesToRead = bytesLeft;
            }
            in.read(buffer, 0, (int)bytesToRead);
            byte[] outBuf = encrypter.xor(buffer);
            out.write(outBuf, 0, (int)bytesToRead);
            bytesLeft -= bytesToRead;
        }
        in.close();
        out.close();
    }

    public static void decryptFile(String source, String target) throws Exception {
        byte[] buffer = Utility.buffer();
        String fromPath = source;
        if (source.equals(target)) {
            fromPath = String.valueOf(System.getProperty("java.io.tmpdir")) + File.separator + "temp.dat";
            Utility.copyFile(source, fromPath);
        }
        File file = new File(fromPath);
        DataInputStream in = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
        DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(target)));
        long seed = in.readLong() - 736298441L;
        MEncrypter encrypter = new MEncrypter(seed);
        long size = file.length();
        long bytesLeft = size - 8L;
        while (bytesLeft > 0L) {
            long bytesToRead = buffer.length;
            if (bytesLeft < bytesToRead) {
                bytesToRead = bytesLeft;
            }
            in.read(buffer, 0, (int)bytesToRead);
            byte[] outBuf = encrypter.xor(buffer);
            out.write(outBuf, 0, (int)bytesToRead);
            bytesLeft -= bytesToRead;
        }
        in.close();
        out.close();
    }

    public static Object getHttpObject(URLConnection conn) throws Exception {
        Object obj = null;
        try (ObjectInputStream in = null;){
            in = new ObjectInputStream(new BufferedInputStream(conn.getInputStream()));
            obj = in.readObject();
        }
        return obj;
    }

    public static Date getHttpResource(URLConnection conn, File file) throws IOException {
        Date modified = null;
        FilterInputStream in = null;
        FilterOutputStream out = null;
        try {
            in = new DataInputStream(new BufferedInputStream(conn.getInputStream()));
            out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
            boolean more = true;
            while (more) {
                try {
                    byte next = ((DataInputStream)in).readByte();
                    ((DataOutputStream)out).write(next);
                }
                catch (EOFException xcp) {
                    long lastmod = conn.getHeaderFieldDate("Last-Modified", -1L);
                    if (lastmod > 0L) {
                        modified = new Date(lastmod);
                    }
                    more = false;
                }
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (out != null) {
                out.close();
            }
        }
        return modified;
    }

    public static MString getHttpTextResource(URLConnection conn) throws Exception {
        MString str = new MString();
        try (BufferedReader in = null;){
            in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            String line = null;
            while ((line = in.readLine()) != null) {
                str.concat(String.valueOf(line.trim()) + "\r\n");
            }
        }
        return str;
    }

    public static Calendar internetTime() throws Exception {
        NTPUDPClient timeClient = new NTPUDPClient();
        InetAddress inetAddress = InetAddress.getByName("time.nist.gov");
        TimeInfo timeInfo = timeClient.getTime(inetAddress);
        NtpV3Packet message = timeInfo.getMessage();
        long serverTime = message.getTransmitTimeStamp().getTime();
        Date time = new Date(serverTime);
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(time);
        return cal;
    }

    public static Calendar UTC() {
        Calendar utc = new GregorianCalendar();
        try {
            utc = Utility.internetTime();
        }
        catch (Exception xcp) {
            utc.setTimeZone(UTC);
        }
        return utc;
    }

    public static Calendar localUTC() {
        GregorianCalendar utc = new GregorianCalendar();
        ((Calendar)utc).setTimeZone(UTC);
        return utc;
    }

    public static void deleteFile(String path) throws IOException {
        File file = new File(path);
        if (file.exists()) {
            if (file.isDirectory()) {
                Utility.deleteDir(path);
            } else {
                file.delete();
            }
        }
    }

    public static void deleteDir(String path) throws IOException {
        File dir = new File(path);
        String[] files = dir.list();
        if (files != null) {
            int i = 0;
            while (i < files.length) {
                File subfile;
                String subfilePath = path;
                if (!subfilePath.endsWith(File.separator)) {
                    subfilePath = String.valueOf(subfilePath) + File.separator;
                }
                if ((subfile = new File(subfilePath = String.valueOf(subfilePath) + files[i])).isDirectory()) {
                    Utility.deleteDir(subfile.getCanonicalPath());
                } else {
                    subfile.delete();
                }
                ++i;
            }
        }
        dir.delete();
    }

    public static String[] parseDelimStr(String str, String delim) throws Exception {
        LinkedList<String> list = new LinkedList<String>();
        StringTokenizer tken = new StringTokenizer(str, delim);
        while (tken.hasMoreTokens()) {
            MString token = new MString(tken.nextToken());
            token.trimWhitespace();
            if (token.length() > 1 && token.charAt(0) == '\"') {
                token = token.substring(1);
                boolean done = false;
                while (!done && tken.hasMoreTokens()) {
                    int lastIndex;
                    String next = tken.nextToken();
                    boolean bl = done = next.charAt(lastIndex = next.length() - 1) == '\"';
                    if (done) {
                        next = next.substring(0, lastIndex);
                    }
                    token.concat("," + next);
                }
                token.removeWhitespace();
            }
            list.add(token.toString());
        }
        String[] words = new String[list.size()];
        int i = 0;
        for (String string : list) {
            words[i++] = string;
        }
        return words;
    }

    public static LinkedList<String> strArrayToList(String[] array) {
        LinkedList<String> strs = new LinkedList<String>();
        String[] stringArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            strs.add(str);
            ++n2;
        }
        return strs;
    }

    public static String[] arrayFromTokenizer(StringTokenizer tken) {
        int numStrs = tken.countTokens();
        String[] strs = new String[numStrs];
        int i = 0;
        while (tken.hasMoreTokens()) {
            strs[i++] = tken.nextToken();
        }
        return strs;
    }

    public static String[] strTokens(String str, char delim) {
        LinkedList<String> work = new LinkedList<String>();
        boolean inQuotes = false;
        int i = 0;
        String token = "";
        while (i < str.length()) {
            char chr = str.charAt(i);
            if (chr == '\"') {
                token = String.valueOf(token) + chr;
                inQuotes = !inQuotes;
            } else if (chr == delim && !inQuotes) {
                work.add(token.trim());
                token = "";
            } else {
                token = String.valueOf(token) + chr;
            }
            ++i;
        }
        if ((token = token.trim()).length() > 0) {
            work.add(token);
        }
        String[] tokens = new String[work.size()];
        i = 0;
        for (String aToken : work) {
            tokens[i++] = aToken;
        }
        return tokens;
    }

    public static String addCommas(String fixedPtNum) {
        int spacing = 3;
        char[] chars = fixedPtNum.toCharArray();
        int numCommas = chars.length / spacing;
        if (chars.length % spacing == 0) {
            --numCommas;
        }
        char[] newChars = new char[chars.length + numCommas];
        int from = chars.length - 1;
        int to = newChars.length - 1;
        int count = 0;
        while (from >= 0) {
            newChars[to--] = chars[from--];
            if (to < 0 || ++count % spacing != 0) continue;
            newChars[to--] = 44;
            count = 0;
        }
        String result = new String(newChars);
        return result;
    }

    public static Collection<String> dosDrives() {
        LinkedList<String> drives = new LinkedList<String>();
        char drive = 'a';
        while (drive <= 'z') {
            String name = String.valueOf(drive) + ":" + File.separator;
            File file = new File(name);
            if (file.exists()) {
                drives.add(String.valueOf(drive) + ":");
            }
            char driveNum = drive;
            drive = ++driveNum;
        }
        return drives;
    }

    public static String tmpDir() {
        MString path = new MString(System.getProperty("java.io.tmpdir"));
        if (!path.endsWith(File.separatorChar)) {
            path.concat(File.separatorChar);
        }
        return path.toString();
    }

    public static void clearTmpDir(MWildcard wc) {
        File[] files;
        File dir = new File(Utility.tmpDir());
        File[] fileArray = files = dir.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (wc.matchesAny(file.getName())) {
                file.delete();
            }
            ++n2;
        }
    }

    public static int[] shuffled(int first, int last, Random random) {
        int count = last - first + 1;
        int[] shuffled = new int[count];
        int i = 0;
        while (i < count) {
            shuffled[i] = first++;
            ++i;
        }
        i = 0;
        while (i < count) {
            int index = random.nextInt(count);
            int temp = shuffled[i];
            shuffled[i] = shuffled[index];
            shuffled[index] = temp;
            ++i;
        }
        return shuffled;
    }

    public static String objPrefix(Object obj) {
        String str = String.valueOf(obj.getClass().getName()) + ": ";
        int index = str.lastIndexOf(46);
        str = str.substring(index + 1);
        return str;
    }

    public static double dateToJulian(Calendar date) {
        int year = date.get(1);
        int month = date.get(2) + 1;
        int day = date.get(5);
        int hour = date.get(11);
        int minute = date.get(12);
        int second = date.get(13);
        double extra = 100.0 * (double)year + (double)month - 190002.5;
        return 367.0 * (double)year - Math.floor(7.0 * ((double)year + Math.floor(((double)month + 9.0) / 12.0)) / 4.0) + Math.floor(275.0 * (double)month / 9.0) + (double)day + ((double)hour + ((double)minute + (double)second / 60.0) / 60.0) / 24.0 + 1721013.5 - 0.5 * extra / Math.abs(extra) + 0.5;
    }

    public static Calendar ooMetaDateToCal(String metaDate) {
        String[] date = metaDate.split("T");
        String[] ymd = date[0].split("-");
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(Integer.parseInt(ymd[0]), Integer.parseInt(ymd[1]), Integer.parseInt(ymd[2]));
        return cal;
    }

    public static String xcpMsg(Exception xcp) {
        MString msg = new MString();
        if (xcp != null) {
            msg.concat("*** ");
            String txt = xcp.getMessage();
            if (txt == null || txt.length() == 0) {
                if (msg.length() > 0) {
                    msg.concat(": ");
                }
                txt = xcp.getClass().getName();
                int index = txt.lastIndexOf(46);
                txt = txt.substring(index + 1);
            }
            msg.concat(txt);
            msg.toString();
        }
        return msg.toString();
    }

    public static void throwError(String msg) throws Exception {
        MString work = new MString(msg);
        work.capFirstChar();
        work.insert("*** ", 0);
        throw new Exception(work.toString());
    }

    public static void throwError(String msg, Exception xcp, MLogging logger) throws Exception {
        if (logger != null) {
            if (xcp != null) {
                logger.writeln(xcp.toString(), true);
            } else {
                logger.writeln(msg, true);
            }
        }
        Utility.throwError(msg);
    }

    public static void queryContinue(MLogging logger, String msg) throws Exception {
        logger.writeln(msg, true);
        BufferedReader stdio = new BufferedReader(new InputStreamReader(System.in));
        System.out.println("continue? (y/n)");
        String answer = stdio.readLine().toLowerCase();
        if (!answer.startsWith("y")) {
            throw new Exception("Stopped");
        }
    }

    public static void randomSleepMs(int max) throws Exception {
        int delay = (int)((double)max * Math.random());
        Thread.sleep(delay);
    }

    public static String capFirstChar(String str) {
        if (str.length() > 0) {
            char first = Character.toUpperCase(str.charAt(0));
            str = String.valueOf(first) + str.substring(1);
        }
        return str;
    }

    public static InetAddress notLoopbackAddr() {
        InetAddress notLoop = null;
        try {
            InetAddress loopBack = InetAddress.getLoopbackAddress();
            Enumeration<NetworkInterface> interfs = NetworkInterface.getNetworkInterfaces();
            while (interfs.hasMoreElements()) {
                NetworkInterface interf = interfs.nextElement();
                Enumeration<InetAddress> addrs = interf.getInetAddresses();
                while (addrs.hasMoreElements()) {
                    InetAddress addr = addrs.nextElement();
                    if (!(addr instanceof Inet4Address) || addr.equals(loopBack)) continue;
                    notLoop = addr;
                }
            }
        }
        catch (Exception xcp) {
            notLoop = null;
        }
        return notLoop;
    }

    public static void expandOrCollapse(JTree tree, boolean expand) {
        TreeNode root = (TreeNode)tree.getModel().getRoot();
        Utility.expandAll(tree, new TreePath(root), expand);
    }

    private static void expandAll(JTree tree, TreePath parent, boolean expand) {
        TreeNode node = (TreeNode)parent.getLastPathComponent();
        if (node.getChildCount() >= 0) {
            Enumeration<? extends TreeNode> nodes = node.children();
            while (nodes.hasMoreElements()) {
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)nodes.nextElement();
                TreePath path = parent.pathByAddingChild(child);
                Utility.expandAll(tree, path, expand);
            }
        }
        if (expand) {
            tree.expandPath(parent);
        } else {
            tree.collapsePath(parent);
        }
    }

    private static byte[] buffer() {
        byte[] buffer = new byte[50000];
        return buffer;
    }

    private Utility() {
    }
}

