/*
 * Decompiled with CFR 0.152.
 */
package utilt;

import files.FileInfo;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.FileImageOutputStream;

public class ImageIOUtil {
    public static final String JPG = ".jpg";
    public static final String[] IMAGEEXTS = new String[]{".jpg", ".jpeg", ".gif", ".png"};

    public static BufferedImage load(String path) throws Exception {
        File file = new File(path);
        return ImageIO.read(file);
    }

    public static boolean isValidImage(String path) {
        boolean isJimi = false;
        String[] stringArray = IMAGEEXTS;
        int n = IMAGEEXTS.length;
        int n2 = 0;
        while (n2 < n) {
            String ext = stringArray[n2];
            isJimi |= path.toLowerCase().endsWith(ext);
            ++n2;
        }
        return isJimi;
    }

    public static boolean isJpeg(String path) {
        boolean is = (path = path.toLowerCase()).endsWith(IMAGEEXTS[0]) || path.endsWith(IMAGEEXTS[1]);
        return is;
    }

    public static void writeJpeg(BufferedImage image, String path, int quality) throws Exception {
        try (FileImageOutputStream out = null;){
            ImageWriter writer = ImageIO.getImageWritersByFormatName("jpg").next();
            ImageWriteParam jpgWriteParam = writer.getDefaultWriteParam();
            jpgWriteParam.setCompressionMode(2);
            jpgWriteParam.setCompressionQuality(1.0f * (float)quality / 100.0f);
            out = new FileImageOutputStream(new File(path));
            writer.setOutput(out);
            IIOImage outputImage = new IIOImage(image, null, null);
            writer.write(null, outputImage, jpgWriteParam);
            writer.dispose();
        }
    }

    public static void writeOther(BufferedImage image, String path) throws Exception {
        try (FileImageOutputStream out = null;){
            FileInfo.Local info = new FileInfo.Local(new File(path));
            String ext = info.extension();
            ext = ext.substring(1);
            ImageWriter writer = ImageIO.getImageWritersByFormatName(ext).next();
            out = new FileImageOutputStream(new File(path));
            writer.setOutput(out);
            IIOImage outputImage = new IIOImage(image, null, null);
            writer.write(outputImage);
            writer.dispose();
        }
    }

    public static BufferedImage resize(BufferedImage image, int maxSize) throws Exception {
        double factor;
        double height = image.getHeight();
        double width = image.getWidth();
        if (height > (double)maxSize) {
            factor = (double)maxSize / height;
            height *= factor;
            width *= factor;
        }
        if (width > (double)maxSize) {
            factor = (double)maxSize / width;
            height *= factor;
            width *= factor;
        }
        int w = (int)(width + 0.5);
        int h = (int)(height + 0.5);
        BufferedImage scaled = new BufferedImage(w, h, image.getType());
        double xScale = width / (double)image.getWidth();
        double yScale = height / (double)image.getHeight();
        AffineTransform at = AffineTransform.getScaleInstance(xScale, yScale);
        AffineTransformOp ato = new AffineTransformOp(at, 3);
        scaled = ato.filter(image, scaled);
        return scaled;
    }
}

