/*
 * Decompiled with CFR 0.152.
 */
package utilt;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Socket;

public abstract class GenericClientClient
implements Runnable {
    private Socket iSocket = null;
    private ObjectOutputStream iOutStream = null;
    private ObjectInputStream iInStream = null;

    protected GenericClientClient(Socket socket) {
        this.iSocket = socket;
        Runtime.getRuntime().addShutdownHook(new Shutdown());
    }

    protected ObjectOutputStream outStream() {
        return this.iOutStream;
    }

    protected ObjectInputStream inStream() {
        return this.iInStream;
    }

    protected abstract void process() throws IOException, ClassNotFoundException;

    protected abstract void disconnect() throws IOException;

    @Override
    public void run() {
        try {
            this.iSocket.setSoTimeout(5000);
            this.iOutStream = new ObjectOutputStream(this.iSocket.getOutputStream());
            this.iInStream = new ObjectInputStream(this.iSocket.getInputStream());
            this.process();
        }
        catch (Exception xcp) {
            System.out.println(xcp);
        }
    }

    private void cleanup() {
        try {
            this.disconnect();
            if (this.iOutStream != null) {
                this.iOutStream.close();
            }
            if (this.iInStream != null) {
                this.iInStream.close();
            }
            if (this.iSocket != null) {
                this.iSocket.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private class Shutdown
    extends Thread {
        private Shutdown() {
        }

        @Override
        public void run() {
            GenericClientClient.this.cleanup();
        }
    }
}

