/*
 * Decompiled with CFR 0.152.
 */
package utilt;

import files.FileInfo;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import mlib.MLogger;
import mlib.MLogging;
import utilt.Showable;
import utilt.Utility;

public class BinnedDb
implements Serializable,
Showable {
    private int iNumBins = 11;
    private Integer iNextId = 10000;
    private String iDir = null;
    private transient Bin[] iBins = null;
    public static final String FILENAME = "binned.db";
    public static final int DEFAULTNUMBINS = 11;
    public static final int INITID = 10000;
    public static final int NOID = -1;
    private static final String OBJSFILENAME = "objects.dat";
    private static final String BIN = "bin";
    static final long serialVersionUID = 7712886111608776724L;

    public static void main(String[] args) {
        try {
            FileInfo.Local dir = new FileInfo.Local(new File(args[0]));
            MLogger.System logger = new MLogger.System();
            BinnedDb.open(dir, logger);
        }
        catch (Exception xcp) {
            System.out.println(xcp);
        }
    }

    public static BinnedDb open(FileInfo dir, MLogging logger) throws Exception {
        if (!dir.isDir()) {
            Utility.throwError("Not a folder: " + dir);
        }
        BinnedDb db = null;
        try {
            GZIPInputStream zipin = new GZIPInputStream(new FileInputStream(String.valueOf(dir.path()) + FILENAME));
            ObjectInputStream in = new ObjectInputStream(zipin);
            db = (BinnedDb)in.readObject();
            db.iDir = dir.path();
            in.close();
            db.setup(logger);
        }
        catch (Exception xcp) {
            String msg = String.valueOf(Utility.xcpMsg(xcp)) + ": " + dir.path();
            Utility.throwError(msg);
        }
        return db;
    }

    public static boolean isBinnedFileName(String name) {
        boolean is = false;
        try {
            int value = Integer.parseInt(name);
            if (value > 0 && value < Integer.MAX_VALUE) {
                is = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return is;
    }

    public BinnedDb(FileInfo dir, int numBins) throws Exception {
        if (!dir.isDir()) {
            Utility.throwError("Not a folder: " + dir);
        }
        this.iDir = dir.path();
        this.iBins = new Bin[numBins];
        this.iNumBins = numBins;
        int i = 0;
        while (i < this.iNumBins) {
            String binPath = this.binPath(i);
            this.iBins[i] = new Bin(binPath);
            this.iBins[i].save(false);
            ++i;
        }
        this.save(true);
    }

    public Integer nextId() {
        Integer n = this.iNextId;
        this.iNextId = n + 1;
        return n;
    }

    public int numBins() {
        return this.iNumBins;
    }

    public int bin(Integer id) {
        return id % this.iNumBins;
    }

    public boolean put(Binnable obj, boolean save) throws Exception {
        int bin = this.bin(obj.id());
        return this.iBins[bin].put(obj, save);
    }

    public Binnable obj(Integer id) throws Exception {
        int bin = this.bin(id);
        Binnable obj = this.iBins[bin].obj(id);
        return obj;
    }

    public String binPath(int binNum) {
        String binPath = String.valueOf(this.iDir) + BIN + Integer.toString(binNum) + '/';
        return binPath;
    }

    public void save(boolean force) throws Exception {
        int i = 0;
        while (i < this.iNumBins) {
            this.iBins[i].save(force);
            ++i;
        }
        GZIPOutputStream zipout = new GZIPOutputStream(new FileOutputStream(String.valueOf(this.iDir) + '/' + FILENAME));
        ObjectOutputStream out = new ObjectOutputStream(zipout);
        out.writeObject(this);
        out.close();
    }

    public void close() throws Exception {
        this.save(false);
    }

    public void delete() throws Exception {
        File file = new File(String.valueOf(this.iDir) + FILENAME);
        file.delete();
        int i = 0;
        while (i < this.iNumBins) {
            this.iBins[i].delete();
            ++i;
        }
    }

    public boolean remove(int id, boolean save) throws Exception {
        int bin = this.bin(id);
        return this.iBins[bin].remove(id, save);
    }

    public void remove(Binnable obj, boolean save) throws Exception {
        this.remove(obj.id(), save);
    }

    public Collection<Binnable> retrieveAll() {
        LinkedList<Binnable> objs = new LinkedList<Binnable>();
        int i = 0;
        while (i < this.iNumBins) {
            this.iBins[i].retrieve(objs);
            ++i;
        }
        return objs;
    }

    public void remove(Collection<Binnable> objs, boolean save) throws Exception {
        for (Binnable obj : objs) {
            int bin = this.bin(obj.id());
            this.iBins[bin].remove(obj, save);
        }
    }

    public void clear() throws Exception {
        int i = 0;
        while (i < this.iNumBins) {
            this.iBins[i].clear();
            ++i;
        }
    }

    public Path filePath(Integer id, String extension) {
        String ext = extension.trim();
        if (ext.charAt(0) != '.') {
            ext = "." + ext;
        }
        int bin = this.bin(id);
        String pathName = String.valueOf(this.binPath(bin)) + id + extension;
        return new Path(pathName);
    }

    public int numObjs() {
        int num = 0;
        int i = 0;
        while (i < this.iNumBins) {
            num += this.iBins[i].numObjs();
            ++i;
        }
        return num;
    }

    public int numFiles() {
        int num = 0;
        int i = 0;
        while (i < this.iNumBins) {
            num += this.iBins[i].numFiles();
            ++i;
        }
        return num;
    }

    public LinkedList<Binnable> find(Binnable obj, Comparer comp) {
        LinkedList<Binnable> objs = new LinkedList<Binnable>();
        int i = 0;
        while (i < this.iNumBins) {
            this.iBins[i].find(obj, comp, objs);
            ++i;
        }
        return objs;
    }

    public TreeSet<Binnable> objsById() {
        TreeSet<Binnable> objs = new TreeSet<Binnable>(new IdComparator());
        int i = 0;
        while (i < this.iNumBins) {
            LinkedList<Binnable> binObjs = new LinkedList<Binnable>();
            this.iBins[i].retrieve(binObjs);
            objs.addAll(binObjs);
            ++i;
        }
        return objs;
    }

    public void clean(MLogging logger) throws Exception {
        int count = 0;
        int i = 0;
        while (i < this.iNumBins) {
            count += this.iBins[i].clean();
            ++i;
        }
        if (count > 0) {
            logger.writeln("BinnedDb: removed " + count + " objects", false);
        }
        i = 0;
        while (i < this.iNumBins) {
            File[] files;
            File[] fileArray = files = this.iBins[i].files();
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                int index;
                File file = fileArray[n2];
                String name = file.getName();
                int number = Integer.parseInt(name.substring(0, index = name.lastIndexOf(46)));
                if (number >= this.iNextId) {
                    logger.writeln("BinnedDb: file ID is >= nextId: " + file.getName() + ", resetting nextId", true);
                    this.iNextId = number + 1;
                }
                ++n2;
            }
            ++i;
        }
    }

    public void listObjs(MLogging logger) {
        TreeSet<Binnable> objs = this.objsById();
        for (Binnable obj : objs) {
            logger.writeln(obj.id() + ": " + obj.toString(), false);
        }
    }

    public String toString() {
        String str = String.valueOf(Utility.objPrefix(this)) + this.iNumBins + " bins, " + this.numObjs() + " objects, " + this.numFiles() + " files, nextId " + this.iNextId;
        return str;
    }

    private void setup(MLogging logger) throws Exception {
        String binPath = "";
        try {
            Bin[] bins = new Bin[this.iNumBins];
            int i = 0;
            while (i < this.iNumBins) {
                binPath = this.binPath(i);
                bins[i] = new Bin(binPath);
                bins[i].open();
                ++i;
            }
            this.iBins = bins;
            logger.writeln(this.toString());
        }
        catch (Exception xcp) {
            String msg = String.valueOf(Utility.xcpMsg(xcp)) + ": " + binPath;
            Utility.throwError(msg);
        }
    }

    @Override
    public void showId(MLogging logger) {
        logger.writeln(this.iDir, false);
    }

    @Override
    public void showSummary(MLogging logger) throws Exception {
        this.showId(logger);
        this.setup(null);
    }

    @Override
    public void showDetails(MLogging logger) throws Exception {
        this.showSummary(logger);
        int i = 0;
        while (i < this.iNumBins) {
            logger.setPrefix("");
            logger.writeln("bin " + i + ", " + this.iBins[i].toString(), false);
            logger.setPrefix("   ");
            for (Binnable obj : this.iBins[i].iObjs.values()) {
                logger.writeln(obj.id() + ": " + obj.toString(), false);
            }
            ++i;
        }
        logger.writeln(this.numFiles() + " files", false);
    }

    @Override
    public void showOther(String parm, MLogging logger) throws Exception {
        logger.writeln("show Other not defined", false);
    }

    @Override
    public void showHelp(MLogging logger) {
        logger.writeln("show Help not defined", false);
    }

    private class Bin
    implements Serializable {
        private TreeMap<Integer, Binnable> iObjs = new TreeMap();
        private transient String iPath = null;
        private transient boolean iSaveNeeded = false;
        static final long serialVersionUID = -8880292357387539886L;

        Bin(String path) {
            this.iPath = path;
            this.iSaveNeeded = true;
        }

        void save(boolean force) throws Exception {
            if (this.iSaveNeeded || force) {
                File file = new File(this.iPath);
                if (!file.exists()) {
                    file.mkdir();
                }
                GZIPOutputStream zipout = new GZIPOutputStream(new FileOutputStream(String.valueOf(this.iPath) + BinnedDb.OBJSFILENAME));
                ObjectOutputStream out = new ObjectOutputStream(zipout);
                out.writeObject(this.iObjs);
                out.close();
            }
            this.iSaveNeeded = false;
        }

        void open() throws Exception {
            TreeMap objs;
            GZIPInputStream zipin = new GZIPInputStream(new FileInputStream(String.valueOf(this.iPath) + BinnedDb.OBJSFILENAME));
            ObjectInputStream in = new ObjectInputStream(zipin);
            this.iObjs = objs = (TreeMap)in.readObject();
            in.close();
        }

        Binnable obj(Integer id) {
            return this.iObjs.get(id);
        }

        boolean put(Binnable obj, boolean save) throws Exception {
            Binnable existing = this.obj(obj.id());
            this.iObjs.put(obj.id(), obj);
            this.iSaveNeeded = true;
            if (save) {
                this.save(true);
                this.iSaveNeeded = false;
            }
            return existing == null;
        }

        void remove(Binnable obj, boolean save) throws Exception {
            this.remove(obj.id(), save);
            this.iSaveNeeded = true;
            if (save) {
                this.save(true);
                this.iSaveNeeded = false;
            }
        }

        boolean remove(int id, boolean save) throws Exception {
            boolean removed = false;
            if (this.iObjs.remove(id) != null) {
                File[] files;
                String fileName = "" + id;
                File[] fileArray = files = this.files();
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray[n2];
                    if (file.getName().startsWith(fileName)) {
                        file.delete();
                    }
                    ++n2;
                }
                this.iSaveNeeded = true;
                if (save) {
                    this.save(true);
                    this.iSaveNeeded = false;
                }
                removed = true;
            }
            return removed;
        }

        void delete() throws Exception {
            File[] files;
            File dir = new File(this.iPath);
            File[] fileArray = files = dir.listFiles();
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                file.delete();
                ++n2;
            }
            dir.delete();
        }

        void clear() throws Exception {
            File[] files;
            File[] fileArray = files = this.files();
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                file.delete();
                ++n2;
            }
            this.iObjs.clear();
            this.save(true);
        }

        void retrieve(Collection<Binnable> objs) {
            for (Binnable obj : this.iObjs.values()) {
                objs.add(obj);
            }
        }

        int clean() throws Exception {
            File[] files = this.files();
            LinkedList<Binnable> toRemove = new LinkedList<Binnable>();
            Set<Map.Entry<Integer, Binnable>> mappings = this.iObjs.entrySet();
            for (Map.Entry<Integer, Binnable> entry : mappings) {
                Binnable obj = entry.getValue();
                String fileName = "" + obj.id();
                boolean found = false;
                int index = 0;
                while (!found && index < files.length) {
                    found = files[index++].getName().startsWith(fileName);
                }
                if (found) continue;
                toRemove.add(obj);
            }
            if (toRemove.size() > 0) {
                for (Binnable obj : toRemove) {
                    this.iObjs.remove(obj.id());
                }
                this.save(true);
            }
            return toRemove.size();
        }

        int numObjs() {
            return this.iObjs.keySet().size();
        }

        int numFiles() {
            return this.files().length;
        }

        void find(Binnable obj, Comparer comp, Collection<Binnable> objs) {
            for (Binnable anObj : this.iObjs.values()) {
                if (!comp.matches(obj, anObj)) continue;
                objs.add(anObj);
            }
        }

        File[] files() {
            File dir = new File(this.iPath);
            File[] allFiles = dir.listFiles();
            File[] files = new File[allFiles.length - 1];
            int index = 0;
            File[] fileArray = allFiles;
            int n = allFiles.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (!file.getName().equals(BinnedDb.OBJSFILENAME)) {
                    files[index++] = file;
                }
                ++n2;
            }
            return files;
        }

        public String toString() {
            String str = String.valueOf(this.numObjs()) + " objs, " + this.numFiles() + " files";
            return str;
        }
    }

    public static interface Binnable {
        public void setId(Integer var1);

        public Integer id();

        public String name();
    }

    public static interface Comparer {
        public boolean matches(Binnable var1, Binnable var2);
    }

    private class IdComparator
    implements Comparator<Binnable> {
        private IdComparator() {
        }

        @Override
        public int compare(Binnable obj1, Binnable obj2) {
            int result = -1;
            if (obj1 != null && obj2 != null && (result = obj1.id() - obj2.id()) == 0) {
                result = -1;
            }
            return result;
        }
    }

    public static class Path
    implements Serializable {
        private String iPath = null;

        public Path(String path) {
            this.iPath = path;
        }

        public String path() {
            return this.iPath;
        }

        public String toString() {
            return this.iPath;
        }
    }
}

