/*
 * Decompiled with CFR 0.152.
 */
package swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JScrollBar;
import mlib.MString;
import swing.ColorPanel;
import swing.CopyProtectMark;

public class ZoomableImagePanel
extends ColorPanel {
    private Image iImage = null;
    private double iZoomStepSize = 20.0;
    private int iImageMargin = 5;
    private JScrollBar iHorzBar = new JScrollBar(0);
    private JScrollBar iVertBar = new JScrollBar(1);
    private ScrollHandler iScrollHandler = new ScrollHandler();
    private boolean iAddedHorzBar = false;
    private boolean iAddedVertBar = false;
    private boolean iHasHorzBar = false;
    private boolean iHasVertBar = false;
    private boolean iIgnoreBarAdjust = false;
    private boolean iUseMark = false;
    private boolean iZoomable = true;
    private double iZoom = 1.0;
    private double iImageFitScale = 0.0;
    private double iScale = 0.0;
    private double iImageX = 0.0;
    private double iImageY = 0.0;
    private double iCenteredImageX = 0.0;
    private double iCenteredImageY = 0.0;
    private double iPicWidth = 0.0;
    private double iPicHeight = 0.0;
    private double iImageWidth = 0.0;
    private double iImageHeight = 0.0;
    private double iZoomCenterXFrac = 0.0;
    private double iZoomCenterYFrac = 0.0;
    private double iMaxZoomCenterXFrac = 0.0;
    private double iMinZoomCenterXFrac = 0.0;
    private double iMaxZoomCenterYFrac = 0.0;
    private double iMinZoomCenterYFrac = 0.0;
    private double iImageXMin = 0.0;
    private double iImageXMax = 0.0;
    private double iImageYMin = 0.0;
    private double iImageYMax = 0.0;
    private AffineTransform iTransform = null;
    private static final int SCROLLRANGE = 10000;
    private static final double MINZOOM = 0.05;
    private static final double MAXZOOM = 10.0;
    private static final double ZOOMADJUST = 0.002;
    private static final double WHEELZOOMFACTOR = 0.5;
    private static final double REFSCROLLFACTOR = 30.0;
    private static final Font BASEFONT = new Font("Dialog", 1, 18);
    private static CopyProtectMark Mark = null;
    private static String CopyrightMsg = "";
    private static int MaxNomarkSize = 0;

    public static void putImageMarkType(CopyProtectMark mark) {
        Mark = mark;
    }

    public static void putCopyrightMsg(String msg) {
        if (msg != null) {
            SimpleDateFormat year = new SimpleDateFormat("yyyy");
            String curYear = year.format(new Date());
            MString cMsg = new MString(msg.trim());
            cMsg.replace("%", curYear);
            CopyrightMsg = cMsg.toString();
        }
    }

    public static void putMaxNomarkSize(int size) {
        MaxNomarkSize = size;
    }

    public ZoomableImagePanel() {
        this.setLayout(new BorderLayout());
        this.iHorzBar.setMaximum(10000);
        this.iVertBar.setMaximum(10000);
        this.iHorzBar.setUnitIncrement(200);
        this.iVertBar.setUnitIncrement(200);
        Toolkit tKit = Toolkit.getDefaultToolkit();
        Dimension screen = tKit.getScreenSize();
        this.setMinimumSize(new Dimension((int)((double)screen.width * 0.1), 10));
        this.addMouseWheelListener(new WheelHandler());
        this.addMouseListener(new MouseHandler());
    }

    public void showPic(Image image, boolean useMark, boolean zoomable) {
        this.iImage = null;
        this.iImage = image;
        this.iUseMark = useMark;
        this.iZoomable = zoomable;
        this.iZoom = 1.0;
    }

    public void zoomIn(double factor) {
        double newZoom;
        if (this.iZoomable && (newZoom = this.iZoom * (1.0 + this.iZoomStepSize * 0.01 * factor)) < 10.0) {
            this.iZoom = newZoom;
            this.repaint();
        }
    }

    public void zoomOut(double factor) {
        double newZoom;
        if (this.iZoomable && (newZoom = this.iZoom * (1.0 - this.iZoomStepSize * 0.01 * factor)) > 0.05) {
            this.iZoom = newZoom;
            this.repaint();
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.iImage != null) {
            double imageSize;
            Graphics2D g2 = (Graphics2D)g;
            this.setupImageSizePos();
            this.iTransform = AffineTransform.getTranslateInstance(this.iImageX, this.iImageY);
            AffineTransform scaleTrans = AffineTransform.getScaleInstance(this.iScale, this.iScale);
            this.iTransform.concatenate(scaleTrans);
            g2.drawImage(this.iImage, this.iTransform, null);
            if (this.iUseMark && Mark != null && (imageSize = Math.max(this.iImageWidth, this.iImageHeight) * this.iScale) > (double)MaxNomarkSize) {
                this.drawMark(g2);
            }
        }
    }

    @Override
    public boolean isFocusable() {
        return true;
    }

    public void unzoom() {
        this.iZoom = 1.0;
        this.repaint();
    }

    private void drawMark(Graphics2D g2) {
        g2.setPaint(Color.gray);
        Mark.draw(g2, this);
        if (CopyrightMsg.length() > 0 && Math.abs(this.iZoom - 1.0) < 0.01) {
            g2.setFont(BASEFONT);
            FontRenderContext context = g2.getFontRenderContext();
            Rectangle2D bounds = BASEFONT.getStringBounds(CopyrightMsg, context);
            double offset = 0.5 * ((double)this.getSize().width - this.iPicWidth);
            int x = (int)((double)this.getSize().width - bounds.getWidth() - offset - 10.0);
            int baseline = this.getSize().height - 10;
            g2.setPaint(Color.magenta);
            g2.drawString(CopyrightMsg, x, baseline);
        }
    }

    private boolean alignScrollers(boolean horz, double factor) {
        boolean scroll = false;
        if (horz && this.iHasHorzBar) {
            double orig = this.iZoomCenterXFrac;
            this.iZoomCenterXFrac += factor / this.iPicWidth;
            if (this.iZoomCenterXFrac < this.iMinZoomCenterXFrac) {
                this.iZoomCenterXFrac = this.iMinZoomCenterXFrac;
            } else if (this.iZoomCenterXFrac > this.iMaxZoomCenterXFrac) {
                this.iZoomCenterXFrac = this.iMaxZoomCenterXFrac;
            }
            this.calcFOV();
            this.posHorzScroller();
            scroll = Math.abs(orig - this.iZoomCenterXFrac) > 0.001;
        } else if (!horz && this.iHasVertBar) {
            double orig = this.iZoomCenterYFrac;
            this.iZoomCenterYFrac -= factor / this.iPicHeight;
            if (this.iZoomCenterYFrac < this.iMinZoomCenterYFrac) {
                this.iZoomCenterYFrac = this.iMinZoomCenterYFrac;
            } else if (this.iZoomCenterYFrac > this.iMaxZoomCenterYFrac) {
                this.iZoomCenterYFrac = this.iMaxZoomCenterYFrac;
            }
            this.calcFOV();
            this.posVertScroller();
            scroll = Math.abs(orig - this.iZoomCenterYFrac) > 0.001;
        }
        return scroll;
    }

    private double calcFitScale() {
        double factor;
        double fitScale = 1.0;
        this.iImageWidth = this.iImage.getWidth(null);
        double imageWidth = this.iImageWidth + (double)this.iImageMargin;
        this.iImageHeight = this.iImage.getHeight(null);
        double imageHeight = this.iImageHeight + (double)this.iImageMargin;
        if (imageHeight > (double)this.getSize().height) {
            factor = (double)this.getSize().height / imageHeight;
            imageWidth *= factor;
            fitScale *= factor;
        }
        if (imageWidth > (double)this.getSize().width) {
            factor = (double)this.getSize().width / imageWidth;
            fitScale *= factor;
        }
        return fitScale;
    }

    private double calcScrollX() {
        int horzVisible = this.iHorzBar.getVisibleAmount();
        double scrollX = (double)this.iHorzBar.getValue() / (double)(10000 - horzVisible);
        double scrollImageX = this.iImageXMax - scrollX * (this.iImageXMax - this.iImageXMin);
        return scrollImageX;
    }

    private double calcScrollY() {
        int vertVisible = this.iVertBar.getVisibleAmount();
        double scrollY = (double)this.iVertBar.getValue() / (double)(10000 - vertVisible);
        double scrollImageY = this.iImageYMax - scrollY * (this.iImageYMax - this.iImageYMin);
        return scrollImageY;
    }

    private void calcScaling() {
        this.iHorzBar.removeAdjustmentListener(this.iScrollHandler);
        this.iVertBar.removeAdjustmentListener(this.iScrollHandler);
        this.iImageFitScale = this.calcFitScale();
        this.iScale = this.iImageFitScale * this.iZoom;
        this.iPicWidth = this.iImageWidth * this.iScale;
        this.iPicHeight = this.iImageHeight * this.iScale;
        this.addScrollers();
        this.iImageFitScale = this.calcFitScale();
        this.iScale = this.iImageFitScale * this.iZoom;
        this.iPicWidth = this.iImageWidth * this.iScale;
        this.iPicHeight = this.iImageHeight * this.iScale;
        this.addScrollers();
    }

    private void addScrollers() {
        this.iAddedHorzBar = false;
        this.iAddedVertBar = false;
        this.removeAll();
        if (this.iPicWidth - (double)this.getSize().width > 1.0) {
            this.add((Component)this.iHorzBar, "South");
            if (this.iZoom <= 1.0) {
                this.iZoomCenterXFrac = 0.5;
            }
            this.iAddedHorzBar = true;
            this.iHasHorzBar = true;
        } else {
            this.iHasHorzBar = false;
            this.iZoomCenterXFrac = 0.5;
        }
        if (this.iPicHeight - (double)this.getSize().height > 1.0) {
            this.add((Component)this.iVertBar, "East");
            if (this.iZoom <= 1.0) {
                this.iZoomCenterYFrac = 0.5;
            }
            this.iAddedVertBar = true;
            this.iHasVertBar = true;
        } else {
            this.iHasVertBar = false;
            this.iZoomCenterYFrac = 0.5;
        }
        if (this.iAddedHorzBar || this.iAddedVertBar) {
            this.validate();
        }
    }

    private void setupImageSizePos() {
        this.calcScaling();
        this.calcFOV();
        if (this.iZoom > 1.0) {
            this.setupScrollers();
            this.posHorzScroller();
            this.posVertScroller();
        }
    }

    private void calcFOV() {
        this.iCenteredImageX = 0.5 * ((double)this.getSize().width - this.iPicWidth);
        this.iCenteredImageY = 0.5 * ((double)this.getSize().height - this.iPicHeight);
        if (this.iZoom <= 1.0) {
            this.iZoomCenterXFrac = 0.5;
            this.iZoomCenterYFrac = 0.5;
            this.iImageX = this.iCenteredImageX;
            this.iImageY = this.iCenteredImageY;
        } else {
            double offsetX = this.iPicWidth * (this.iZoomCenterXFrac - 0.5);
            this.iImageX = this.iCenteredImageX - offsetX;
            this.iMaxZoomCenterXFrac = (this.iPicWidth - 0.5 * (double)this.getSize().width) / this.iPicWidth;
            this.iMaxZoomCenterXFrac *= 1.002;
            offsetX = this.iPicWidth * (this.iMaxZoomCenterXFrac - 0.5);
            this.iImageXMin = this.iCenteredImageX - offsetX;
            this.iMinZoomCenterXFrac = 0.5 * (double)this.getSize().width / this.iPicWidth;
            this.iMinZoomCenterXFrac *= 0.998;
            offsetX = this.iPicWidth * (this.iMinZoomCenterXFrac - 0.5);
            this.iImageXMax = this.iCenteredImageX - offsetX;
            double offsetY = this.iPicHeight * (this.iZoomCenterYFrac - 0.5);
            this.iImageY = this.iCenteredImageY - offsetY;
            this.iMaxZoomCenterYFrac = (this.iPicHeight - 0.5 * (double)this.getSize().height) / this.iPicHeight;
            this.iMaxZoomCenterYFrac *= 1.002;
            offsetY = this.iPicHeight * (this.iMaxZoomCenterYFrac - 0.5);
            this.iImageYMin = this.iCenteredImageY - offsetY;
            this.iMinZoomCenterYFrac = 0.5 * (double)this.getSize().height / this.iPicHeight;
            this.iMinZoomCenterYFrac *= 0.998;
            offsetY = this.iPicHeight * (this.iMinZoomCenterYFrac - 0.5);
            this.iImageYMax = this.iCenteredImageY - offsetY;
            this.shiftZoomInCenter();
        }
    }

    private void shiftZoomInCenter() {
        if (this.iMinZoomCenterXFrac < this.iMaxZoomCenterXFrac && this.iZoomCenterXFrac < this.iMinZoomCenterXFrac) {
            this.iZoomCenterXFrac = this.iMinZoomCenterXFrac;
            this.calcFOV();
        } else if (this.iMinZoomCenterXFrac < this.iMaxZoomCenterXFrac && this.iZoomCenterXFrac > this.iMaxZoomCenterXFrac) {
            this.iZoomCenterXFrac = this.iMaxZoomCenterXFrac;
            this.calcFOV();
        } else if (this.iMinZoomCenterYFrac < this.iMaxZoomCenterYFrac && this.iZoomCenterYFrac < this.iMinZoomCenterYFrac) {
            this.iZoomCenterYFrac = this.iMinZoomCenterYFrac;
            this.calcFOV();
        } else if (this.iMinZoomCenterYFrac < this.iMaxZoomCenterYFrac && this.iZoomCenterYFrac > this.iMaxZoomCenterYFrac) {
            this.iZoomCenterYFrac = this.iMaxZoomCenterYFrac;
            this.calcFOV();
        }
    }

    private void setupScrollers() {
        if (this.iAddedVertBar) {
            this.posVertScroller();
            this.iVertBar.addAdjustmentListener(this.iScrollHandler);
            this.iAddedVertBar = false;
        }
        if (this.iAddedHorzBar) {
            this.posHorzScroller();
            this.iHorzBar.addAdjustmentListener(this.iScrollHandler);
            this.iAddedHorzBar = false;
        }
    }

    private void posHorzScroller() {
        this.iIgnoreBarAdjust = true;
        this.iHorzBar.setValue(0);
        int horzVisible = (int)((double)this.getSize().width / this.iPicWidth * 10000.0 + 0.5);
        if (horzVisible > 10000) {
            horzVisible = 10000;
        }
        this.iHorzBar.setVisibleAmount(horzVisible);
        double centerFactor = (this.iZoomCenterXFrac - this.iMinZoomCenterXFrac) / (this.iMaxZoomCenterXFrac - this.iMinZoomCenterXFrac);
        int barValue = (int)(centerFactor * (double)(10000 - horzVisible));
        this.iHorzBar.setValue(barValue);
        this.iIgnoreBarAdjust = false;
    }

    private void posVertScroller() {
        this.iIgnoreBarAdjust = true;
        this.iVertBar.setValue(0);
        int vertVisible = (int)((double)this.getSize().height / this.iPicHeight * 10000.0 + 0.5);
        if (vertVisible > 10000) {
            vertVisible = 10000;
        }
        this.iVertBar.setVisibleAmount(vertVisible);
        double centerFactor = (this.iZoomCenterYFrac - this.iMinZoomCenterYFrac) / (this.iMaxZoomCenterYFrac - this.iMinZoomCenterYFrac);
        int barValue = (int)(centerFactor * (double)(10000 - vertVisible));
        this.iVertBar.setValue(barValue);
        this.iIgnoreBarAdjust = false;
    }

    private class MouseHandler
    extends MouseAdapter {
        private MouseHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent event) {
            ZoomableImagePanel.this.unzoom();
        }
    }

    private class ScrollHandler
    implements AdjustmentListener {
        private ScrollHandler() {
        }

        @Override
        public void adjustmentValueChanged(AdjustmentEvent event) {
            if (!ZoomableImagePanel.this.iIgnoreBarAdjust) {
                if (ZoomableImagePanel.this.iHasHorzBar) {
                    ZoomableImagePanel.this.iImageX = ZoomableImagePanel.this.calcScrollX();
                    ZoomableImagePanel.this.iZoomCenterXFrac = (ZoomableImagePanel.this.iCenteredImageX - ZoomableImagePanel.this.iImageX) / ZoomableImagePanel.this.iPicWidth + 0.5;
                }
                if (ZoomableImagePanel.this.iHasVertBar) {
                    ZoomableImagePanel.this.iImageY = ZoomableImagePanel.this.calcScrollY();
                    ZoomableImagePanel.this.iZoomCenterYFrac = (ZoomableImagePanel.this.iCenteredImageY - ZoomableImagePanel.this.iImageY) / ZoomableImagePanel.this.iPicHeight + 0.5;
                }
                ZoomableImagePanel.this.repaint();
            }
        }
    }

    private class WheelHandler
    implements MouseWheelListener {
        private WheelHandler() {
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent event) {
            if (ZoomableImagePanel.this.iImage != null && ZoomableImagePanel.this.iZoomable) {
                Toolkit tKit = Toolkit.getDefaultToolkit();
                Dimension screen = tKit.getScreenSize();
                double pFactor = 1.0 * (double)ZoomableImagePanel.this.getSize().width / (double)screen.width;
                double scrollFactor = pFactor * 30.0;
                if ((event.getModifiers() & 1) > 0) {
                    this.scrollVert(event, scrollFactor);
                } else if ((event.getModifiers() & 2) > 0) {
                    this.scrollHorz(event, scrollFactor);
                } else if (event.getWheelRotation() < 0) {
                    ZoomableImagePanel.this.zoomIn(0.5);
                } else {
                    ZoomableImagePanel.this.zoomOut(0.5);
                }
            }
        }

        private void scrollHorz(MouseWheelEvent event, double factor) {
            double origX = ZoomableImagePanel.this.iImageX;
            if (event.getWheelRotation() < 0) {
                ZoomableImagePanel zoomableImagePanel = ZoomableImagePanel.this;
                zoomableImagePanel.iImageX = zoomableImagePanel.iImageX - factor;
            } else {
                ZoomableImagePanel zoomableImagePanel = ZoomableImagePanel.this;
                zoomableImagePanel.iImageX = zoomableImagePanel.iImageX + factor;
            }
            double change = origX - ZoomableImagePanel.this.iImageX;
            if (ZoomableImagePanel.this.alignScrollers(true, change)) {
                ZoomableImagePanel.this.repaint();
            } else {
                ZoomableImagePanel.this.iImageX = origX;
            }
        }

        private void scrollVert(MouseWheelEvent event, double factor) {
            double origY = ZoomableImagePanel.this.iImageY;
            if (event.getWheelRotation() < 0) {
                ZoomableImagePanel zoomableImagePanel = ZoomableImagePanel.this;
                zoomableImagePanel.iImageY = zoomableImagePanel.iImageY + factor;
            } else {
                ZoomableImagePanel zoomableImagePanel = ZoomableImagePanel.this;
                zoomableImagePanel.iImageY = zoomableImagePanel.iImageY - factor;
            }
            double change = ZoomableImagePanel.this.iImageY - origY;
            if (ZoomableImagePanel.this.alignScrollers(false, change)) {
                ZoomableImagePanel.this.repaint();
            } else {
                ZoomableImagePanel.this.iImageY = origY;
            }
        }
    }
}

