/*
 * Decompiled with CFR 0.152.
 */
package swing;

import java.awt.Color;
import java.awt.Font;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseWheelEvent;
import java.util.EventObject;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.MutableComboBoxModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import mswing.WheelComboBoxDb;
import swing.EntryField;
import utilt.Utility;

public class WheelComboBox
extends JComboBox<Object> {
    private LinkedList<Listener> iLis = new LinkedList();
    private ComboModel iModel = null;
    private SelHandler iSelHandler = new SelHandler();
    private boolean iWheelEvent = false;
    private boolean iWheelEnabled = true;
    private boolean iKeepOrder = false;
    private int iMaxItems = 50;
    private WheelComboBoxDb iDb = null;
    private boolean iDoCallbacks = true;
    private boolean iAcceptEmpty = true;
    public static final String EMPTY = "";
    public static final String EMPTYVALUE = " ";
    private static LinkedList<WheelComboBox> Instances = new LinkedList();
    private static Color AllFore = SystemColor.windowText;
    private static Color AllBack = SystemColor.window;
    private static Font AllFont = Utility.stdFont();

    public static void putBackColorAll(Color back) {
        AllBack = back;
        for (WheelComboBox box : Instances) {
            box.setBackground(AllBack);
        }
    }

    public static Color backColorAll() {
        return AllBack;
    }

    public static void putFontAll(Font font) {
        AllFont = font;
        for (WheelComboBox box : Instances) {
            box.setFont(AllFont);
        }
    }

    public static void putForeColorAll(Color fore) {
        AllFore = fore;
        for (WheelComboBox box : Instances) {
            box.setForeground(AllFore);
        }
    }

    public WheelComboBox() {
        this.setFont(AllFont);
        this.setBackground(AllBack);
        this.setForeground(AllFore);
        this.setEditor(new Editor());
        this.iModel = new ComboModel();
        this.setModel(this.iModel);
        this.addItemListener(this.iSelHandler);
        this.addMouseWheelListener(new MouseWheelHandler());
        Instances.add(this);
    }

    public void removeFromList() {
        Instances.removeLast();
    }

    public void setDb(WheelComboBoxDb db, boolean addEmpty) {
        this.iDb = db;
        for (Object e : this.iDb.getItems()) {
            this.addItem(e);
        }
        if (addEmpty) {
            this.addItem(EMPTY);
        }
        this.iDb.addBox(this);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.setWheelEnabled(enabled);
    }

    public void setWheelEnabled(boolean enabled) {
        this.iWheelEnabled = enabled;
    }

    public void setKeepOrder(boolean keep) {
        this.iKeepOrder = keep;
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        this.setEditor(new Editor(color, this.getForeground()));
    }

    @Override
    public void setFont(Font font) {
        this.setEditor(new Editor(this.getBackground(), this.getForeground(), font));
        super.setFont(font);
    }

    @Override
    public void setForeground(Color color) {
        super.setForeground(color);
        this.setEditor(new Editor(this.getBackground(), color));
    }

    public boolean hasItem(Object item) {
        return this.items().contains(item);
    }

    @Override
    public void addItem(Object item) {
        if (!this.iKeepOrder && this.hasItem(item)) {
            this.removeItem(item);
            this.iModel.setSelectedItem(item);
        }
        this.iModel.addElement(item);
        if (this.iDb != null) {
            try {
                this.iDb.addItem(item, null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void setItems(Object[] items) {
        this.iModel.removeAllElements();
        String[] toAdd = new String[items.length];
        int i = 0;
        while (i < items.length) {
            toAdd[items.length - i - 1] = items[i];
            ++i;
        }
        i = 0;
        while (i < items.length) {
            this.addItem(toAdd[i]);
            ++i;
        }
        if (this.iModel.getSize() > 0) {
            Object first = this.iModel.getElementAt(0);
            this.setSelectedItem(first);
        }
    }

    public void setItems(LinkedList<Object> items) {
        this.iModel.removeAllElements();
        ListIterator<Object> iter = items.listIterator(items.size());
        while (iter.hasPrevious()) {
            Object item = iter.previous();
            this.addItem(item);
        }
        if (this.iModel.getSize() > 0) {
            Object first = this.iModel.getElementAt(0);
            this.setSelectedItem(first);
        }
    }

    @Override
    public void removeItem(Object item) {
        super.removeItem(item);
        if (this.iDb != null) {
            try {
                this.iDb.removeItem(item, null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void clear() {
        this.iModel.removeAllElements();
    }

    public LinkedList<Object> items() {
        return this.iModel.getItems();
    }

    public int getMaxItems() {
        return this.iMaxItems;
    }

    public int numItems() {
        return this.iModel.getSize();
    }

    public void setAcceptEmpty(boolean accept) {
        this.iAcceptEmpty = accept;
    }

    public void setMaxItems(int maxItems) {
        this.iMaxItems = maxItems;
    }

    public synchronized void addListener(Listener lis) {
        boolean exists = lis == null;
        Iterator iter = this.iLis.iterator();
        while (!exists && iter.hasNext()) {
            boolean bl = exists = iter.next() == lis;
        }
        if (!exists) {
            this.iLis.add(lis);
        }
    }

    public synchronized void removeListener(Listener lis) {
        this.iLis.remove(lis);
    }

    public boolean isDoCallbacks() {
        return this.iDoCallbacks;
    }

    public void setDoCallbacks(boolean callback) {
        this.iDoCallbacks = callback;
    }

    private void fireSelection() {
        if (this.iDoCallbacks) {
            for (Listener lis : this.iLis) {
                lis.selected(new EventObject(this));
            }
        }
    }

    private class ComboModel
    implements MutableComboBoxModel<Object> {
        private LinkedList<ListDataListener> iLis = new LinkedList();
        private LinkedList<Object> iItems = new LinkedList();
        private Object iSelected = null;

        private ComboModel() {
        }

        public LinkedList<Object> getItems() {
            return new LinkedList<Object>(this.iItems);
        }

        public void makeFirst(Object obj) {
            this.iItems.remove(obj);
            this.iItems.addFirst(obj);
            this.fireContentsChanged();
        }

        public int itemIndex(Object obj) {
            int index = -1;
            int i = 0;
            Iterator iter = this.iItems.iterator();
            while (iter.hasNext() && index == -1) {
                if (obj.equals(iter.next())) {
                    index = i;
                    continue;
                }
                ++i;
            }
            return index;
        }

        @Override
        public Object getElementAt(int index) {
            Object obj = null;
            if (index >= 0 && index < this.iItems.size()) {
                obj = this.iItems.get(index);
            }
            return obj;
        }

        @Override
        public int getSize() {
            return this.iItems.size();
        }

        @Override
        public Object getSelectedItem() {
            return this.iSelected;
        }

        @Override
        public void setSelectedItem(Object obj) {
            if (obj != null) {
                this.iSelected = obj;
                if (this.iItems.contains(obj)) {
                    this.fireContentsChanged();
                } else {
                    this.addElement(obj);
                }
            }
        }

        @Override
        public void addElement(Object obj) {
            if (obj != null && (WheelComboBox.this.iAcceptEmpty || obj.toString().length() > 0)) {
                if (this.iItems.contains(obj)) {
                    this.iItems.remove(obj);
                }
                if (this.iItems.size() >= WheelComboBox.this.iMaxItems) {
                    Object last = this.iItems.getLast();
                    this.iItems.remove(last);
                }
                if (WheelComboBox.this.iKeepOrder) {
                    this.iItems.add(obj);
                } else {
                    this.iItems.addFirst(obj);
                }
                this.fireContentsChanged();
            }
        }

        @Override
        public void insertElementAt(Object obj, int index) {
            int len;
            if (obj != null && (len = obj.toString().length()) > 0 && !this.iItems.contains(obj)) {
                if (this.iItems.size() > WheelComboBox.this.iMaxItems) {
                    Object last = this.iItems.getLast();
                    this.iItems.remove(last);
                }
                this.iItems.add(index, obj);
                this.fireContentsChanged();
            }
        }

        @Override
        public void removeElement(Object obj) {
            if (this.iItems.contains(obj)) {
                this.iItems.remove(obj);
                if (this.iSelected != null && this.iSelected.equals(obj)) {
                    this.iSelected = null;
                }
                this.fireContentsChanged();
            }
        }

        @Override
        public void removeElementAt(int index) {
            Object obj = this.iItems.get(index);
            if (obj.equals(this.iSelected)) {
                this.iSelected = null;
            }
            this.iItems.remove(index);
            this.fireContentsChanged();
        }

        public void removeAllElements() {
            this.iItems.clear();
            this.iSelected = null;
            this.fireContentsChanged();
        }

        private void fireContentsChanged() {
            if (WheelComboBox.this.iDoCallbacks) {
                ListDataEvent event = new ListDataEvent(WheelComboBox.this, 0, 0, 0);
                for (ListDataListener lis : this.iLis) {
                    lis.contentsChanged(event);
                }
            }
        }

        @Override
        public synchronized void addListDataListener(ListDataListener lis) {
            boolean exists = lis == null;
            Iterator iter = this.iLis.iterator();
            while (!exists && iter.hasNext()) {
                boolean bl = exists = iter.next() == lis;
            }
            if (!exists) {
                this.iLis.add(lis);
            }
        }

        @Override
        public synchronized void removeListDataListener(ListDataListener lis) {
            this.iLis.remove(lis);
        }
    }

    private class Editor
    extends BasicComboBoxEditor {
        Editor() {
            JTextField field;
            this.editor = field = this.newField();
        }

        Editor(Color back, Color fore) {
            JTextField field = this.newField();
            if (back != null) {
                field.setBackground(back);
            }
            if (fore != null) {
                field.setForeground(fore);
            }
            this.editor = field;
        }

        Editor(Color back, Color fore, Font font) {
            JTextField field = this.newField();
            field.setFont(font);
            if (back != null) {
                field.setBackground(back);
            }
            if (fore != null) {
                field.setForeground(fore);
            }
            this.editor = field;
        }

        private JTextField newField() {
            EntryField field = new EntryField();
            field.setHorizontalAlignment(2);
            field.addFocusListener(new FocusHandler());
            field.addActionListener(new EntryHandler());
            return field;
        }

        private void addItem() {
            String item = (String)WheelComboBox.this.getEditor().getItem();
            if ((item = item.trim()).length() > 0) {
                WheelComboBox.this.iModel.addElement(item);
                WheelComboBox.this.iModel.setSelectedItem(item);
                try {
                    if (WheelComboBox.this.iDb != null) {
                        WheelComboBox.this.iDb.addItem(item, null);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        private class EntryHandler
        implements ActionListener {
            private EntryHandler() {
            }

            @Override
            public void actionPerformed(ActionEvent event) {
                Editor.this.addItem();
            }
        }

        private class FocusHandler
        extends FocusAdapter {
            private FocusHandler() {
            }

            @Override
            public void focusLost(FocusEvent event) {
                Editor.this.addItem();
            }
        }
    }

    public static interface Listener {
        public boolean selected(EventObject var1);
    }

    private class MouseWheelHandler
    extends MouseAdapter {
        private MouseWheelHandler() {
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent event) {
            if (WheelComboBox.this.iWheelEnabled) {
                int selection = WheelComboBox.this.iModel.itemIndex(WheelComboBox.this.getSelectedItem());
                if (event.getWheelRotation() > 0) {
                    if (--selection < 0) {
                        selection = WheelComboBox.this.iModel.getSize() - 1;
                    }
                } else if (event.getWheelRotation() < 0 && ++selection >= WheelComboBox.this.iModel.getSize()) {
                    selection = 0;
                }
                WheelComboBox.this.iWheelEvent = true;
                Object sel = WheelComboBox.this.iModel.getElementAt(selection);
                if (sel != null) {
                    WheelComboBox.this.iModel.setSelectedItem(sel);
                    WheelComboBox.this.fireSelection();
                }
            }
        }
    }

    private class SelHandler
    implements ItemListener {
        private SelHandler() {
        }

        @Override
        public void itemStateChanged(ItemEvent event) {
            Object item = event.getItem();
            if (item != null && item.toString().length() > 0 && event.getStateChange() == 1) {
                if (!WheelComboBox.this.iWheelEvent && !WheelComboBox.this.iKeepOrder && WheelComboBox.this.iModel.getItems().contains(item)) {
                    WheelComboBox.this.iModel.makeFirst(item);
                }
                WheelComboBox.this.iWheelEvent = false;
                WheelComboBox.this.iModel.setSelectedItem(item);
                WheelComboBox.this.fireSelection();
            }
        }
    }
}

