/*
 * Decompiled with CFR 0.152.
 */
package swing;

import java.awt.Canvas;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Label;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.ImageObserver;
import java.net.URL;

public class SplashScreen
implements ImageObserver {
    private Image iImage = null;
    private Label iLabel = new Label("Starting", 1);
    private Frame iFrame = null;
    private long iSplashTime = 0L;
    private static final String DEFAULTIMGFILE = "splash.jpg";

    public SplashScreen(String filename) {
        this.setImage(filename);
    }

    public SplashScreen(URL url) {
        this.setImage(url);
    }

    public SplashScreen() {
    }

    public void setImage(String filename) {
        this.iImage = Toolkit.getDefaultToolkit().getImage(filename);
    }

    public void setImage(URL url) {
        this.iImage = Toolkit.getDefaultToolkit().getImage(url);
    }

    public void splash(String filename) {
        this.splash(Toolkit.getDefaultToolkit().getImage(filename));
    }

    public void splash(URL url) {
        this.splash(Toolkit.getDefaultToolkit().getImage(url));
    }

    public void splash() {
        if (this.iImage != null) {
            this.splash(this.iImage);
        } else {
            this.splash(Toolkit.getDefaultToolkit().getImage(DEFAULTIMGFILE));
        }
    }

    public void splash(Image img) {
        this.iImage = img;
        this.iFrame = new Frame();
        this.iFrame.setUndecorated(true);
        this.iFrame.setCursor(Cursor.getPredefinedCursor(3));
        if (!Toolkit.getDefaultToolkit().prepareImage(this.iImage, 1, 1, this)) {
            return;
        }
    }

    @Override
    public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
        boolean allbits;
        boolean bl = allbits = infoflags == 32;
        if (allbits) {
            this.splashScreen();
        }
        return !allbits;
    }

    private synchronized void splashScreen() {
        if (this.iFrame == null) {
            return;
        }
        final int width = this.iImage.getWidth(null);
        final int height = this.iImage.getHeight(null);
        Canvas canvas = new Canvas(){

            @Override
            public void update(Graphics g) {
                this.paint(g);
            }

            @Override
            public void paint(Graphics g) {
                g.drawImage(SplashScreen.this.iImage, 0, 0, this);
            }

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(width, height);
            }
        };
        this.iFrame.add((Component)canvas, "Center");
        this.iFrame.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = this.iFrame.getSize();
        this.iFrame.setLocation(screenSize.width - frameSize.width >> 1, screenSize.height - frameSize.height >> 1);
        this.iFrame.setVisible(true);
        this.iSplashTime = System.currentTimeMillis();
    }

    public void showStatus(String status) {
        this.iLabel.setText(status);
    }

    public void waitForSplash() {
        MediaTracker mt = new MediaTracker(this.iFrame);
        mt.addImage(this.iImage, 0);
        try {
            mt.waitForID(0);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void waitForSplash(long ms) {
        MediaTracker mt = new MediaTracker(this.iFrame);
        mt.addImage(this.iImage, 0);
        try {
            mt.waitForID(0, ms);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void delayForSplash() {
        int cpus = Runtime.getRuntime().availableProcessors();
        switch (cpus) {
            case 0: 
            case 1: {
                this.waitForSplash();
                break;
            }
            case 2: 
            case 3: {
                this.waitForSplash(1000 / cpus);
                break;
            }
            default: {
                this.waitForSplash();
            }
        }
    }

    public synchronized void splashFor(int ms) {
        if (this.iSplashTime == 0L) {
            return;
        }
        long splashDuration = System.currentTimeMillis() - this.iSplashTime;
        if (splashDuration < (long)ms) {
            try {
                Thread.sleep((long)ms - splashDuration);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public synchronized void dispose() {
        if (this.iFrame != null) {
            this.iFrame.remove(this.iLabel);
            this.iFrame.dispose();
            this.iFrame = null;
            this.iSplashTime = 0L;
        }
    }
}

