/*
 * Decompiled with CFR 0.152.
 */
package swing;

import java.awt.Color;
import java.awt.Font;
import java.awt.SystemColor;
import java.util.LinkedList;
import javax.swing.Icon;
import javax.swing.JLabel;
import swing.SwingProgram;
import utilt.Utility;

public class PanelLabel
extends JLabel {
    private double iSize = 1.0;
    private boolean iChangeColor = true;
    public static final char PROMPT = ':';
    private static LinkedList<PanelLabel> Instances = new LinkedList();
    private static Color AllFore = SystemColor.windowText;
    private static Color AllBack = SwingProgram.DIALOGBACKCOLOR;
    private static Font AllFont = Utility.stdFont();

    public static void putBackColorAll(Color back) {
        AllBack = back;
        for (PanelLabel label : Instances) {
            if (!label.iChangeColor) continue;
            label.setBackground(AllBack);
        }
    }

    public static void putFontAll(Font font) {
        AllFont = font;
        for (PanelLabel label : Instances) {
            label.setFont(AllFont);
        }
    }

    public static void putForeColorAll(Color fore) {
        AllFore = fore;
        for (PanelLabel label : Instances) {
            if (!label.iChangeColor) continue;
            label.setForeground(AllFore);
        }
    }

    public static Font fontAll() {
        return AllFont;
    }

    public static Color foreColorAll() {
        return AllFore;
    }

    public static Color backColorAll() {
        return AllBack;
    }

    public PanelLabel() {
        this.initialize();
    }

    public PanelLabel(String text) {
        text = text.trim();
        if (text.length() > 0) {
            text = " " + text.trim() + " ";
        }
        this.setText(text);
        this.initialize();
    }

    public PanelLabel(String text, char prompt) {
        text = " " + text.trim() + prompt + " ";
        this.setText(text);
        this.initialize();
    }

    public PanelLabel(String text, boolean isDialog) {
        this(text);
        boolean bl = this.iChangeColor = !isDialog;
        if (isDialog) {
            this.setBackground(SwingProgram.DIALOGBACKCOLOR);
            this.setForeground(SystemColor.windowText);
        }
    }

    public PanelLabel(boolean isDialog) {
        this("", isDialog);
    }

    public PanelLabel(Icon icon) {
        super(icon);
        this.initialize();
    }

    public PanelLabel(String text, Icon icon, int alignment) {
        super(text, icon, alignment);
        this.initialize();
    }

    public void setFontSize(double size) {
        this.iSize = size;
        this.setFont(this.getFont());
    }

    private void initialize() {
        this.setHorizontalTextPosition(0);
        this.setVerticalAlignment(0);
        this.setAlignmentX(0.5f);
        this.setBackground(AllBack);
        this.setForeground(AllFore);
        this.setFont(AllFont);
        Instances.add(this);
    }

    public void setChangeColor(boolean change) {
        this.iChangeColor = change;
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        if (this.iSize > 0.0) {
            double size = this.iSize * (double)font.getSize();
            Font otherSize = font.deriveFont((float)size);
            super.setFont(otherSize);
        }
    }
}

