/*
 * Decompiled with CFR 0.152.
 */
package swing;

import java.awt.Shape;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.TreeMap;
import javax.swing.ToolTipManager;
import swing.ColorPanel;

public class HoverMgr
extends MouseAdapter {
    private ColorPanel iPanel = null;
    private TreeMap<String, LinkedList<Hover>> iHovers = new TreeMap();

    public HoverMgr(ColorPanel panel) {
        this.iPanel = panel;
        this.iPanel.addMouseMotionListener(this);
    }

    public Hover add(String group, String text, Shape shape) {
        LinkedList<Hover> list = this.iHovers.get(group);
        if (list == null) {
            list = new LinkedList();
        }
        Hover hover = new Hover(text, shape);
        list.add(hover);
        this.iHovers.put(group, list);
        return hover;
    }

    @Override
    public void mouseMoved(MouseEvent event) {
        Hover hover = this.findHover(event);
        if (hover == null) {
            ToolTipManager.sharedInstance().setEnabled(false);
        } else {
            ToolTipManager.sharedInstance().setEnabled(true);
            this.iPanel.setToolTipText(hover.text());
        }
    }

    @Override
    public void mouseExited(MouseEvent event) {
    }

    @Override
    public void mouseDragged(MouseEvent event) {
    }

    public Hover findHover(MouseEvent event) {
        Hover hover = null;
        int x = event.getX();
        int y = event.getY();
        Iterator<LinkedList<Hover>> lists = this.iHovers.values().iterator();
        while (hover == null && lists.hasNext()) {
            LinkedList<Hover> list = lists.next();
            Iterator hovers = list.iterator();
            while (hover == null && hovers.hasNext()) {
                Hover aHover = (Hover)hovers.next();
                if (!aHover.includes(x, y)) continue;
                hover = aHover;
            }
        }
        return hover;
    }

    public void clear(String group) {
        LinkedList<Hover> list = this.iHovers.get(group);
        if (list != null) {
            list.clear();
        }
    }

    public void clear() {
        this.iHovers.clear();
    }

    private class Hover {
        private Shape iShape = null;
        private String iText = null;

        public Hover(String text, Shape shape) {
            this.iText = text;
            this.iShape = shape;
        }

        public String text() {
            return this.iText;
        }

        public boolean includes(int x, int y) {
            boolean includes = this.iShape.contains(x, y);
            return includes;
        }

        public String toString() {
            String str = String.valueOf(this.text()) + ":" + this.iShape;
            return str;
        }
    }
}

