/*
 * Decompiled with CFR 0.152.
 */
package swing;

import filedialog.FileChooser;
import filedialog.FileChooserFilter;
import filedialog.FilePopupObject;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import mswing.Preferences;
import swing.ColorButton;
import swing.ColorPanel;
import swing.EntryField;

public class FileSelector
extends ColorPanel {
    private FileChooser iChooser = null;
    private Preferences iPref = null;
    private Frame iOwner = null;
    private FileChooserFilter iFilter = null;
    private ColorButton iButton = new ColorButton(">");
    private EntryField iField = new EntryField();

    public FileSelector(Preferences pref, FileChooserFilter filter, Frame owner) {
        this.setLayout(new BorderLayout());
        this.add((Component)this.iField, "Center");
        this.add((Component)this.iButton, "West");
        this.iButton.addActionListener(new ActionHandler());
        this.iFilter = filter;
        this.iPref = pref;
        this.iOwner = owner;
        this.iButton.setToolTipText("Program selector");
    }

    public String getText() {
        return this.iField.getText();
    }

    public void setText(String text) {
        this.iField.setText(text);
    }

    private class ActionHandler
    implements ActionListener {
        private ActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            FileSelector.this.iChooser = new FileChooser(FileSelector.this.iPref, FileSelector.this.iFilter, false, false, false, FileSelector.this.iOwner, "File Selection", true, false);
            FileSelector.this.iChooser.center(0.7, 0.7);
            FileSelector.this.iChooser.setFont(FileSelector.this.iPref.menuFont());
            FileSelector.this.iChooser.addListener(new ChooserHandler());
            FileSelector.this.iChooser.setTitle("Select File");
            FileSelector.this.iChooser.setMultipleSelect(false);
            FileSelector.this.iChooser.setVisible(true);
        }
    }

    private class ChooserHandler
    implements FileChooser.Listener {
        private ChooserHandler() {
        }

        @Override
        public void selected(FileChooser.Event event) {
            LinkedList<FilePopupObject> selections = event.selections();
            FilePopupObject popup = selections.getFirst();
            if (popup != null) {
                String path = popup.getName();
                FileSelector.this.iField.setText(path);
            }
        }

        @Override
        public void message(FileChooser.Event event) {
        }
    }
}

