/*
 * Decompiled with CFR 0.152.
 */
package swing;

import java.awt.Color;
import java.awt.Font;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.LinkedList;
import javax.swing.JTextField;
import mlib.MShiftBuffer;
import mswing.StdColor;
import swing.SwingProgram;
import utilt.Utility;

public class EntryField
extends JTextField {
    private MShiftBuffer iHistory = new MShiftBuffer(0);
    private int iHistPos = 0;
    private boolean iHilight = false;
    private LinkedList<ActionListener> iActLis = new LinkedList();
    private static LinkedList<EntryField> Instances = new LinkedList();
    private static Color AllFore = SystemColor.windowText;
    private static Color AllBack = StdColor.PALEYELLOW.color();
    private static Color AllHilight = SystemColor.control;
    private static Font AllFont = Utility.stdFont();

    public static void putBackColorAll(Color back) {
        AllBack = back;
        for (EntryField field : Instances) {
            field.setBackground(AllBack);
        }
    }

    public static void putFontAll(Font font) {
        AllFont = font;
        for (EntryField field : Instances) {
            field.setFont(AllFont);
        }
    }

    public static void putForeColorAll(Color fore) {
        AllFore = fore;
        for (EntryField field : Instances) {
            field.setForeground(AllFore);
        }
    }

    public static void putHilightColorAll(Color color) {
        AllHilight = color;
        for (EntryField field : Instances) {
            field.setForeground(AllFore);
        }
    }

    public static Color backColorAll() {
        return AllBack;
    }

    public static Font fontAll() {
        return AllFont;
    }

    public static void putActivityListenerAll(ActionListener listener) {
        for (EntryField field : Instances) {
            field.addActivityListener(listener);
        }
    }

    public EntryField() {
        this.initialize();
    }

    public EntryField(String text) {
        super(text);
        this.initialize();
    }

    public EntryField(int histSize) {
        this.iHistory = new MShiftBuffer(histSize);
        this.initialize();
    }

    public void addHistory(String text) {
        if (this.iHistory.size() > 0) {
            this.iHistory.addUnique(text);
            this.iHistPos = 0;
        }
    }

    public void setHilight(boolean hilight) {
        this.iHilight = hilight;
    }

    public void addActivityListener(ActionListener listener) {
        this.iActLis.add(listener);
    }

    private void initialize() {
        this.setBackground(AllBack);
        this.setForeground(AllFore);
        this.setFont(AllFont);
        this.setHorizontalAlignment(2);
        Instances.add(this);
        if (this.iHistory.size() > 0) {
            this.addKeyListener(new KeyHandler());
        }
        this.addMouseListener(new MouseHandler());
    }

    private class KeyHandler
    extends KeyAdapter {
        private KeyHandler() {
        }

        @Override
        public void keyReleased(KeyEvent event) {
            if (EntryField.this.iHistory.numObjs() > 0) {
                Object[] objs = EntryField.this.iHistory.mostRecentObjs(999);
                int key = event.getKeyCode();
                if (key == 38 || key == 224) {
                    EntryField entryField = EntryField.this;
                    entryField.iHistPos = entryField.iHistPos + 1;
                    if (EntryField.this.iHistPos >= objs.length) {
                        EntryField.this.iHistPos = objs.length - 1;
                    }
                    String str = (String)objs[EntryField.this.iHistPos];
                    EntryField.this.setText(str);
                } else if (key == 40 || key == 225) {
                    EntryField entryField = EntryField.this;
                    entryField.iHistPos = entryField.iHistPos - 1;
                    if (EntryField.this.iHistPos < 0) {
                        EntryField.this.iHistPos = 0;
                    }
                    String str = (String)objs[EntryField.this.iHistPos];
                    EntryField.this.setText(str);
                }
            }
        }
    }

    private class MouseHandler
    extends MouseAdapter {
        private Color iBackColor = null;

        private MouseHandler() {
        }

        @Override
        public void mouseEntered(MouseEvent event) {
            this.iBackColor = EntryField.this.getBackground();
            EntryField.this.setBorder(SwingProgram.STDBORDER);
            if (EntryField.this.iHilight) {
                EntryField.this.setBackground(AllHilight);
            }
            this.fireActivity();
        }

        @Override
        public void mouseExited(MouseEvent event) {
            EntryField.this.setBorder(SwingProgram.STDBORDER);
            if (EntryField.this.iHilight) {
                EntryField.this.setBackground(this.iBackColor);
            }
            this.fireActivity();
        }

        private void fireActivity() {
            for (ActionListener lis : EntryField.this.iActLis) {
                lis.actionPerformed(new ActionEvent(this, 504, ""));
            }
        }
    }
}

