/*
 * Decompiled with CFR 0.152.
 */
package swing;

import dialog.CenteredDialog;
import dialog.DialogEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import javax.swing.JPanel;
import swing.EntryField;
import swing.PanelLabel;

public class EntryDialog
extends CenteredDialog {
    private EntryPanel iEntryPanel = new EntryPanel();

    public EntryDialog(Frame owner, String prompt) {
        super(owner);
        this.setModal(false);
        this.addClientPanel(this.iEntryPanel);
        this.iEntryPanel.setPrompt(prompt);
        this.center(this.calcHorzFrac(), this.calcVertFrac());
        this.setResizable(false);
        this.setTitle("Entry Dialog");
    }

    public String obtainEntry() {
        return this.iEntryPanel.obtainEntry();
    }

    public float calcHorzFrac() {
        return 0.5f;
    }

    public float calcVertFrac() {
        int pixSize = this.iEntryPanel.getFont().getSize();
        Toolkit tKit = Toolkit.getDefaultToolkit();
        Dimension screen = tKit.getScreenSize();
        float vertFrac = (float)(pixSize + 100) / (float)screen.height;
        return vertFrac;
    }

    @Override
    public void custom(int index, DialogEvent event) {
    }

    private class EntryPanel
    extends JPanel {
        private PanelLabel iPrompt = new PanelLabel();
        private EntryField iEntry = new EntryField();

        EntryPanel() {
            this.iPrompt = new PanelLabel();
            this.iPrompt.setText("Prompt:");
            this.setLayout(new BorderLayout());
            this.setSize(503, 53);
            this.add((Component)this.iPrompt, "West");
            this.add((Component)this.iEntry, "Center");
        }

        public void setPrompt(String prompt) {
            this.iPrompt.setText(prompt);
        }

        public String obtainEntry() {
            return this.iEntry.getText();
        }
    }
}

