/*
 * Decompiled with CFR 0.152.
 */
package swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerListModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import swing.PanelLabel;
import swing.WheelListSpinner;
import utilt.Utility;

public class DatePanel
extends JPanel {
    private JSpinner jYearSpinner = null;
    private JSpinner jUncerSpinner = null;
    private JSpinner jMonthSpinner = null;
    private JSpinner jDaySpinner = null;
    private JSpinner jHourSpinner = null;
    private static final String EMPTYSTR = "";
    private static final String UNCER = "+/-";
    private static final String UNCEREND = "yr";
    public static final String[] MONTHS = new String[]{"", "Win", "Jan", "Feb", "Mar", "Spr", "Apr", "May", "Jun", "Sum", "Jul", "Aug", "Sep", "Fal", "Oct", "Nov", "Dec"};
    private static final int NOVALUE = -1;
    private static final int[] CALMONTHS;
    private static final int MONTHSPERSEASON = 3;
    private static final int[] DAYSINMONTH;
    private static final String[] UNCERS;
    private static final String[] DAYS;
    private static final String[] HOURS;
    private static final int[] HOURVALUES;
    private static final int MINYEAR = 1850;
    private static final int MAXYEAR = 2100;
    private static LinkedList<DatePanel> Instances;
    private static Color AllFore;
    private static Color AllBack;
    private static Font AllFont;
    private static Color CustomBack;

    static {
        int[] nArray = new int[17];
        nArray[0] = -1;
        nArray[1] = -1;
        nArray[3] = 1;
        nArray[4] = 2;
        nArray[5] = -1;
        nArray[6] = 3;
        nArray[7] = 4;
        nArray[8] = 5;
        nArray[9] = -1;
        nArray[10] = 6;
        nArray[11] = 7;
        nArray[12] = 8;
        nArray[13] = -1;
        nArray[14] = 9;
        nArray[15] = 10;
        nArray[16] = 11;
        CALMONTHS = nArray;
        DAYSINMONTH = new int[]{-1, -1, 31, 29, 31, -1, 30, 31, 30, -1, 31, 31, 30, -1, 31, 30, 31};
        UNCERS = new String[]{EMPTYSTR, "+/-0yr", "+/-1yr", "+/-2yr", "+/-3yr", "+/-4yr", "+/-5yr", "+/-10yr", "+/-15yr", "+/-25yr", "+/-50yr", "+/-100yr"};
        DAYS = new String[]{EMPTYSTR, "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "30", "31"};
        HOURS = new String[]{EMPTYSTR, "AM", "1AM", "2AM", "3AM", "4AM", "5AM", "6AM", "7AM", "8AM", "9AM", "10AM", "11AM", "PM", "12PM", "1PM", "2PM", "3PM", "4PM", "5PM", "6PM", "7PM", "8PM", "9PM", "10PM", "11PM", "12AM"};
        HOURVALUES = new int[]{-1, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26};
        Instances = new LinkedList();
        AllFore = SystemColor.windowText;
        AllBack = SystemColor.window;
        AllFont = Utility.stdFont();
        CustomBack = new Color(240, 240, 240);
    }

    public static void putFontAll(Font font) {
        AllFont = font;
        for (DatePanel panel : Instances) {
            panel.putEntryColors(AllBack, AllFore);
        }
    }

    public static void putForeColorAll(Color fore) {
        AllFore = fore;
        for (DatePanel panel : Instances) {
            panel.putEntryColors(AllBack, AllFore);
        }
    }

    public static void putBackColorAll(Color back) {
        AllBack = back;
        for (DatePanel panel : Instances) {
            panel.putEntryColors(AllBack, AllFore);
        }
    }

    public static String dateString(int year, int month, int day) {
        String dateStr = EMPTYSTR;
        GregorianCalendar cal = new GregorianCalendar();
        SimpleDateFormat dmyFormatter = new SimpleDateFormat("dd-MMM-yyyy");
        SimpleDateFormat myFormatter = new SimpleDateFormat("MMM-yyyy");
        SimpleDateFormat yFormatter = new SimpleDateFormat("yyyy");
        if (month != -1 && day != -1) {
            cal.set(year, CALMONTHS[month], day);
            Date date = cal.getTime();
            dateStr = dmyFormatter.format(date);
        } else if (month != -1) {
            if (CALMONTHS[month] != -1) {
                cal.set(year, CALMONTHS[month], 1);
                Date date = cal.getTime();
                dateStr = myFormatter.format(date);
            } else {
                dateStr = String.valueOf(MONTHS[month]) + "-";
                dateStr = String.valueOf(dateStr) + Integer.toString(year);
            }
        } else {
            cal.set(year, 0, 1);
            Date date = cal.getTime();
            dateStr = yFormatter.format(date);
        }
        return dateStr;
    }

    public static boolean monthsMatch(int month1, int month2) {
        boolean match;
        boolean bl = match = month1 == month2;
        if (!match) {
            if (CALMONTHS[month1] == -1) {
                match = month2 >= month1 && month2 <= month1 + 3;
            } else if (CALMONTHS[month2] == -1) {
                match = month1 >= month2 && month1 <= month2 + 3;
            }
        }
        return match;
    }

    public static int month(String month) {
        int result = -1;
        int i = 0;
        while (i < MONTHS.length) {
            if (MONTHS[i].equalsIgnoreCase(month)) {
                result = i;
                break;
            }
            ++i;
        }
        return result;
    }

    public static String hourToStr(int hour) {
        String hourStr = null;
        int i = 0;
        while (i < HOURS.length && hourStr == null) {
            if (HOURVALUES[i] == hour) {
                hourStr = HOURS[i];
            }
            ++i;
        }
        return hourStr;
    }

    public DatePanel(boolean showHour, boolean showLabels) {
        this.setLayout(new BoxLayout(this, 0));
        this.setBackground(Color.white);
        if (showLabels) {
            this.setupWithLabels(showHour);
        } else {
            this.add(this.getYearSpinner());
            this.add(this.getUncerSpinner());
            this.add(this.getMonthSpinner());
            this.add(this.getDaySpinner());
            if (showHour) {
                this.add(this.getHourSpinner());
            }
        }
        this.putEntryColors(AllBack, AllFore);
        Instances.add(this);
    }

    public void putYearRange(int min, int max) {
        Object[] years = new String[max - min + 2];
        years[0] = EMPTYSTR;
        int i = 1;
        while (i < years.length) {
            years[i] = Integer.toString(min + i - 1);
            ++i;
        }
        this.getYearSpinner().setModel(new SpinnerListModel(years));
    }

    public void putYear(int year) {
        if (year != -1) {
            this.getYearSpinner().setValue(Integer.toString(year));
        }
    }

    public void putUncer(int uncer) {
        if (uncer != -1) {
            this.getUncerSpinner().setValue(UNCER + uncer + UNCEREND);
        }
    }

    public void putMonth(int month) {
        if (month != -1) {
            this.getMonthSpinner().setValue(MONTHS[month]);
        }
    }

    public void putDay(int day) {
        if (day != -1) {
            this.getDaySpinner().setValue(Integer.toString(day));
        }
    }

    public void putHour(int hour) {
        if (hour != -1) {
            String hourStr = DatePanel.hourToStr(hour);
            this.getHourSpinner().setValue(hourStr);
        }
    }

    public void putEntryColors(Color back, Color fore) {
        AllBack = back;
        AllFore = fore;
        this.setupEditor(this.getYearSpinner(), back, fore, 1, AllFont);
        this.setupEditor(this.getUncerSpinner(), back, fore, 1, AllFont);
        this.setupEditor(this.getMonthSpinner(), back, fore, 1, AllFont);
        this.setupEditor(this.getDaySpinner(), back, fore, 1, AllFont);
        this.setupEditor(this.getHourSpinner(), back, fore, 1, AllFont);
    }

    public int obtainUncer() {
        int uncer = -1;
        String value = (String)this.getUncerSpinner().getValue();
        if ((value = value.trim()).length() > 0) {
            value = value.substring(UNCER.length());
            int index = value.indexOf(UNCEREND);
            if ((value = value.substring(0, index)).length() > 0) {
                uncer = Integer.parseInt(value);
            }
        }
        return uncer;
    }

    public int obtainYear() {
        int year = -1;
        String value = (String)this.getYearSpinner().getValue();
        if ((value = value.trim()).length() > 0) {
            year = Integer.parseInt(value);
        }
        return year;
    }

    public int obtainMonth() {
        int month = -1;
        String value = (String)this.getMonthSpinner().getValue();
        int i = 1;
        while (i < MONTHS.length) {
            if (value.equals(MONTHS[i])) {
                month = i;
                break;
            }
            ++i;
        }
        return month;
    }

    public int obtainDay() {
        int day = -1;
        String value = (String)this.getDaySpinner().getValue();
        if ((value = value.trim()).length() > 0) {
            day = Integer.parseInt(value);
        }
        return day;
    }

    public int obtainHour() {
        String str = (String)this.getHourSpinner().getValue();
        int hour = -999;
        int i = 0;
        while (i < HOURS.length && hour == -999) {
            if (str.equals(HOURS[i])) {
                hour = HOURVALUES[i];
            }
            ++i;
        }
        return hour;
    }

    public void clear() {
        this.getYearSpinner().setValue(EMPTYSTR);
        this.getUncerSpinner().setValue(EMPTYSTR);
        this.getMonthSpinner().setValue(EMPTYSTR);
        this.getDaySpinner().setValue(EMPTYSTR);
        this.getHourSpinner().setValue(EMPTYSTR);
    }

    @Override
    public void setEnabled(boolean enabled) {
        Font font = AllFont;
        Color fore = AllFore;
        Color back = AllBack;
        if (!enabled) {
            back = CustomBack;
            font = AllFont.deriveFont(1);
        }
        this.setupEditor(this.getYearSpinner(), back, fore, 1, font);
        this.setupEditor(this.getUncerSpinner(), back, fore, 1, font);
        this.setupEditor(this.getMonthSpinner(), back, fore, 1, font);
        this.setupEditor(this.getDaySpinner(), back, fore, 1, font);
        this.setupEditor(this.getHourSpinner(), back, fore, 1, font);
        this.getYearSpinner().setEnabled(enabled);
        this.getUncerSpinner().setEnabled(enabled);
        this.getMonthSpinner().setEnabled(enabled);
        this.getDaySpinner().setEnabled(enabled);
        this.getHourSpinner().setEnabled(enabled);
    }

    public String testIfValid() {
        String msg = null;
        int day = this.obtainDay();
        int month = this.obtainMonth();
        int year = this.obtainYear();
        if (day != -1) {
            if (month == -1 || year == -1 || CALMONTHS[month] == -1) {
                msg = "If day specified, month and year must be also";
            }
            if (msg == null && day > DAYSINMONTH[month]) {
                msg = "Invalid day date";
            }
        }
        if (msg == null && month != -1 && year == -1) {
            msg = "If month specified, year must be also";
        }
        if (msg == null && this.obtainUncer() != -1 && year == -1) {
            msg = "If uncertainty specified, year must be also";
        }
        return msg;
    }

    private JSpinner getYearSpinner() {
        if (this.jYearSpinner == null) {
            Object[] years = new String[252];
            years[0] = EMPTYSTR;
            int i = 1;
            while (i < years.length) {
                years[i] = Integer.toString(1850 + i - 1);
                ++i;
            }
            this.jYearSpinner = new WheelListSpinner(new SpinnerListModel(years));
        }
        return this.jYearSpinner;
    }

    private JSpinner getUncerSpinner() {
        if (this.jUncerSpinner == null) {
            this.jUncerSpinner = new WheelListSpinner(new SpinnerListModel(UNCERS));
        }
        return this.jUncerSpinner;
    }

    private JSpinner getMonthSpinner() {
        if (this.jMonthSpinner == null) {
            this.jMonthSpinner = new WheelListSpinner(new SpinnerListModel(MONTHS));
        }
        return this.jMonthSpinner;
    }

    private JSpinner getDaySpinner() {
        if (this.jDaySpinner == null) {
            this.jDaySpinner = new WheelListSpinner(new SpinnerListModel(DAYS));
        }
        return this.jDaySpinner;
    }

    private JSpinner getHourSpinner() {
        if (this.jHourSpinner == null) {
            this.jHourSpinner = new WheelListSpinner(new SpinnerListModel(HOURS));
        }
        return this.jHourSpinner;
    }

    private void setupEditor(JSpinner spinner, Color back, Color fore, int columns, Font font) {
        SpinnerListModel model = (SpinnerListModel)spinner.getModel();
        model.removeChangeListener((ChangeListener)((Object)spinner.getEditor()));
        Editor editor = new Editor(model, columns, font);
        editor.setBackground(back);
        editor.setForeground(fore);
        spinner.setEditor(editor);
    }

    private void setupWithLabels(boolean showHour) {
        JPanel year = new JPanel();
        year.setLayout(new BorderLayout());
        PanelLabel label = new PanelLabel("Year");
        label.setHorizontalAlignment(0);
        year.add((Component)label, "North");
        year.add((Component)this.getYearSpinner(), "Center");
        this.add(year);
        JPanel uncer = new JPanel();
        uncer.setLayout(new BorderLayout());
        label = new PanelLabel("Uncer");
        label.setHorizontalAlignment(0);
        uncer.add((Component)label, "North");
        uncer.add((Component)this.getUncerSpinner(), "Center");
        this.add(uncer);
        JPanel mon = new JPanel();
        mon.setLayout(new BorderLayout());
        label = new PanelLabel("Month");
        label.setHorizontalAlignment(0);
        mon.add((Component)label, "North");
        mon.add((Component)this.getMonthSpinner(), "Center");
        this.add(mon);
        JPanel day = new JPanel();
        day.setLayout(new BorderLayout());
        label = new PanelLabel("Day");
        label.setHorizontalAlignment(0);
        day.add((Component)label, "North");
        day.add((Component)this.getDaySpinner(), "Center");
        this.add(day);
        if (showHour) {
            JPanel hour = new JPanel();
            hour.setLayout(new BorderLayout());
            label = new PanelLabel("Hour");
            label.setHorizontalAlignment(0);
            hour.add((Component)label, "North");
            hour.add((Component)this.getHourSpinner(), "Center");
            this.add(hour);
        }
    }

    private class Editor
    extends JTextField
    implements ActionListener,
    ChangeListener,
    FocusListener {
        private SpinnerListModel iModel = null;

        Editor(SpinnerListModel model, int columns, Font font) {
            this.iModel = model;
            this.setText((String)model.getValue());
            this.addActionListener(this);
            this.addFocusListener(this);
            this.iModel.addChangeListener(this);
            this.setColumns(columns);
            this.setFont(font);
        }

        @Override
        public void stateChanged(ChangeEvent event) {
            this.setText((String)this.iModel.getValue());
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            this.update();
        }

        @Override
        public void focusLost(FocusEvent event) {
            this.update();
        }

        @Override
        public void focusGained(FocusEvent event) {
        }

        private void update() {
            String curValue = (String)this.iModel.getValue();
            boolean found = false;
            Iterator<?> values = this.iModel.getList().iterator();
            while (!found && values.hasNext()) {
                String value = (String)values.next();
                if (!value.equalsIgnoreCase(this.getText().trim())) continue;
                this.iModel.setValue(value);
                found = true;
            }
            if (!found) {
                this.setText(curValue);
            }
        }
    }
}

