/*
 * Decompiled with CFR 0.152.
 */
package swing;

import java.awt.Color;
import java.awt.Font;
import java.awt.SystemColor;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.LinkedList;
import javax.swing.Icon;
import javax.swing.JButton;
import utilt.Utility;

public class ColorButton
extends JButton {
    private boolean iShowBorder = false;
    private Color iForeColor = AllFore;
    private Color iBackColor = AllBack;
    private static LinkedList<ColorButton> Instances = new LinkedList();
    private static Color AllFore = SystemColor.controlText;
    private static Color AllBack = SystemColor.control;
    private static Font AllFont = Utility.stdFont();

    public static void putBackColorAll(Color back) {
        AllBack = back;
        for (ColorButton button : Instances) {
            button.setBackground(AllBack);
        }
    }

    public static void putFontAll(Font font) {
        AllFont = font;
        for (ColorButton button : Instances) {
            button.setFont(AllFont);
        }
    }

    public static void putActivityListenerAll(ActionListener listener) {
        for (ColorButton button : Instances) {
            button.addActionListener(listener);
        }
    }

    public static Font fontAll() {
        return AllFont;
    }

    public static Color foreColorAll() {
        return AllFore;
    }

    public static Color backColorAll() {
        return AllBack;
    }

    public static void putForeColorAll(Color fore) {
        AllFore = fore;
        for (ColorButton button : Instances) {
            button.setForeground(AllFore);
        }
    }

    public ColorButton() {
        this.initialize();
    }

    public ColorButton(String text) {
        text = text.trim();
        if (text.length() > 0) {
            text = " " + text.trim() + " ";
        }
        this.setText(text);
        this.initialize();
    }

    public ColorButton(String text, Icon icon) {
        super(icon);
        text = text.trim();
        if (text.length() > 0) {
            text = " " + text.trim() + " ";
        }
        this.setText(text);
        this.initialize();
    }

    public ColorButton(Icon icon) {
        super(icon);
        this.initialize();
    }

    @Override
    public void setForeground(Color color) {
        super.setForeground(color);
        this.iForeColor = color;
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        this.iBackColor = color;
    }

    @Override
    public void setEnabled(boolean enable) {
        super.setEnabled(enable);
        this.setBorderPainted(false);
        this.setForeground(this.iForeColor);
    }

    public void setShowBorder(boolean show) {
        this.iShowBorder = show;
        this.setBorderPainted(this.iShowBorder);
    }

    private void initialize() {
        this.setBackground(AllBack);
        this.setForeground(AllFore);
        this.setFont(AllFont);
        this.setBorderPainted(this.iShowBorder);
        this.addMouseListener(new MouseHandler());
        this.addFocusListener(new FocusHandler());
        Instances.add(this);
    }

    private class FocusHandler
    extends FocusAdapter {
        private FocusHandler() {
        }

        @Override
        public void focusLost(FocusEvent event) {
            if (ColorButton.this.isEnabled()) {
                ColorButton.this.setBorderPainted(ColorButton.this.iShowBorder);
            }
        }
    }

    private class MouseHandler
    extends MouseAdapter {
        private MouseHandler() {
        }

        @Override
        public void mouseEntered(MouseEvent event) {
            if (ColorButton.this.isEnabled()) {
                ColorButton.this.setBorderPainted(true);
                ColorButton.this.setBackground(ColorButton.this.iBackColor);
            }
        }

        @Override
        public void mouseExited(MouseEvent event) {
            if (ColorButton.this.isEnabled()) {
                ColorButton.this.setBorderPainted(ColorButton.this.iShowBorder);
                ColorButton.this.setBackground(ColorButton.this.iBackColor);
            }
        }
    }
}

