/*
 * Decompiled with CFR 0.152.
 */
package swing;

import java.awt.Color;
import java.awt.Font;
import java.awt.SystemColor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.util.LinkedList;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.border.Border;
import swing.DigitLongCounter;

public class AdjustableDigit
extends JLabel {
    private boolean iAdjustable = true;
    private DigitLongCounter iCounter = null;
    private int iDigitPos = 0;
    private long iFactor = 0L;
    private boolean iLocked = false;
    private MouseHandler iMouseHandler = new MouseHandler();
    private static LinkedList<AdjustableDigit> Instances = new LinkedList();
    private static Color AllFore = SystemColor.controlText;
    private static Color AllBack = SystemColor.control;
    private static Color AllSelection = SystemColor.control;
    private static Font AllFont = new Font("SansSerif", 1, 40);
    private static Border EmptyBorder = BorderFactory.createEmptyBorder(2, 2, 2, 2);
    private static Border EtchedBorder = BorderFactory.createEtchedBorder();

    public static void putBackColorAll(Color back) {
        AllBack = back;
        for (AdjustableDigit digit : Instances) {
            digit.setBackground(AllBack);
        }
    }

    public static void putFontAll(Font font) {
        AllFont = font;
        for (AdjustableDigit digit : Instances) {
            digit.setFont(AllFont);
        }
    }

    public static Font fontAll() {
        return AllFont;
    }

    public static void putForeColorAll(Color fore) {
        AllFore = fore;
        for (AdjustableDigit digit : Instances) {
            digit.setForeground(AllFore);
        }
    }

    public static void putSelectionColorAll(Color focus) {
        AllSelection = focus;
    }

    public AdjustableDigit(DigitLongCounter counter, int digitPos, boolean adjustable) {
        this.iCounter = counter;
        this.iDigitPos = digitPos;
        this.iAdjustable = adjustable;
        this.iFactor = (long)(Math.pow(10.0, this.iDigitPos) + 0.5);
        this.initialize();
        counter.addDigit(this);
    }

    public void putText(DigitLongCounter counter) {
        String digit = String.valueOf(new String()) + counter.digitChar(this.iDigitPos);
        this.setText(digit);
    }

    private void initialize() {
        this.setOpaque(true);
        this.setText("0");
        this.setHorizontalAlignment(0);
        if (this.iAdjustable) {
            this.addMouseListener(this.iMouseHandler);
        }
        if (this.iAdjustable) {
            this.addMouseWheelListener(this.iMouseHandler);
        }
        this.setBackground(AllBack);
        this.setForeground(AllFore);
        this.setFont(AllFont);
        this.setBorder(EmptyBorder);
        Instances.add(this);
    }

    public void setLocked(boolean lock) {
        this.iLocked = lock;
    }

    private class MouseHandler
    extends MouseAdapter {
        private MouseHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent event) {
            if (!AdjustableDigit.this.iLocked) {
                boolean ctrlDown;
                boolean bl = ctrlDown = (event.getModifiers() & 2) > 0;
                if (ctrlDown) {
                    AdjustableDigit.this.iCounter.zero(AdjustableDigit.this.iDigitPos);
                } else {
                    long factor = AdjustableDigit.this.iFactor * (long)AdjustableDigit.this.iCounter.getStep();
                    if ((event.getModifiers() & 0x10) > 0) {
                        AdjustableDigit.this.iCounter.change(-1L * factor);
                    } else if ((event.getModifiers() & 4) > 0) {
                        AdjustableDigit.this.iCounter.change(factor);
                    }
                }
            }
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent event) {
            if (!AdjustableDigit.this.iLocked) {
                long factor = AdjustableDigit.this.iFactor * (long)AdjustableDigit.this.iCounter.getStep();
                long value = -1L * factor * (long)event.getWheelRotation();
                if (value == 0L) {
                    value = -1 * event.getWheelRotation();
                }
                AdjustableDigit.this.iCounter.change(value);
            }
        }

        @Override
        public void mouseEntered(MouseEvent event) {
            if (!AdjustableDigit.this.iLocked && AdjustableDigit.this.iCounter.digitChar(AdjustableDigit.this.iDigitPos) != ' ') {
                AdjustableDigit.this.setBackground(AllSelection);
                AdjustableDigit.this.setBorder(EtchedBorder);
            }
        }

        @Override
        public void mouseExited(MouseEvent event) {
            if (!AdjustableDigit.this.iLocked) {
                AdjustableDigit.this.setBackground(AllBack);
                AdjustableDigit.this.setBorder(EmptyBorder);
            }
        }
    }
}

