/*
 * Decompiled with CFR 0.152.
 */
package mswing;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedList;
import mlib.MLogging;
import swing.WheelComboBox;

public class WheelComboBoxDb
implements Serializable {
    private int iMaxItems = 50;
    private LinkedList<Object> iItems = new LinkedList();
    private transient LinkedList<WheelComboBox> iBoxes = new LinkedList();
    private transient String iPath = null;
    private static final long serialVersionUID = 2692375932792971619L;

    public static WheelComboBoxDb read(String path) throws Exception {
        ObjectInputStream in = new ObjectInputStream(new FileInputStream(path));
        WheelComboBoxDb db = (WheelComboBoxDb)in.readObject();
        in.close();
        db.setPath(path);
        db.iBoxes = new LinkedList();
        return db;
    }

    public WheelComboBoxDb(String path, int maxItems) throws Exception {
        this.iPath = path;
        this.iMaxItems = maxItems;
    }

    public String path() {
        return this.iPath;
    }

    public void setPath(String path) {
        this.iPath = path;
    }

    public void addBox(WheelComboBox box) {
        this.iBoxes.add(box);
    }

    public boolean addItem(Object item, WheelComboBox sender) throws Exception {
        boolean added = this.isNewItem(item);
        if (added) {
            if (this.iItems.size() >= this.iMaxItems) {
                this.iItems.removeFirst();
            }
            this.iItems.addLast(item);
            for (WheelComboBox box : this.iBoxes) {
                if (sender == null || box == sender) continue;
                box.addItem(item);
            }
        }
        return added;
    }

    public void removeItem(Object item, WheelComboBox sender) throws Exception {
        this.iItems.remove(item);
        for (WheelComboBox box : this.iBoxes) {
            if (sender == null || box == sender) continue;
            box.removeItem(item);
        }
    }

    public void setItems(LinkedList<Object> items, WheelComboBox sender) throws Exception {
        this.iItems.clear();
        int count = 0;
        Iterator iter = items.iterator();
        while (iter.hasNext() && count++ <= this.iMaxItems) {
            Object item = iter.next();
            this.iItems.add(item);
        }
        for (WheelComboBox box : this.iBoxes) {
            if (sender == null || box == sender) continue;
            box.setDoCallbacks(false);
            box.setDoCallbacks(true);
        }
    }

    public void clear(WheelComboBox sender) throws Exception {
        this.iItems.clear();
        for (WheelComboBox box : this.iBoxes) {
            if (sender == null || box == sender) continue;
            box.removeAllItems();
        }
    }

    public void list(MLogging logger) {
        logger.writeln(String.valueOf(this.getClass().getName()) + ": " + this.iPath, false);
        for (Object e : this.iItems) {
            if (e.getClass() == String.class) {
                String str = (String)e;
                String text = str;
                if (text.length() == 0) {
                    text = "blank";
                }
                logger.writeln("   |" + text + "|", false);
                continue;
            }
            logger.writeln("   |" + e.toString() + "|", false);
        }
    }

    public LinkedList<Object> getItems() {
        return this.iItems;
    }

    public void save() throws Exception {
        ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(this.iPath));
        out.writeObject(this);
        out.close();
    }

    public String toString() {
        String str = String.valueOf(this.iPath) + "," + this.iItems.size();
        return str;
    }

    private boolean isNewItem(Object item) {
        boolean isNew = true;
        if (item.getClass() == String.class) {
            String str = (String)item;
            Iterator iter = this.iItems.iterator();
            while (isNew && iter.hasNext()) {
                Object next = iter.next();
                if (next.getClass() != String.class) continue;
                String aStr = (String)next;
                isNew &= !str.equalsIgnoreCase(aStr);
            }
        } else {
            isNew = !this.iItems.contains(item);
        }
        return isNew;
    }
}

