/*
 * Decompiled with CFR 0.152.
 */
package mlib;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.StringTokenizer;
import mlib.MString;

public class MWildcard
implements Serializable,
Comparable<MWildcard> {
    private String iPattern = null;
    private String[] iTokens = null;
    private boolean[] iNegates = null;
    public static final String MATCHALLSTR = "*";
    public static final char MATCHALLCHAR = '*';
    public static final MWildcard MATCHALL = new MWildcard("*");
    public static final char NEGATE = '!';
    public static final char TOKENDELIM = '|';
    static final long serialVersionUID = -5900742419330393606L;

    public static void main(String[] args) {
        MWildcard wcard = new MWildcard("*.txt|zz*|*z*");
        System.out.println(wcard.matchesAny("y.txt"));
        System.out.println(wcard.matchesAny("zzyy"));
        System.out.println(wcard.matchesAny("z"));
        System.out.println(wcard.matchesAny("y"));
    }

    private static boolean matchesStr(String pattern, String str) {
        pattern = pattern.toLowerCase();
        String text = String.valueOf(str.toLowerCase()) + '\u0000';
        pattern = String.valueOf(pattern) + '\u0000';
        int n = pattern.length();
        boolean[] states = new boolean[n + 1];
        boolean[] old = new boolean[n + 1];
        old[0] = true;
        int i = 0;
        while (i < text.length()) {
            char c = text.charAt(i);
            states = new boolean[n + 1];
            int j = 0;
            while (j < n) {
                char p = pattern.charAt(j);
                if (old[j] && p == '*') {
                    old[j + 1] = true;
                }
                if (old[j] && p == c) {
                    states[j + 1] = true;
                }
                if (old[j] && p == '.') {
                    states[j + 1] = true;
                }
                if (old[j] && p == '*') {
                    states[j] = true;
                }
                if (old[j] && p == '*') {
                    states[j + 1] = true;
                }
                ++j;
            }
            old = states;
            ++i;
        }
        return states[n];
    }

    public MWildcard() {
        this(MATCHALLSTR);
    }

    public MWildcard(String pattern) {
        this.iPattern = pattern.trim();
    }

    public MWildcard(MString pattern) {
        this(pattern.toString());
    }

    public String pattern() {
        return this.iPattern;
    }

    public void putPattern(String pattern) {
        this.iPattern = pattern;
    }

    public int numNegates() {
        this.setupTokens();
        int num = 0;
        int i = 0;
        while (i < this.iTokens.length) {
            if (this.iNegates[i]) {
                ++num;
            }
            ++i;
        }
        return num;
    }

    public boolean matches(String str) {
        this.setupTokens();
        boolean matches = false;
        int i = 0;
        while (i < this.iTokens.length && !matches) {
            boolean match = MWildcard.matchesStr(this.iTokens[i], str);
            if (this.iNegates[i]) {
                match = !match;
            }
            matches |= match;
            ++i;
        }
        return matches;
    }

    public boolean matches(MString str) {
        String work = str.toString();
        return this.matches(work);
    }

    public boolean matchesAny(String[] strs) {
        this.setupTokens();
        boolean matches = false;
        if (this.iTokens != null && this.iTokens.length > 0) {
            int i = 0;
            while (!matches && i < strs.length) {
                int j = 0;
                while (j < this.iTokens.length && !matches) {
                    boolean match = MWildcard.matchesStr(this.iTokens[i], strs[j]);
                    if (this.iNegates[i]) {
                        match = !match;
                    }
                    matches |= match;
                    ++j;
                }
                ++i;
            }
        }
        return matches;
    }

    public boolean matchesAny(String str) {
        this.setupTokens();
        boolean matches = false;
        StringTokenizer tken = new StringTokenizer(str, ",");
        if (this.iTokens != null && tken.countTokens() > 0) {
            while (!matches && tken.hasMoreTokens()) {
                String token = tken.nextToken();
                int i = 0;
                while (i < this.iTokens.length && !matches) {
                    boolean match = MWildcard.matchesStr(this.iTokens[i], token);
                    if (this.iNegates[i]) {
                        match = !match;
                    }
                    matches |= match;
                    ++i;
                }
            }
        }
        return matches;
    }

    public boolean matchesAll(String str) {
        this.setupTokens();
        int matchCount = 0;
        StringTokenizer tken = new StringTokenizer(str, ",");
        if (this.iTokens != null && tken.countTokens() > 0) {
            String[] tokens = new String[tken.countTokens()];
            int i = 0;
            while (tken.hasMoreTokens()) {
                tokens[i++] = tken.nextToken();
            }
            i = 0;
            while (i < this.iTokens.length) {
                boolean tokenMatch = false;
                int j = 0;
                while (j < tokens.length) {
                    boolean match = MWildcard.matchesStr(this.iTokens[i], tokens[j]);
                    if (this.iNegates[i]) {
                        match = !match;
                    }
                    tokenMatch |= match;
                    ++j;
                }
                if (tokenMatch) {
                    ++matchCount;
                }
                ++i;
            }
        }
        return matchCount == this.iTokens.length;
    }

    public boolean approxMatches(MString other, int minLen, boolean caseSens) {
        this.setupTokens();
        boolean matches = false;
        int i = 0;
        while (i < this.iTokens.length && !matches) {
            boolean match = other.approxMatches(new MString(this.iTokens[i]), minLen, caseSens);
            if (this.iNegates[i]) {
                match = !match;
            }
            matches |= match;
            ++i;
        }
        return matches;
    }

    public String toString() {
        return this.iPattern;
    }

    @Override
    public int compareTo(MWildcard wc) {
        int result = 0;
        if (wc != this) {
            result = -1;
            if (wc != null) {
                result = this.iPattern.toLowerCase().compareTo(wc.iPattern.toLowerCase());
            }
        }
        return result;
    }

    public boolean equals(MWildcard wc) {
        return this.compareTo(wc) == 0;
    }

    public int hashCode() {
        String path = this.iPattern.toLowerCase();
        return path.hashCode();
    }

    private void setupTokens() {
        if (this.iTokens == null) {
            StringTokenizer tken = new StringTokenizer(this.iPattern, "|");
            int numTokens = tken.countTokens();
            this.iTokens = new String[numTokens];
            this.iNegates = new boolean[numTokens];
            int i = 0;
            while (tken.hasMoreTokens()) {
                String token = tken.nextToken().trim();
                if (token.charAt(0) == '!') {
                    this.iNegates[i] = true;
                    token = token.substring(1);
                }
                if (token.length() == 0) {
                    token = MATCHALLSTR;
                }
                this.iTokens[i] = token;
                ++i;
            }
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.setupTokens();
    }
}

