/*
 * Decompiled with CFR 0.152.
 */
package mlib;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;

public class MPackedDate
implements Serializable {
    private short iDate = 0;
    private static final SimpleDateFormat DATEFORMAT = new SimpleDateFormat("dd-MMM-yyyy");

    public MPackedDate(Calendar date) {
        int day = date.get(5);
        int month = date.get(2) + 1;
        int year = date.get(1) - 1980;
        int packed = 0;
        packed |= year << 10;
        int mask = 64512;
        packed &= mask;
        packed |= month << 6;
        mask = 65472;
        packed &= mask;
        this.iDate = (short)(packed |= day);
    }

    public MPackedDate(short date) {
        this.iDate = date;
    }

    public Calendar toCalendar() {
        short year = (short)(this.iDate >> 10);
        int mask = 63;
        year = (short)(year & mask);
        year = (short)(year + 1980);
        short day = (short)(this.iDate & mask);
        short month = (short)(this.iDate >> 6);
        mask = 15;
        month = (short)(month & mask);
        month = (short)(month - 1);
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(1, year);
        cal.set(2, month);
        cal.set(5, day);
        return cal;
    }

    public int compareTo(MPackedDate date) {
        int res = 0;
        if (date != this) {
            res = -1;
            if (date != null) {
                res = this.iDate - date.iDate;
            }
        }
        return res;
    }

    public boolean equals(MPackedDate date) {
        return this.compareTo(date) == 0;
    }

    public int hashCode() {
        return this.iDate;
    }

    public String toString() {
        Calendar cal = this.toCalendar();
        String str = DATEFORMAT.format(cal.getTime());
        return str;
    }
}

