/*
 * Decompiled with CFR 0.152.
 */
package mlib;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import javax.swing.JTextArea;
import mlib.MLogging;

public abstract class MLogger
implements MLogging {
    private boolean iEnabled = true;
    private boolean iIncludeTime = false;
    private String iPrefix = "";
    private MLogging iLinked = null;
    private int iNumLines = 0;
    private int iMaxLines = Integer.MAX_VALUE;
    public static final char SPACE = ' ';
    public static final char TAB = '\t';
    public static final char CR = '\r';
    public static final char LF = '\n';
    public static final String ERROR = "*** ";
    public static final String INDENT = "   ";
    public static final String DOUBLEINDENT = "      ";
    public static final String NEWLINE = "\r\n";
    public static final String TWONEWLINES = "\r\n\r\n";
    public static final String PAUSE = "...";
    public static final String OK = "OK";
    private static final SimpleDateFormat DAYTIME = new SimpleDateFormat("yyyy-MM-dd'@'HH:mm:ss");
    private static boolean AllEnabled = true;

    public static void EnableAll(boolean enable) {
        AllEnabled = enable;
    }

    @Override
    public boolean isEnabled() {
        return this.iEnabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.iEnabled = enabled;
    }

    @Override
    public boolean isIncludeTime() {
        return this.iIncludeTime;
    }

    @Override
    public void setIncludeTime(boolean include) {
        this.iIncludeTime = include;
    }

    @Override
    public void setPrefix(String prefix) {
        this.iPrefix = prefix;
        if (this.iLinked != null) {
            this.iLinked.setPrefix(prefix);
        }
    }

    @Override
    public String prefix() {
        return this.iPrefix;
    }

    @Override
    public MLogging linked() {
        return this.iLinked;
    }

    @Override
    public void setLinked(MLogging linked) {
        this.iLinked = linked;
    }

    @Override
    public int maxLines() {
        return this.iMaxLines;
    }

    @Override
    public void setMaxLines(int maxLines) {
        this.iMaxLines = maxLines;
        if (this.iLinked != null) {
            this.iLinked.setMaxLines(maxLines);
        }
    }

    @Override
    public void writeln(String text, boolean error) {
        if (AllEnabled && this.isEnabled() && this.iNumLines < this.iMaxLines) {
            if (!text.endsWith(NEWLINE)) {
                text = String.valueOf(text) + NEWLINE;
            }
            this.write(text, error);
            ++this.iNumLines;
            if (this.linked() != null) {
                this.linked().writeln(text, error);
            }
        }
    }

    @Override
    public void writeln(String text) {
        this.writeln(text, false);
    }

    @Override
    public void clear() {
    }

    @Override
    public void close() {
    }

    @Override
    public Collection<String> lines() {
        return new LinkedList<String>();
    }

    protected MLogger() {
    }

    protected String format(String text, boolean error) {
        mlib.MString formatted = new mlib.MString(text);
        try {
            formatted.trim(' ');
            if (formatted.charAt(0) == '\r') {
                formatted.trimHead('\r');
                formatted.insert(this.iPrefix, 0);
            } else {
                formatted.insert(this.iPrefix, 0);
            }
            boolean isOk = text.startsWith(OK);
            if (this.isIncludeTime() && !isOk) {
                Date date = new Date();
                formatted.insert(' ', 0);
                formatted.insert(DAYTIME.format(date), 0);
            }
            if (error) {
                formatted.insert(ERROR, 0);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return formatted.toString();
    }

    public static class Empty
    extends MLogger {
        @Override
        public void write(String text, boolean error) {
        }

        @Override
        public void write(String text) {
            this.write(text, false);
        }
    }

    public static class File
    extends MLogger {
        private PrintWriter iOut = null;

        public File(String path, boolean append) throws Exception {
            this.iOut = new PrintWriter(new BufferedWriter(new FileWriter(path, append)));
        }

        @Override
        public void write(String text, boolean error) {
            if (AllEnabled && this.isEnabled()) {
                text = this.format(text, error);
                this.iOut.print(text);
                this.iOut.flush();
            }
        }

        @Override
        public void write(String text) {
            this.write(text, false);
        }

        @Override
        public void close() {
            this.iOut.close();
        }
    }

    public static class List
    extends MLogger {
        private LinkedList<String> iLines = new LinkedList();

        @Override
        public void write(String text, boolean error) {
            if (AllEnabled && this.isEnabled()) {
                text = this.format(text, error);
                this.iLines.add(text);
            }
        }

        @Override
        public void write(String text) {
            this.write(text, false);
        }

        @Override
        public Collection<String> lines() {
            return this.iLines;
        }
    }

    public static class MString
    extends MLogger {
        private mlib.MString iString = new mlib.MString();

        @Override
        public void write(String text, boolean error) {
            if (AllEnabled && this.isEnabled()) {
                text = this.format(text, error);
                this.iString.concat(text);
            }
        }

        @Override
        public void write(String text) {
            this.write(text, false);
        }

        public String string() {
            return this.iString.toString();
        }

        @Override
        public void clear() {
            this.iString.clear();
        }
    }

    public static class System
    extends MLogger {
        @Override
        public void write(String text, boolean error) {
            if (AllEnabled && this.isEnabled()) {
                text = this.format(text, error);
                java.lang.System.out.print(text);
            }
        }

        @Override
        public void write(String text) {
            this.write(text, false);
        }
    }

    public static class TextArea
    extends MLogger {
        private JTextArea iTextArea = null;

        public TextArea(JTextArea textArea) {
            this.iTextArea = textArea;
        }

        @Override
        public void write(String text, boolean error) {
            if (AllEnabled && this.isEnabled()) {
                text = this.format(text, error);
                this.iTextArea.append(text);
            }
        }

        @Override
        public void write(String text) {
            this.write(text, false);
        }
    }
}

