/*
 * Decompiled with CFR 0.152.
 */
package mlib;

import java.util.ArrayList;
import mlib.MString;

public class MCmdParser {
    private char iValuesPrefix = (char)61;
    private char iValuesDelim = (char)44;

    public static void main(String[] args) {
        String cmd = " aaa bbb=one ccc  =  two ,";
        cmd = String.valueOf(cmd) + "three ddd eee =\"four to five\" z=10 ";
        MCmdParser parser = new MCmdParser('=', ',');
        Arguments work = parser.parse(cmd);
        System.out.println(work);
    }

    public MCmdParser(char valuesPrefix, char valuesDelim) {
        this.iValuesPrefix = valuesPrefix;
        this.iValuesDelim = valuesDelim;
    }

    public Arguments parse(String cmd) {
        cmd = this.clean(cmd);
        Arguments args = new Arguments();
        if (cmd.length() > 0) {
            boolean inLiteral = false;
            int tokenStart = 0;
            int i = 0;
            while (i < cmd.length()) {
                char aChar = cmd.charAt(i);
                if (aChar == ' ' && !inLiteral) {
                    String token = cmd.substring(tokenStart, i);
                    token = token.trim();
                    args.add(Arg.parse(token, this.iValuesPrefix, this.iValuesDelim));
                    tokenStart = i + 1;
                } else if (aChar == '\"') {
                    inLiteral = !inLiteral;
                }
                ++i;
            }
            String token = cmd.substring(tokenStart);
            args.add(Arg.parse(token, this.iValuesPrefix, this.iValuesDelim));
        }
        return args;
    }

    private String clean(String cmd) {
        MString work = new MString(cmd);
        work.replace('\t', ' ');
        work.trimWhitespace();
        work.replaceRepetition(' ');
        work.removeWhitespaceBefore(this.iValuesPrefix);
        work.removeWhitespaceAfter(this.iValuesPrefix);
        work.removeWhitespaceBefore(this.iValuesDelim);
        work.removeWhitespaceAfter(this.iValuesDelim);
        return work.toString();
    }

    public static class Arg {
        private String iName = "";
        private String[] iValues = null;

        static Arg parse(String token, char valuesPrefix, char valuesDelim) {
            Arg arg = new Arg();
            int pos = token.indexOf(valuesPrefix);
            if (pos <= 0) {
                arg.iName = token;
            } else {
                arg.iName = token.substring(0, pos);
                token = token.substring(pos + 1);
                token = token.replace('\"', ' ');
                if ((token = token.trim()).length() > 0) {
                    arg.parseValues(token, valuesDelim);
                }
            }
            return arg;
        }

        public String getName() {
            return this.iName;
        }

        public String[] getValues() {
            return this.iValues;
        }

        public String obtainValue(int number) {
            String value = null;
            if (number >= 0 && number < this.iValues.length) {
                value = this.iValues[number];
            }
            return value;
        }

        public void show() {
            System.out.print(this);
        }

        void parseValues(String values, char valuesDelim) {
            int valueEnd;
            ArrayList<String> work = new ArrayList<String>();
            while ((valueEnd = values.indexOf(valuesDelim)) > 0) {
                String value = values.substring(0, valueEnd);
                work.add(value);
                values = values.substring(valueEnd + 1);
            }
            if (values.length() > 0) {
                work.add(values);
            }
            if (work.size() > 0) {
                this.iValues = new String[work.size()];
                int i = 0;
                while (i < this.iValues.length) {
                    this.iValues[i] = (String)work.get(i);
                    ++i;
                }
            }
        }

        public String toString() {
            String str = "name=" + this.iName;
            if (this.iValues != null) {
                str = String.valueOf(str) + ",values=";
                int i = 0;
                while (i < this.iValues.length) {
                    if (i > 0) {
                        str = String.valueOf(str) + ",";
                    }
                    str = String.valueOf(str) + this.iValues[i];
                    ++i;
                }
            }
            return str;
        }
    }

    public static class Arguments {
        private ArrayList<Arg> iArgs = new ArrayList();

        public void add(Arg arg) {
            this.iArgs.add(arg);
        }

        public int numArgs() {
            int num = 0;
            if (this.iArgs != null) {
                num = this.iArgs.size();
            }
            return num;
        }

        public Arg arg(String name) {
            Arg arg = null;
            boolean done = false;
            int i = 0;
            while (!done && i < this.numArgs()) {
                Arg anArg = this.iArgs.get(i);
                if (anArg.iName.equals(name)) {
                    arg = anArg;
                    done = true;
                }
                ++i;
            }
            return arg;
        }

        public Arg argNoCase(String name) {
            Arg arg = null;
            boolean done = false;
            int i = 0;
            while (!done && i < this.numArgs()) {
                Arg anArg = this.iArgs.get(i);
                if (anArg.iName.equalsIgnoreCase(name)) {
                    arg = anArg;
                    done = true;
                }
                ++i;
            }
            return arg;
        }

        public Arg arg(int number) {
            Arg arg = null;
            if (number < this.numArgs()) {
                arg = this.iArgs.get(number);
            }
            return arg;
        }

        public Arg[] allArgs() {
            Arg[] args = new Arg[this.numArgs()];
            int i = 0;
            while (i < args.length) {
                args[i] = this.iArgs.get(i);
                ++i;
            }
            return args;
        }

        public String toString() {
            String str = "";
            int i = 0;
            while (i < this.iArgs.size()) {
                str = String.valueOf(str) + this.iArgs.get(i).toString() + " ";
                ++i;
            }
            return str;
        }
    }
}

