/*
 * Decompiled with CFR 0.152.
 */
package minstall;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Date;
import java.util.LinkedList;
import mlib.MLogger;
import mlib.MLogging;
import mlib.MString;
import utilt.Utility;

public class Installation
implements Serializable {
    private Date iDate = new Date();
    private Date iUpdated = null;
    private MString iDir = null;
    private boolean iDemo = false;
    private int iCounter = 0;
    private LinkedList<String> iUpdates = null;
    private transient String iRegisterDirName = null;
    private transient String iRegisterFileName = null;
    private static final int OFFSET = 9;
    protected static final String DELIM = ",";
    static final long serialVersionUID = 8412434244678079177L;
    public static final String LOGFILENAME = "log.txt";
    public static Installation Singleton = new Installation();

    public static Installation singleton() {
        return Singleton;
    }

    public static void main(String[] args) {
        try {
            Installation.read(".bpv", "a52gg8lpk.ins");
            Installation install = Singleton;
            System.out.println(install.toString());
        }
        catch (Exception xcp) {
            System.out.println(xcp);
        }
    }

    public static boolean read(String registerDirName, String registerFileName) {
        boolean result = false;
        ObjectInputStream in = null;
        try {
            try {
                String pathName = String.valueOf(System.getProperty("user.home")) + File.separator + registerDirName + File.separator + registerFileName;
                in = new ObjectInputStream(new FileInputStream(pathName));
                Singleton = (Installation)in.readObject();
                Installation.Singleton.iRegisterDirName = registerDirName;
                Installation.Singleton.iRegisterFileName = registerFileName;
                result = true;
            }
            catch (Exception exception) {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (Exception exception2) {}
            }
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception exception) {}
        }
        return result;
    }

    public String dir() {
        MString work = (MString)this.iDir.clone();
        return work.decode(9).toString();
    }

    public void setDir(String userInstallDir) {
        if (!userInstallDir.endsWith(File.separator)) {
            userInstallDir = String.valueOf(userInstallDir) + File.separatorChar;
        }
        MString work = new MString(userInstallDir);
        this.iDir = work.encode(9);
    }

    public Date date() {
        return this.iDate;
    }

    public Date updated() {
        if (this.iUpdated == null) {
            this.iUpdated = new Date();
        }
        return this.iUpdated;
    }

    public void setUpdated(Date date) {
        this.iUpdated = date;
    }

    public LinkedList<String> updates() {
        return this.iUpdates;
    }

    public int counter() {
        return this.iCounter;
    }

    public void incCounter() {
        ++this.iCounter;
    }

    public boolean isDemo() {
        return this.iDemo;
    }

    public void setDemo(boolean demo) {
        this.iDemo = demo;
    }

    public MLogging fileLogger() throws Exception {
        String logFileName = String.valueOf(this.dir()) + LOGFILENAME;
        MLogger.File logger = new MLogger.File(logFileName, false);
        logger.setIncludeTime(true);
        return logger;
    }

    public void write(String registerDirName, String registerFileName) throws IOException {
        boolean write = true;
        if (this.iRegisterDirName != null && (write = registerDirName.equals(Installation.Singleton.iRegisterDirName))) {
            write = registerFileName.equals(Installation.Singleton.iRegisterFileName);
        }
        if (!write) {
            throw new IOException("Installation file can be written to only one file location");
        }
        String pathName = String.valueOf(System.getProperty("user.home")) + File.separator + registerDirName;
        File file = new File(pathName);
        file.mkdir();
        pathName = String.valueOf(pathName) + File.separator + registerFileName;
        ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(pathName));
        out.writeObject(this);
        out.close();
    }

    public String toString() {
        String str = "Installation: " + Utility.DMY.format(this.iDate);
        if (this.dir() != null) {
            str = String.valueOf(str) + DELIM + this.dir();
        }
        str = String.valueOf(str) + DELIM + this.iDemo + DELIM + this.iCounter;
        if (this.iUpdates != null) {
            for (String update : this.iUpdates) {
                str = String.valueOf(str) + DELIM + update;
            }
        }
        return str;
    }

    protected Installation() {
        Singleton = this;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.iUpdates == null) {
            this.iUpdates = new LinkedList();
        }
    }
}

