/*
 * Decompiled with CFR 0.152.
 */
package math;

import java.text.DecimalFormat;
import math.DistStats;
import org.apache.commons.math3.distribution.TDistribution;
import utilt.Utility;

public class WelchTTest {
    private String iName = "";
    private double iSigma = 0.0;
    private double it = 0.0;
    private double idf = 0.0;
    private double ip = 0.0;
    private static final DecimalFormat FORMAT = new DecimalFormat("0.000");

    public static void main(String[] args) {
        try {
            WelchTTest test = new WelchTTest(20.6, Math.sqrt(9.0), 10, 22.1, Math.sqrt(0.9), 20);
            double f = 2.58f;
            test = new WelchTTest("outcome1", 73.5, 9.9 / f, 675, 75.0, 2.9 / f, 7805);
            System.out.println(test);
            test = new WelchTTest("outcome2", 68.6, 4.3 / f, 3661, 73.8, 1.2 / f, 48985);
            System.out.println(test);
            test = new WelchTTest("outcome3", 65.8, 8.3 / f, 970, 69.9, 2.4 / f, 12048);
            System.out.println(test);
            test = new WelchTTest("outcome7", 67.6, 12.4 / f, 435, 67.5, 2.9 / f, 8172);
            System.out.println(test);
            test = new WelchTTest("outcome8", 68.4, 5.4 / f, 2269, 70.3, 1.6 / f, 27013);
            System.out.println(test);
            test = new WelchTTest("outcome10", 77.1, 12.8 / f, 406, 76.0, 3.6 / f, 5107);
            System.out.println(test);
            test = new WelchTTest("outcome11", 71.3, 11.0 / f, 551, 73.7, 3.2 / f, 6676);
            System.out.println(test);
        }
        catch (Exception xcp) {
            System.out.println(xcp);
        }
    }

    public WelchTTest(double mean1, double sigma1, int size1, double mean2, double sigma2, int size2) throws Exception {
        if (size1 <= 1 || size2 <= 1) {
            Utility.throwError("Too few datapoints");
        } else {
            this.iSigma = Math.sqrt(sigma1 * sigma1 / (double)size1 + sigma2 * sigma2 / (double)size2);
            this.it = Math.abs(mean1 - mean2) / this.iSigma;
            double factor = sigma1 * sigma1 / (double)size1;
            double denom1 = factor * factor / (double)(size1 - 1);
            factor = sigma2 * sigma2 / (double)size2;
            double denom2 = factor * factor / (double)(size2 - 1);
            double numer = this.iSigma * this.iSigma * this.iSigma * this.iSigma;
            this.idf = numer / (denom1 + denom2);
            TDistribution dist = new TDistribution(this.idf);
            this.ip = 2.0 * (1.0 - dist.cumulativeProbability(this.it));
        }
    }

    public WelchTTest(String name, double mean1, double sigma1, int size1, double mean2, double sigma2, int size2) throws Exception {
        this(mean1, sigma1, size1, mean2, sigma2, size2);
        this.iName = name;
    }

    public WelchTTest(DistStats stats1, DistStats stats2) throws Exception {
        this(stats1.avg(), stats1.sigma(), stats1.numValues(), stats2.avg(), stats2.sigma(), stats2.numValues());
    }

    public double tt() {
        return this.it;
    }

    public double df() {
        return this.idf;
    }

    public double p() {
        return this.ip;
    }

    public String name() {
        return this.iName;
    }

    public String toString() {
        String str = String.valueOf(Utility.objPrefix(this)) + this.iName + ", t(" + FORMAT.format(this.idf) + ") -> " + FORMAT.format(this.ip);
        return str;
    }
}

