/*
 * Decompiled with CFR 0.152.
 */
package math;

import math.DataBin;
import math.DataModel;
import math.DiffCorr;
import math.LinearModel;

public class QuadraticModel
extends DataModel {
    public static final String CONSTX2 = "constX2";
    public static final String CONSTX = "constX";
    public static final String CONST = "const";

    public static QuadraticModel fit(DataBin.Dataset dataset) {
        LinearModel linModel = LinearModel.fit(dataset);
        DataModel.Parm slope = linModel.parm("slope");
        DataModel.Parm yinter = linModel.parm("yinter");
        QuadraticModel model = new QuadraticModel(0.0, slope.value(), yinter.value());
        DataModel[] models1 = new DataModel[]{model};
        DiffCorr diffCorr = new DiffCorr(dataset, models1);
        int status = diffCorr.iterate();
        if (status != 0) {
            model = null;
        }
        return model;
    }

    public QuadraticModel(double initConstX2, double initConstX, double initConst) {
        DataModel.Parm[] state = new DataModel.Parm[]{new DataModel.Parm(CONSTX2, initConstX2), new DataModel.Parm(CONSTX, initConstX), new DataModel.Parm(CONST, initConst)};
        this.setState(state);
    }

    @Override
    public double value(DataBin bin) {
        DataModel.Parm[] state = this.state();
        double value = state[0].value() * (double)bin.center() * (double)bin.center() + state[1].value() * (double)bin.center() + state[2].value();
        return value;
    }

    @Override
    public double partialDeriv(DataBin bin, DataModel.Parm parm) {
        double deriv = 0.0;
        DataModel.Parm[] state = this.state();
        int index = parm.index();
        deriv = index == state[0].index() ? (double)(bin.center() * bin.center()) : (index == state[1].index() ? (double)bin.center() : 1.0);
        return deriv;
    }
}

