/*
 * Decompiled with CFR 0.152.
 */
package math;

import Jama.Matrix;
import java.text.DecimalFormat;
import math.Covariance;
import math.DataBin;
import math.Dataset;
import math.DistStats;
import math.GaussianModel;
import math.XYpoint;
import org.apache.commons.math3.distribution.FDistribution;
import org.apache.commons.math3.distribution.TDistribution;
import utilt.Utility;

public class LinearRegression {
    private Matrix iX = null;
    private Matrix iY = null;
    private int iNumY;
    private int iNumX;
    private Matrix iB = null;
    private Matrix iFit = null;
    private Matrix iCovariance = null;
    private double iResidualSS;
    private double iTotalSS;
    private double iRegressionSS;
    private TDistribution iTdist = null;
    private static final DecimalFormat FORMAT = new DecimalFormat("0.000");

    public static void main(String[] args) {
        double[][] x = new double[][]{{1.0, 11.0}, {1.0, 20.0}, {1.0, 30.0}, {1.0, 40.0}, {1.0, 50.0}};
        double[] y = new double[]{10.0, 12.0, 13.0, 15.0, 16.0};
        try {
            double[] fit;
            LinearRegression regression = new LinearRegression(x, y);
            System.out.println(regression);
            double[] dArray = fit = regression.fit();
            int n = fit.length;
            int n2 = 0;
            while (n2 < n) {
                double value = dArray[n2];
                System.out.println(value);
                ++n2;
            }
        }
        catch (Exception xcp) {
            System.out.println(xcp);
        }
    }

    public LinearRegression(double[][] x, double[] y) throws Exception {
        if (x.length != y.length) {
            Utility.throwError("Invalid dimensions");
        }
        this.iNumY = y.length;
        this.iNumX = x[0].length;
        this.iX = new Matrix(x);
        this.iY = new Matrix(y, this.iNumY);
        Matrix xT = this.iX.transpose();
        Matrix xTxxT = xT.times(this.iX).inverse().times(xT);
        this.iB = xTxxT.times(this.iY);
        Matrix projection = this.iX.times(xTxxT);
        this.iFit = projection.times(this.iY);
        Matrix resid = this.iY.minus(this.iFit);
        this.iResidualSS = resid.transpose().times(resid).trace();
        double variance = this.iResidualSS / (double)(this.iNumY - this.iNumX - 1);
        this.iCovariance = xT.times(this.iX).inverse().times(variance);
        double sum = 0.0;
        int i = 0;
        while (i < this.iNumY) {
            sum += y[i];
            ++i;
        }
        double avg = sum / (double)this.iNumY;
        double[] work = new double[this.iNumY];
        int i2 = 0;
        while (i2 < this.iNumY) {
            work[i2] = avg;
            ++i2;
        }
        Matrix mean = new Matrix(work, this.iNumY);
        Matrix diff = this.iY.minus(mean);
        this.iTotalSS = diff.times(diff.transpose()).trace();
        diff = this.iFit.minus(mean);
        this.iRegressionSS = diff.times(diff.transpose()).trace();
        this.iTdist = new TDistribution((double)(this.iNumY - this.iNumX));
    }

    public double b(int j) {
        return this.iB.get(j, 0);
    }

    public double bVar(int j) {
        return this.iCovariance.get(j, j);
    }

    public double pb(int j) {
        double t = Math.abs(this.b(j) / Math.sqrt(this.bVar(j)));
        double p = 2.0 * (1.0 - this.iTdist.cumulativeProbability(t));
        return p;
    }

    public Covariance.CI bCI(int j, int levelPc) {
        double factor = this.iTdist.inverseCumulativeProbability((double)levelPc / 100.0);
        double sigma = Math.sqrt(this.bVar(j));
        double max = this.b(j) + sigma * factor;
        double min = this.b(j) - sigma * factor;
        Covariance.CI ci = new Covariance.CI(levelPc, (float)min, (float)max);
        return ci;
    }

    public double mse() {
        double sigma = Math.sqrt(this.iResidualSS / (double)(this.iNumY - this.iNumX - 1));
        return sigma;
    }

    public double R2() {
        return this.iRegressionSS / this.iTotalSS;
    }

    public double adjR2() {
        double r2 = 1.0 - (1.0 - this.R2()) * (double)(this.iNumY - 1) / (double)(this.iNumY - this.iNumX - 1);
        return r2;
    }

    public double F() {
        double F = this.iRegressionSS / (double)this.iNumX / (this.iResidualSS / (double)(this.iNumY - this.iNumX - 1));
        return F;
    }

    public double pF() {
        FDistribution fDist = new FDistribution((double)this.iNumX, (double)(this.iNumY - this.iNumX - 1));
        double p = 1.0 - fDist.cumulativeProbability(this.F());
        return p;
    }

    public double[] fit() {
        Matrix fit = this.iX.times(this.iB);
        double[][] array = fit.getArray();
        double[] values = new double[this.iNumY];
        int i = 0;
        while (i < values.length) {
            values[i] = array[i][0];
            ++i;
        }
        return values;
    }

    public double change() {
        double[] fit = this.fit();
        double change = fit[fit.length - 1] - fit[0];
        return change;
    }

    public double[] residuals() {
        Matrix residuals = this.iY.minus(this.iX.times(this.iB));
        double[][] array = residuals.getArray();
        double[] values = new double[this.iNumY];
        int i = 0;
        while (i < values.length) {
            values[i] = array[i][0];
            ++i;
        }
        return values;
    }

    public Matrix covariance() {
        return this.iCovariance;
    }

    public Matrix betas() {
        double[] bs = new double[this.iNumX];
        int i = 0;
        while (i < bs.length) {
            bs[i] = this.b(i);
            ++i;
        }
        Matrix betas = new Matrix(bs, 1);
        return betas;
    }

    public DistStats residualStats() {
        double[] residuals = this.residuals();
        DistStats stats = new DistStats("residuals");
        double[] dArray = residuals;
        int n = residuals.length;
        int n2 = 0;
        while (n2 < n) {
            double resid = dArray[n2];
            stats.add(resid, 1.0);
            ++n2;
        }
        return stats;
    }

    public float residualsGaussianUcs(int minCount, int maxCombine) throws Exception {
        double[] residuals;
        Dataset.List<XYpoint.Float> points = new Dataset.List<XYpoint.Float>("");
        double[] dArray = residuals = this.residuals();
        int n = residuals.length;
        int n2 = 0;
        while (n2 < n) {
            double residual = dArray[n2];
            points.add(new XYpoint.Float((float)residual));
            ++n2;
        }
        int numBins = DataBin.Dataset.defNumBins(points.size());
        DataBin.Dataset bins = DataBin.Dataset.binPoints(points, numBins, false);
        if (minCount > 0 && maxCombine > 0) {
            bins = bins.combine(minCount, maxCombine);
        }
        float ucs = -999.0f;
        GaussianModel model = GaussianModel.fit(bins);
        if (model != null) {
            ucs = (float)model.unitChiSquare(bins);
        }
        return ucs;
    }

    public String toString() {
        String str = Utility.objPrefix(this);
        int i = 0;
        while (i < this.iNumX) {
            str = String.valueOf(str) + FORMAT.format(this.b(i)) + "(" + this.bCI(i, 99) + "), ";
            ++i;
        }
        str = String.valueOf(str) + "mse = " + FORMAT.format(this.mse()) + ", ";
        str = String.valueOf(str) + "R2 = " + FORMAT.format(this.R2()) + ", ";
        str = String.valueOf(str) + "F(" + this.iNumX + "," + (this.iNumY - this.iNumX) + ") = " + FORMAT.format(this.F()) + " ";
        try {
            str = String.valueOf(str) + "p = " + FORMAT.format(this.pF());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return str;
    }
}

