/*
 * Decompiled with CFR 0.152.
 */
package math;

import java.util.LinkedList;
import math.DataBin;
import math.DataModel;
import math.DiffCorr;
import math.DistStats;

public class GaussianModel
extends DataModel {
    public static final String MEAN = "mean";
    public static final String SIGMA = "sigma";
    public static final String PEAK = "peak";
    private static int MINPOINTS = 7;

    public static void main(String[] args) {
        GaussianModel totalPc = new GaussianModel(72.0, 4.0, 1.0);
        double z = 10.0 / totalPc.parm(SIGMA).value();
        double prob = 2.0 * (1.0 - GaussianModel.cdf(z));
        System.out.println(prob);
    }

    public static double cdf(double z) {
        double exp = Math.sqrt(Math.PI) * (0.9 * z + 0.0418198 * z * z * z + -4.406E-4 * z * z * z * z * z);
        double cdf = 1.0 / (1.0 + Math.exp(-exp));
        return cdf;
    }

    public static DataBin.Dataset equalProbBins(double maxDev, double binProb) {
        LinkedList<DataBin> listLeft = new LinkedList<DataBin>();
        LinkedList<DataBin> listRight = new LinkedList<DataBin>();
        double startDev = 0.0;
        DataBin centerBin = GaussianModel.nextBin(startDev, maxDev, binProb);
        centerBin = new DataBin(-1.0f * centerBin.top(), centerBin.top());
        startDev = centerBin.top() + 1.0E-5f;
        DataBin nextRight = null;
        do {
            if ((nextRight = GaussianModel.nextBin(startDev, maxDev, binProb)) == null) continue;
            DataBin nextLeft = new DataBin(-1.0f * nextRight.top(), -1.0f * nextRight.bottom());
            listLeft.addFirst(nextLeft);
            listRight.add(nextRight);
            startDev = nextRight.top() + 1.0E-5f;
        } while (nextRight != null);
        DataBin[] bins = new DataBin[1 + 2 * listRight.size()];
        int i = 0;
        for (DataBin bin : listLeft) {
            bins[i++] = bin;
        }
        bins[i++] = centerBin;
        for (DataBin bin : listRight) {
            bins[i++] = bin;
        }
        DataBin.Dataset dataset = new DataBin.Dataset(bins, "equalprob");
        return dataset;
    }

    private static DataBin nextBin(double startDev, double maxDev, double binProb) {
        boolean found = false;
        DataBin bin = null;
        double inc = 1.0E-6;
        double prevEnd = startDev;
        double startCdf = GaussianModel.cdf(startDev);
        double factor = 0.5;
        if (startDev < inc) {
            factor = 1.0;
        }
        double topDev = startDev;
        while (!found && topDev <= maxDev) {
            double endCdf = GaussianModel.cdf(topDev += inc);
            double prob = factor * (endCdf - startCdf);
            found = prob > binProb;
            prevEnd = topDev;
        }
        if (found) {
            bin = new DataBin((float)startDev, (float)prevEnd - 1.0E-5f);
        }
        return bin;
    }

    public static GaussianModel fit(DataBin.Dataset dataset) {
        DistStats stats;
        DataBin center;
        GaussianModel model = null;
        if (dataset.numBins() >= MINPOINTS && (center = dataset.binForValue((float)(stats = dataset.stats()).avg())).number() > 0 && center.number() < dataset.numBins()) {
            float iniCount = 0.0f;
            short delta = 1;
            int i = center.number() - delta;
            while (i <= center.number() + delta) {
                iniCount += (float)dataset.bins()[i].count();
                ++i;
            }
            float iniPeak = iniCount / (float)(2 * delta + 1);
            model = new GaussianModel(stats.avg(), stats.sigma(), iniPeak);
            DataModel[] models1 = new DataModel[]{model};
            DiffCorr diffCorr = new DiffCorr(dataset, models1);
            int status = diffCorr.iterate();
            if (status != 0) {
                model = null;
            }
        }
        return model;
    }

    public GaussianModel(double initMean, double initSigma, double initPeak) {
        DataModel.Parm[] state = new DataModel.Parm[]{new DataModel.Parm(MEAN, initMean), new DataModel.Parm(SIGMA, initSigma), new DataModel.Parm(PEAK, initPeak)};
        this.setState(state);
    }

    @Override
    public double value(DataBin bin) {
        DataModel.Parm[] state = this.state();
        double offset = (double)bin.center() - state[0].value();
        double exp = -0.5 * offset * offset / (state[1].value() * state[1].value());
        double value = state[2].value() * Math.exp(exp);
        return value;
    }

    @Override
    public double partialDeriv(DataBin bin, DataModel.Parm parm) {
        DataModel.Parm[] state = this.state();
        double deriv = 0.0;
        double offset = (double)bin.center() - state[0].value();
        double denom = state[1].value() * state[1].value();
        double exp = Math.exp(-0.5 * offset * offset / denom);
        int index = parm.index();
        deriv = index == state[0].index() ? state[2].value() * offset * exp / denom : (index == state[1].index() ? state[2].value() * offset * offset * exp / (denom * state[1].value()) : exp);
        return deriv;
    }
}

