/*
 * Decompiled with CFR 0.152.
 */
package math;

import java.io.Serializable;
import java.text.DecimalFormat;
import math.FloatVector;
import mlib.MString;
import utilt.Utility;

public class DoubleVector
implements Serializable {
    private double[] iEles = null;

    public DoubleVector(int numEles) throws Exception {
        if (numEles <= 0) {
            Utility.throwError("Invalid number of elements");
        }
        this.iEles = new double[numEles];
        this.init(0.0);
    }

    public DoubleVector(double[] eles) throws Exception {
        this(eles.length);
        int i = 0;
        while (i < this.iEles.length) {
            this.iEles[i] = eles[i];
            ++i;
        }
    }

    public DoubleVector(float[] eles) throws Exception {
        this(eles.length);
        int i = 0;
        while (i < this.iEles.length) {
            this.iEles[i] = eles[i];
            ++i;
        }
    }

    public DoubleVector(FloatVector vec) throws Exception {
        this(vec.length());
        int i = 0;
        while (i < this.iEles.length) {
            this.iEles[i] = vec.ele(i);
            ++i;
        }
    }

    public DoubleVector(double ele1, double ele2, double ele3) throws Exception {
        this(3);
        this.iEles[0] = ele1;
        this.iEles[1] = ele2;
        this.iEles[2] = ele3;
    }

    public void init(double value) {
        int i = 0;
        while (i < this.iEles.length) {
            this.iEles[i] = value;
            ++i;
        }
    }

    public double ele(int index) {
        return this.iEles[index];
    }

    public void setEle(int index, double value) {
        this.iEles[index] = value;
    }

    public double[] eles() {
        return this.iEles;
    }

    public int length() {
        return this.iEles.length;
    }

    public double dot(DoubleVector vec) throws Exception {
        this.test(vec);
        double dot = 0.0;
        int i = 0;
        while (i < this.iEles.length) {
            dot += this.iEles[i] * vec.iEles[i];
            ++i;
        }
        return dot;
    }

    public void sum(DoubleVector vec) throws Exception {
        this.test(vec);
        int i = 0;
        while (i < this.iEles.length) {
            int n = i;
            this.iEles[n] = this.iEles[n] + vec.iEles[i];
            ++i;
        }
    }

    public double separation(DoubleVector vec) throws Exception {
        this.test(vec);
        double diff = 0.0;
        int i = 0;
        while (i < this.iEles.length) {
            double eleDiff = this.iEles[i] - vec.iEles[i];
            diff += eleDiff * eleDiff;
            ++i;
        }
        diff = Math.sqrt(diff);
        return diff;
    }

    public void mul(double factor) {
        int i = 0;
        while (i < this.iEles.length) {
            int n = i++;
            this.iEles[n] = this.iEles[n] * factor;
        }
    }

    public DoubleVector combine(DoubleVector vector) throws Exception {
        double[] eles = new double[this.iEles.length + vector.iEles.length];
        int i = 0;
        while (i < this.iEles.length) {
            eles[i] = this.iEles[i];
            ++i;
        }
        int j = 0;
        while (i < vector.iEles.length) {
            eles[i] = vector.iEles[j++];
            ++i;
        }
        return new DoubleVector(eles);
    }

    public double mag() {
        double mag = 0.0;
        int i = 0;
        while (i < this.iEles.length) {
            mag += this.iEles[i] * this.iEles[i];
            ++i;
        }
        mag = Math.sqrt(mag);
        return mag;
    }

    public void normalize() {
        double mag = this.mag();
        int i = 0;
        while (i < this.iEles.length) {
            int n = i++;
            this.iEles[n] = this.iEles[n] / mag;
        }
    }

    public int compareTo(DoubleVector vec) {
        int res = 0;
        if (vec != this) {
            res = -1;
            if (vec != null) {
                double mag2;
                double mag1 = this.mag();
                if (mag1 < (mag2 = vec.mag())) {
                    res = -1;
                } else if (mag1 > mag2) {
                    res = 1;
                }
            }
        }
        return res;
    }

    public boolean equals(Object vec) {
        return this.compareTo((DoubleVector)vec) == 0;
    }

    public int hashCode() {
        return (int)this.iEles[0];
    }

    public String format(DecimalFormat format) {
        MString str = new MString("[");
        int i = 0;
        while (i < this.iEles.length) {
            if (i > 0) {
                str.concat(",");
            }
            String ele = format.format(this.iEles[i]);
            str.concat(ele);
            ++i;
        }
        str.concat("]");
        return str.toString();
    }

    public String toString() {
        String str = Utility.objPrefix(this);
        str = String.valueOf(str) + this.iEles.length + "," + this.mag();
        return str;
    }

    private void test(DoubleVector vec) throws Exception {
        if (vec.iEles.length != this.iEles.length) {
            throw new Exception("number of elements must match");
        }
    }
}

