/*
 * Decompiled with CFR 0.152.
 */
package math;

import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.Iterator;
import math.Dataset;
import math.DistStats;
import math.XYpoint;
import org.apache.commons.math3.distribution.TDistribution;

public class Covariance
implements Comparable<Covariance>,
Serializable {
    private String iXname = "";
    private String iYname = "";
    private DistStats iX = new DistStats("x");
    private DistStats iY = new DistStats("y");
    private DistStats iXY = new DistStats("xy");
    private Dataset.Set<XYpoint.Double> iPoints = new Dataset.Set("xy");
    public static final float CI99FACTOR = 2.58f;
    private static final DecimalFormat FORMAT = new DecimalFormat("0.000");
    private static final int MINVALUES = 3;

    public static void main(String[] args) {
        Covariance cov = new Covariance("x", "y");
        int i = 0;
        while (i < 1000) {
            cov.add(new XYpoint.Double((double)i, i + 1));
            ++i;
        }
        System.out.println(cov);
    }

    public Covariance(String xName, String yName) {
        this.iXname = xName;
        this.iYname = yName;
    }

    public String xName() {
        return this.iXname;
    }

    public String yName() {
        return this.iYname;
    }

    public void add(XYpoint.Double point) {
        this.iX.add(point.x(), 1.0);
        this.iY.add(point.y(), 1.0);
        this.iXY.add(point.x() * point.y(), 1.0);
        this.iPoints.add(point);
    }

    public void add(Dataset.List<XYpoint.Double> points) {
        Iterator<XYpoint.Double> iter = points.iterator();
        while (iter.hasNext()) {
            this.add(iter.next());
        }
    }

    public double covariance() {
        int numPts = this.iX.numValues();
        double cov = (this.iXY.sumWtdValues() - this.iX.sumWtedValues() * this.iY.sumWtdValues() / (double)numPts) / (double)numPts;
        return cov;
    }

    public double coeff() {
        double coef = this.covariance() / (this.iX.sigma() * this.iY.sigma());
        return coef;
    }

    public double r2() {
        double resSumSqrs = 0.0;
        double totalSumSqrs = 0.0;
        double slope = this.slope();
        double intercept = this.intercept();
        double yAvg = this.iY.avg();
        Iterator<XYpoint.Double> iter = this.iPoints.iterator();
        while (iter.hasNext()) {
            XYpoint.Double point = iter.next();
            double residual = point.y() - (slope * point.x() + intercept);
            resSumSqrs += residual * residual;
            residual = point.y() - yAvg;
            totalSumSqrs += residual * residual;
        }
        double rSqd = 1.0 - resSumSqrs / totalSumSqrs;
        return rSqd;
    }

    public CI confiInterval() {
        CI interval = null;
        if (this.iX.numValues() > 4) {
            double coeff = this.coeff();
            double z = 0.5 * Math.log((1.0 + coeff) / (1.0 - coeff));
            double zrange = (double)2.58f / Math.sqrt(this.iX.numValues() - 3);
            double zvalue = z - zrange;
            double rmin = (Math.exp(2.0 * zvalue) - 1.0) / (Math.exp(2.0 * zvalue) + 1.0);
            zvalue = z + zrange;
            double rmax = (Math.exp(2.0 * zvalue) - 1.0) / (Math.exp(2.0 * zvalue) + 1.0);
            interval = new CI(99, rmin, rmax);
        }
        return interval;
    }

    public double p() {
        double coeff = this.coeff();
        int numPts = this.iX.numValues();
        double t = this.coeff() * Math.sqrt(numPts - 1) / Math.sqrt(1.0 - coeff * coeff);
        TDistribution tDist = new TDistribution((double)(numPts - 2));
        double p = 2.0 * (1.0 - tDist.cumulativeProbability(Math.abs(t)));
        return p;
    }

    public double slope() {
        int numPts = this.iX.numValues();
        double s1Sqd = (this.iX.sumWtedValuesSqd() - this.iX.sumWtdValues() * this.iX.sumWtdValues() / (double)numPts) / (double)numPts;
        double sl = this.covariance() / s1Sqd;
        return sl;
    }

    public double intercept() {
        double inter = this.iY.avg() - this.slope() * this.iX.avg();
        return inter;
    }

    @Override
    public int compareTo(Covariance obj) {
        int result = 0;
        if (obj != this) {
            result = -1;
            if (obj != null) {
                result = this.id().compareToIgnoreCase(obj.id());
            }
        }
        return result;
    }

    public boolean equals(Object obj) {
        return this.compareTo((Covariance)obj) == 0;
    }

    public int hashCode() {
        return this.id().toLowerCase().hashCode();
    }

    public String toString() {
        String str = "CorrCoeff: <" + this.iXname + "," + this.iYname + "> = " + FORMAT.format(this.coeff()) + "(" + this.iX.numValues() + "), " + this.confiInterval() + ", R2 = " + FORMAT.format(this.r2()) + ", p = " + FORMAT.format(this.p());
        return str;
    }

    public String minString() {
        String str = "r=" + FORMAT.format(this.coeff()) + ", R2=" + FORMAT.format(this.r2());
        return str;
    }

    private String id() {
        return String.valueOf(this.iXname) + "," + this.iYname;
    }

    public static class CI {
        private int iLevelPc = 0;
        private double iLo = 0.0;
        private double iHi = 0.0;

        public CI(int levelPc, double low, double high) {
            this.iLevelPc = levelPc;
            this.iLo = low;
            this.iHi = high;
        }

        public String toString() {
            String str = "[" + FORMAT.format(this.iLo) + ", " + FORMAT.format(this.iHi) + "] " + this.iLevelPc + "%";
            return str;
        }
    }

    public static interface Correlation {
        public void accum(Covariance var1) throws Exception;
    }
}

