/*
 * Decompiled with CFR 0.152.
 */
package help;

import help.HelpPrefs;
import help.InfoPanel;
import help.TaggedText;
import help.TaggedTextView;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import javax.swing.JPanel;

public class TextPanel
extends JPanel
implements TaggedTextView {
    private HelpPrefs iPrefs = null;
    private String[] iText = null;
    private int iX = 5;
    private int iY = 5;
    private int iTextHeight = 0;
    private int iNextNumber = 0;
    private int iNextNumIndent = 0;
    private String iCurTag = null;
    private boolean iBullet = false;
    private boolean iEmphasize = false;
    private String[] iFoundText = null;
    private int iFoundTextEle = 0;
    private Color iCustomColor = null;
    private InfoPanel iInfoPanel = null;
    private Font iEmphasisFont = null;
    private static final int MARGIN = 5;
    private static final int INDENT = 25;
    private static final int BULLETSIZE = 6;
    private static final int BULLETINDENT = 43;

    public TextPanel(HelpPrefs prefs) {
        this(null, prefs);
    }

    public void putText(TaggedText ttext) {
        this.iText = ttext.tokens();
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.iText != null) {
            this.iFoundTextEle = 0;
            this.iEmphasize = false;
            Graphics2D g2 = (Graphics2D)g;
            g2.setPaint(this.iPrefs.textColor());
            this.initPaint(g2);
            FontRenderContext context = g2.getFontRenderContext();
            String centered = null;
            boolean firstLine = true;
            int i = 0;
            while (i < this.iText.length) {
                String token = this.iText[i];
                if (token.equals(".c ")) {
                    centered = this.paintCentered(g2, context, centered);
                    this.setCustomColor(this.iText[++i], g2);
                } else if (token.equals(".t ")) {
                    centered = this.paintCentered(g2, context, centered);
                    if (!firstLine) {
                        this.addSpaceAfter();
                    }
                    this.iCurTag = ".t ";
                    this.addSpaceBefore();
                    g2.setFont(this.iPrefs.titleFont());
                    centered = "";
                } else if (token.equals(".s ")) {
                    centered = this.paintCentered(g2, context, centered);
                    if (!firstLine) {
                        this.addSpaceAfter();
                    }
                    this.iCurTag = ".s ";
                    this.addSpaceBefore();
                    g2.setFont(this.iPrefs.headerFont());
                    centered = "";
                } else if (token.equals(".h ")) {
                    centered = this.paintCentered(g2, context, centered);
                    if (!firstLine) {
                        this.addSpaceAfter();
                    }
                    this.iCurTag = ".h ";
                    this.addSpaceBefore();
                    g2.setFont(this.iPrefs.headerFont());
                    g2.setPaint(this.iPrefs.headerColor());
                } else if (token.equals(".p ") || token.equals(".i ") || token.equals(".b ")) {
                    centered = this.paintCentered(g2, context, centered);
                    if (!firstLine) {
                        this.addSpaceAfter();
                    }
                    if (token.equals(".p ")) {
                        this.iCurTag = ".p ";
                    } else if (token.equals(".i ")) {
                        this.iCurTag = ".i ";
                    } else {
                        this.iCurTag = ".b ";
                        this.iBullet = true;
                    }
                    this.addSpaceBefore();
                    g2.setFont(this.iPrefs.textFont());
                    g2.setPaint(this.iPrefs.textColor());
                } else if (token.equals(".e ")) {
                    this.iEmphasize = !this.iEmphasize;
                } else if (token.equals(".n ")) {
                    this.iNextNumber = this.iNextNumber == 0 ? 1 : 0;
                } else {
                    if (token.equals(".@ ")) {
                        token = "\u00a9 ";
                    }
                    if (centered != null) {
                        centered = String.valueOf(centered) + token;
                    } else {
                        this.paintWord(g2, context, token, i);
                    }
                }
                firstLine = false;
                ++i;
            }
            centered = this.paintCentered(g2, context, centered);
            Dimension size = this.getParent().getSize();
            size.height = this.iY + 5 + this.iTextHeight / 2;
            this.setPreferredSize(size);
            if (this.iInfoPanel != null && this.getSize().height != size.height) {
                this.iInfoPanel.updateSize();
            }
        }
    }

    TextPanel(InfoPanel infoPanel, HelpPrefs prefs) {
        this.iInfoPanel = infoPanel;
        this.iPrefs = prefs;
        this.setFont(this.iPrefs.textFont());
        int style = 2;
        if (this.iPrefs.textFont().isBold()) {
            ++style;
        }
        this.iEmphasisFont = this.iPrefs.textFont().deriveFont(style);
    }

    void putFoundText(TaggedText ttext) {
        this.iFoundText = ttext == null ? null : ttext.tokens();
        this.repaint();
    }

    private void addSpaceAfter() {
        if (this.iCurTag != null) {
            int space = this.iTextHeight / 2;
            if (this.iCurTag == ".p " || this.iCurTag == ".t " || this.iCurTag == ".s " || this.iCurTag == ".h ") {
                this.iX = 5;
                this.iY += space;
            } else if (this.iCurTag == ".i " || this.iCurTag == ".b ") {
                this.iX = 25;
                this.iY += space;
            }
        }
    }

    private void addSpaceBefore() {
        if (this.iCurTag != null) {
            if (this.iCurTag == ".p " || this.iCurTag == ".t " || this.iCurTag == ".s " || this.iCurTag == ".h ") {
                this.iX = 5;
                this.iY += this.iTextHeight;
            } else if (this.iCurTag == ".i " || this.iCurTag == ".b ") {
                this.iX = 25;
                this.iY += this.iTextHeight;
            }
        }
    }

    private void initPaint(Graphics2D g2) {
        this.iX = 0;
        this.iY = 0;
        FontRenderContext context = g2.getFontRenderContext();
        Rectangle2D bounds = this.iPrefs.textFont().getStringBounds("test", context);
        this.iTextHeight = (int)(bounds.getHeight() + 0.5);
    }

    private void setCustomColor(String color, Graphics2D g2) {
        if (color.equalsIgnoreCase("default ")) {
            g2.setPaint(this.iPrefs.textColor());
            this.iCustomColor = null;
        } else if (color.equalsIgnoreCase("red ")) {
            g2.setPaint(Color.red);
            this.iCustomColor = Color.red;
        } else if (color.equalsIgnoreCase("blue ")) {
            g2.setPaint(Color.blue);
            this.iCustomColor = Color.blue;
        } else if (color.equalsIgnoreCase("black ")) {
            g2.setPaint(Color.black);
            this.iCustomColor = Color.black;
        } else if (color.equalsIgnoreCase("gray ")) {
            g2.setPaint(Color.gray);
            this.iCustomColor = Color.gray;
        }
    }

    private String paintCentered(Graphics2D g2, FontRenderContext context, String text) {
        if (text != null) {
            Rectangle2D bounds;
            int len;
            if (this.iEmphasize) {
                Font font = null;
                font = this.iCurTag == ".t " ? this.iPrefs.titleFont() : this.iPrefs.headerFont();
                g2.setFont(font);
            }
            if ((len = (int)((bounds = g2.getFont().getStringBounds(text, context)).getWidth() + 0.5) + 10) >= this.getParent().getWidth()) {
                this.iX = 5;
            } else {
                double x = 0.5 * (double)(this.getParent().getWidth() - len);
                this.iX = (int)x;
            }
            g2.drawString(text, this.iX, this.iY);
        }
        return null;
    }

    private void paintWord(Graphics2D g2, FontRenderContext context, String word, int wordEle) {
        Rectangle2D bounds = g2.getFont().getStringBounds(word, context);
        int len = (int)(bounds.getWidth() + 0.5) + 5;
        if (this.iX + len >= this.getParent().getWidth()) {
            this.addSpaceBefore();
            if (this.iCurTag == ".p ") {
                this.iX = 5;
            } else if (this.iCurTag == ".i ") {
                this.iX = 25;
            } else if (this.iCurTag == ".b ") {
                this.iX = 43;
                if (this.iNextNumber > 0) {
                    this.iX = this.iNextNumIndent;
                }
            }
        }
        if (this.iBullet) {
            if (this.iNextNumber <= 0) {
                int offset = this.iTextHeight / 2;
                Rectangle2D.Double bullet = new Rectangle2D.Double(this.iX, this.iY - offset, 6.0, 6.0);
                g2.fill(bullet);
                this.iX += 18;
            } else {
                String text = Integer.toString(this.iNextNumber) + ")  ";
                Font save = g2.getFont();
                g2.setFont(this.iEmphasisFont);
                g2.drawString(text, this.iX, this.iY);
                g2.setFont(save);
                bounds = g2.getFont().getStringBounds(text, context);
                this.iX += (int)(bounds.getWidth() + 0.5);
                ++this.iNextNumber;
                this.iNextNumIndent = this.iX;
            }
            this.iBullet = false;
        }
        if (this.iFoundText != null) {
            this.setupColor(g2, word, wordEle);
        }
        if (this.iEmphasize && g2.getFont() == this.iPrefs.textFont()) {
            g2.setFont(this.iEmphasisFont);
            g2.drawString(word, this.iX, this.iY);
            g2.setFont(this.iPrefs.textFont());
        } else {
            g2.drawString(word, this.iX, this.iY);
        }
        this.iX += len;
    }

    private void setupColor(Graphics2D g2, String word, int wordEle) {
        boolean set = false;
        if (TaggedText.tokensMatch(this.iFoundText[this.iFoundTextEle], word)) {
            int i = this.iFoundTextEle + 1;
            int j = 1;
            while (i < this.iFoundText.length) {
                if (!TaggedText.tokensMatch(this.iFoundText[i], this.iText[wordEle + j])) break;
                ++j;
                ++i;
            }
            if (i == this.iFoundText.length) {
                g2.setPaint(this.iPrefs.foundColor());
                ++this.iFoundTextEle;
                if (this.iFoundTextEle >= this.iFoundText.length) {
                    this.iFoundTextEle = 0;
                }
                set = true;
            }
        }
        if (!set) {
            this.iFoundTextEle = 0;
            if (this.iCurTag == ".t ") {
                g2.setFont(this.iPrefs.titleFont());
                if (this.iCustomColor == null) {
                    g2.setPaint(this.iPrefs.textColor());
                } else {
                    g2.setPaint(this.iCustomColor);
                }
            } else if (this.iCurTag == ".h ") {
                g2.setFont(this.iPrefs.headerFont());
                if (this.iCustomColor == null) {
                    g2.setPaint(this.iPrefs.headerColor());
                } else {
                    g2.setPaint(this.iCustomColor);
                }
            } else if (this.iCustomColor == null) {
                g2.setFont(this.iPrefs.textFont());
                g2.setPaint(this.iPrefs.textColor());
            }
        }
    }
}

