/*
 * Decompiled with CFR 0.152.
 */
package help;

import help.FindPanel;
import help.HelpEvent;
import help.HelpListener;
import help.HelpNode;
import help.HelpPrefs;
import help.HelpTree;
import help.InfoPanel;
import help.TaggedText;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import mlib.MString;
import swing.StdScrollPane;
import utilt.Utility;

class SelectionPanel
extends JPanel {
    private FindPanel jFindPanel = null;
    private JTree jHelpTopics = null;
    private JScrollPane jScrollPane = null;
    private DefaultMutableTreeNode iHelpRoot = null;
    private InfoPanel iInfoPanel = null;
    private HelpPrefs iPrefs = null;
    private LinkedList<HelpListener> iLis = new LinkedList();
    private LinkedList<DefaultMutableTreeNode> iNodesFound = null;
    private static final String EMPTYSTR = " ";

    SelectionPanel(HelpPrefs prefs) {
        this.iPrefs = prefs;
        this.setLayout(new BorderLayout());
        this.setBackground(this.iPrefs.backColor());
        this.add((Component)this.getFindPanel(), "North");
        this.add((Component)this.getScrollPane(), "Center");
        TreeSelectionModel selModel = this.getHelpTopics().getSelectionModel();
        selModel.setSelectionMode(1);
        this.getHelpTopics().addTreeSelectionListener(new SelectionHandler());
        this.getHelpTopics().setModel(null);
        this.getFindPanel().setSelPanel(this);
    }

    void addHelpListener(HelpListener lis) {
        this.iLis.add(lis);
    }

    JTree topicsTree() {
        return this.getHelpTopics();
    }

    void removeHelpListener(HelpListener lis) {
        this.iLis.remove(lis);
    }

    void setTree(HelpTree tree) {
        this.iHelpRoot = tree.root();
        this.getHelpTopics().setModel(new DefaultTreeModel(this.iHelpRoot));
        this.getHelpTopics().setCellRenderer(new TopicsTreeRenderer());
        this.validate();
    }

    void setInfoPanel(InfoPanel newInfoPanel) {
        this.iInfoPanel = newInfoPanel;
    }

    void clearFind() {
        if (this.iNodesFound != null) {
            this.iNodesFound.clear();
        }
        this.getFindPanel().putIndicator(SystemColor.control, EMPTYSTR);
        this.iInfoPanel.putFoundText(null);
        this.getHelpTopics().repaint();
    }

    void expandAllNodes() {
        Utility.expandOrCollapse(this.jHelpTopics, true);
    }

    boolean doFind(String text) {
        boolean found = false;
        this.getFindPanel().putIndicator(SystemColor.control, EMPTYSTR);
        if (text.length() > 0) {
            this.getFindPanel().putIndicator(Color.yellow, EMPTYSTR);
            this.iNodesFound = new LinkedList();
            TaggedText ttext = TaggedText.parseText(text);
            Enumeration<TreeNode> nodes = this.iHelpRoot.breadthFirstEnumeration();
            nodes.nextElement();
            while (nodes.hasMoreElements()) {
                DefaultMutableTreeNode ele = (DefaultMutableTreeNode)nodes.nextElement();
                HelpNode node = (HelpNode)ele.getUserObject();
                TaggedText helpText = node.text();
                if (helpText == null || !helpText.contains(ttext)) continue;
                this.iNodesFound.add(ele);
            }
            this.getHelpTopics().repaint();
            if (this.iNodesFound.size() > 0) {
                this.iInfoPanel.putFoundText(ttext);
                this.getFindPanel().putIndicator(this.iPrefs.foundColor(), EMPTYSTR);
                found = true;
            } else {
                this.iInfoPanel.putFoundText(null);
                this.getFindPanel().putIndicator(SystemColor.control, "?");
            }
        }
        return found;
    }

    private void fixTreeRowHeight() {
        int rowHeight;
        int iconHeight = 0;
        if (this.iPrefs.leafIcon() != null) {
            iconHeight = this.iPrefs.leafIcon().getIconHeight();
        }
        if (this.iPrefs.parentIcon() != null && this.iPrefs.parentIcon().getIconHeight() > iconHeight) {
            iconHeight = this.iPrefs.parentIcon().getIconHeight();
        }
        if (iconHeight > (rowHeight = this.iPrefs.textFont().getSize())) {
            rowHeight = iconHeight;
        }
        int space = 3;
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        if (screen.width > 1024) {
            space = 6;
        }
        if (iconHeight > 0) {
            rowHeight = iconHeight;
        } else {
            space += 3;
        }
        this.getHelpTopics().setRowHeight(rowHeight + space);
    }

    private FindPanel getFindPanel() {
        if (this.jFindPanel == null) {
            this.jFindPanel = new FindPanel();
            this.jFindPanel.setBackground(this.iPrefs.backColor());
            this.jFindPanel.putTextFont(this.iPrefs.headerFont());
        }
        return this.jFindPanel;
    }

    private JTree getHelpTopics() {
        if (this.jHelpTopics == null) {
            this.jHelpTopics = new JTree();
            this.jHelpTopics.setBackground(this.iPrefs.backColor());
            this.jHelpTopics.setBounds(0, 0, 160, 120);
            this.jHelpTopics.setForeground(this.iPrefs.textColor());
            this.jHelpTopics.setRootVisible(false);
            this.fixTreeRowHeight();
        }
        return this.jHelpTopics;
    }

    private JScrollPane getScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new StdScrollPane();
            this.jScrollPane.setBackground(this.iPrefs.backColor());
            this.getScrollPane().setViewportView(this.getHelpTopics());
        }
        return this.jScrollPane;
    }

    private class SelectionHandler
    implements TreeSelectionListener {
        private SelectionHandler() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent event) {
            TreePath selection = SelectionPanel.this.getHelpTopics().getSelectionPath();
            if (selection != null) {
                Object lastComp = selection.getLastPathComponent();
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)lastComp;
                HelpNode helpNode = (HelpNode)node.getUserObject();
                SelectionPanel.this.iInfoPanel.show(helpNode);
                HelpEvent evnt = new HelpEvent(SelectionPanel.this);
                evnt.setNode(node);
                TreeNode[] treePath = node.getPath();
                MString path = new MString();
                int count = 0;
                TreeNode[] treeNodeArray = treePath;
                int n = treePath.length;
                int n2 = 0;
                while (n2 < n) {
                    TreeNode obj = treeNodeArray[n2];
                    if (count > 0) {
                        path.concat(" - ");
                    }
                    DefaultMutableTreeNode anObj = (DefaultMutableTreeNode)obj;
                    helpNode = (HelpNode)anObj.getUserObject();
                    path.concat(helpNode.title());
                    ++count;
                    ++n2;
                }
                evnt.setNodeTitle(path.toString());
                for (HelpListener lis : SelectionPanel.this.iLis) {
                    lis.selected(evnt);
                }
                SelectionPanel.this.jHelpTopics.setFont(null);
                SelectionPanel.this.jHelpTopics.setFont(SelectionPanel.this.iPrefs.textFont().deriveFont(1));
            }
        }
    }

    private class TopicsTreeRenderer
    implements TreeCellRenderer {
        private TopicsTreeRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            HelpNode helpNode = (HelpNode)node.getUserObject();
            JLabel renderer = new JLabel(helpNode.title());
            if (leaf) {
                if (SelectionPanel.this.iPrefs.leafIcon() != null) {
                    renderer.setIcon(SelectionPanel.this.iPrefs.leafIcon());
                }
            } else if (SelectionPanel.this.iPrefs.parentIcon() != null) {
                renderer.setIcon(SelectionPanel.this.iPrefs.parentIcon());
            }
            renderer.setOpaque(true);
            renderer.setText(helpNode.title());
            renderer.setBackground(SelectionPanel.this.iPrefs.backColor());
            renderer.setForeground(SelectionPanel.this.iPrefs.textColor());
            if (!selected) {
                Font font = SelectionPanel.this.iPrefs.headerFont().deriveFont(1);
                renderer.setFont(font);
            } else {
                Font select = SelectionPanel.this.iPrefs.headerFont().deriveFont(3);
                renderer.setFont(select);
            }
            if (SelectionPanel.this.iNodesFound != null) {
                this.hilightFind(node, expanded, renderer);
            }
            return renderer;
        }

        private boolean hilightFind(DefaultMutableTreeNode node, boolean expanded, JLabel renderer) {
            boolean done = false;
            Iterator iter = SelectionPanel.this.iNodesFound.iterator();
            while (iter.hasNext() && !done) {
                if (!node.equals(iter.next())) continue;
                renderer.setForeground(SelectionPanel.this.iPrefs.foundColor());
                done = true;
            }
            if (!done && !expanded && this.childMatches(node)) {
                renderer.setForeground(SelectionPanel.this.iPrefs.foundColor());
            }
            return done;
        }

        private boolean childMatches(DefaultMutableTreeNode node) {
            boolean found = false;
            Enumeration<TreeNode> children = node.children();
            while (children.hasMoreElements() && !found) {
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)children.nextElement();
                Iterator iter = SelectionPanel.this.iNodesFound.iterator();
                while (iter.hasNext() && !found) {
                    found = child.equals(iter.next());
                }
                if (found) continue;
                found = this.childMatches(child);
            }
            return found;
        }
    }
}

