/*
 * Decompiled with CFR 0.152.
 */
package help;

import help.HelpNode;
import help.HelpPrefs;
import help.TaggedText;
import help.TextPanel;
import java.awt.GridLayout;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import swing.StdScrollPane;
import swing.ZoomableImagePanel;

class InfoPanel
extends JPanel {
    private TextPanel iTextPanel = null;
    private ZoomableImagePanel iImagePanel = new ZoomableImagePanel();
    private JSplitPane iVertSplitPane = null;
    private JScrollPane iScrollPane = null;
    private HelpNode iCurNode = null;
    private HelpPrefs iPrefs = null;

    InfoPanel(HelpPrefs prefs) {
        this.iPrefs = prefs;
        this.setLayout(new GridLayout(1, 1));
        this.setBackground(prefs.backColor());
        this.iTextPanel = new TextPanel(this, this.iPrefs);
    }

    void putFoundText(TaggedText text) {
        this.iTextPanel.putFoundText(text);
    }

    void show(HelpNode node) {
        this.iCurNode = node;
        this.removeAll();
        this.iVertSplitPane = null;
        this.iScrollPane = new StdScrollPane(this.iTextPanel, 20, 31);
        this.iScrollPane.setBackground(this.iPrefs.backColor());
        if (node.textFileName() != null && node.imageFileName() != null) {
            this.iVertSplitPane = new JSplitPane(0);
            this.iImagePanel.showPic(node.image(), false, node.isImageZoomable());
            this.iTextPanel.putText(node.text());
            if (node.isImageAbove()) {
                this.iVertSplitPane.setTopComponent(this.iImagePanel);
                this.iVertSplitPane.setBottomComponent(this.iScrollPane);
            } else {
                this.iVertSplitPane.setTopComponent(this.iScrollPane);
                this.iVertSplitPane.setBottomComponent(this.iImagePanel);
            }
            this.add(this.iVertSplitPane);
        } else if (node.textFileName() != null) {
            this.iTextPanel.putText(node.text());
            this.add(this.iScrollPane);
        } else if (node.imageFileName() != null) {
            this.iImagePanel.showPic(node.image(), false, false);
            this.add(this.iImagePanel);
        }
        this.doVertSplit();
        JScrollBar vertBar = this.iScrollPane.getVerticalScrollBar();
        vertBar.setValue(vertBar.getMinimum());
        this.repaint();
    }

    void doVertSplit() {
        if (this.iVertSplitPane != null) {
            int minSpane = this.iVertSplitPane.getMinimumDividerLocation();
            int maxSpane = this.getSize().height;
            int imgPercent = this.iCurNode.imagePercent();
            if (!this.iCurNode.isImageAbove()) {
                imgPercent = 100 - imgPercent;
            }
            int loc = (int)((double)imgPercent * 0.01 * (double)(maxSpane - minSpane) + (double)minSpane);
            this.iVertSplitPane.setDividerLocation(loc);
        }
        this.validate();
    }

    void updateSize() {
        this.iScrollPane.doLayout();
    }
}

