/*
 * Decompiled with CFR 0.152.
 */
package help;

import help.HelpEvent;
import help.HelpListener;
import help.HelpPanel;
import help.HelpPrefs;
import help.HelpTree;
import java.awt.GridLayout;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.LinkedList;
import javax.swing.ImageIcon;
import swing.MainFrame;

public class HelpWindow
extends MainFrame {
    private HelpTree iTree = null;
    private HelpPanel jHelpPanel = null;
    private LinkedList<HelpListener> iLis = new LinkedList();
    private HelpPrefs iPrefs = null;
    private static HelpWindow Singleton = null;

    public static void main(String[] args) {
        try {
            HelpTree tree = HelpTree.readZip(new File("help.dat"));
            HelpWindow viewer = HelpWindow.create(tree, null, new HelpPrefs());
            viewer.setVisible(true);
        }
        catch (Exception xcp) {
            System.out.println(xcp);
        }
    }

    public static HelpWindow create(HelpTree tree, ImageIcon titleIcon, HelpPrefs prefs) {
        if (Singleton == null) {
            Singleton = new HelpWindow(tree, titleIcon, prefs);
        }
        return Singleton;
    }

    public static boolean isDisplayed() {
        return Singleton != null;
    }

    public void addHelpListener(HelpListener lis) {
        this.iLis.add(lis);
    }

    public HelpPrefs prefs() {
        return HelpWindow.Singleton.iPrefs;
    }

    private HelpPanel getHelpPanel() {
        if (this.jHelpPanel == null) {
            this.jHelpPanel = new HelpPanel(this.iPrefs);
            this.jHelpPanel.putTree(this.iTree);
            this.jHelpPanel.addHelpListener(new HelpHandler());
        }
        return this.jHelpPanel;
    }

    private HelpWindow(HelpTree tree, ImageIcon titleIcon, HelpPrefs prefs) {
        this.iTree = tree;
        if (titleIcon != null) {
            this.setIconImage(titleIcon.getImage());
        }
        this.iPrefs = prefs;
        this.setDefaultCloseOperation(2);
        this.getContentPane().setLayout(new GridLayout(1, 0));
        this.setContentPane(this.getHelpPanel());
        this.centerRel(0.8, 0.8);
        this.addWindowListener(new WindowHandler());
        Singleton = this;
    }

    private HelpWindow() {
    }

    private class HelpHandler
    implements HelpListener {
        private HelpHandler() {
        }

        @Override
        public void selected(HelpEvent event) {
            HelpWindow.this.setTitle(event.nodeTitle());
        }

        @Override
        public void ioError(HelpEvent event, Exception xcp) {
        }

        @Override
        public void windowClosing(HelpEvent event) {
        }
    }

    private class WindowHandler
    extends WindowAdapter {
        private WindowHandler() {
        }

        @Override
        public void windowOpened(WindowEvent event) {
            HelpWindow.this.getHelpPanel().selectFirstTopic();
        }

        @Override
        public void windowClosed(WindowEvent event) {
            Singleton = null;
            for (HelpListener lis : HelpWindow.this.iLis) {
                lis.windowClosing(new HelpEvent(HelpWindow.this));
            }
        }
    }
}

