/*
 * Decompiled with CFR 0.152.
 */
package help;

import help.HelpNode;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.TreeMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.imageio.ImageIO;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import mlib.MLogging;
import utilt.Showable;
import utilt.Utility;
import utilt.ZipHandler;

public class HelpTree
implements Serializable,
Showable {
    private DefaultMutableTreeNode iRoot = null;
    private TreeMap<String, DefaultMutableTreeNode> iNodes = new TreeMap();
    public static final String TREEFILENAME = "helptree.dat";
    public static final String HELPFILENAME = "help.dat";
    public static final String CLASSFILEOFFSET = "../";
    public static final String CLASSFILEPATH = "../help/";
    private static final long serialVersionUID = -4790980857775648971L;

    public static int imagePc() {
        int pc = 50;
        if (Utility.widescreen()) {
            pc = 40;
        }
        return pc;
    }

    public static HelpTree readZip(File zipPath) throws Exception {
        ZipFile zipFile = new ZipFile(zipPath);
        ZipEntry entry = zipFile.getEntry(TREEFILENAME);
        InputStream stream = zipFile.getInputStream(entry);
        ObjectInputStream in = new ObjectInputStream(stream);
        HelpTree tree = (HelpTree)in.readObject();
        in.close();
        tree.loadImages(zipFile);
        zipFile.close();
        return tree;
    }

    public static HelpTree readResource(Class<?> toUse, String path) throws Exception {
        HelpTree tree = null;
        try (InputStream in = null;){
            try {
                System.out.println(path);
                in = toUse.getResourceAsStream(path);
                if (in == null) {
                    path = "/" + path;
                    System.out.println(path);
                    in = toUse.getResourceAsStream(path);
                }
                ObjectInputStream objIn = new ObjectInputStream(in);
                tree = (HelpTree)objIn.readObject();
            }
            catch (Exception xcp) {
                System.out.println(xcp);
                if (in != null) {
                    in.close();
                }
            }
        }
        return tree;
    }

    public HelpTree(HelpNode root) {
        this.iRoot = new DefaultMutableTreeNode(root);
        this.iNodes.put(root.title(), this.iRoot);
    }

    public DefaultMutableTreeNode root() {
        return this.iRoot;
    }

    public void add(HelpNode parent, HelpNode node) throws Exception {
        node.loadImage();
        DefaultMutableTreeNode pNode = this.iNodes.get(parent.title());
        if (pNode == null) {
            Utility.throwError("Parent node not found: " + parent.title());
        } else {
            DefaultMutableTreeNode child = new DefaultMutableTreeNode(node);
            pNode.add(child);
            this.iNodes.put(node.title(), child);
        }
    }

    public HelpNode node(String title) {
        DefaultMutableTreeNode node = this.iNodes.get(title);
        HelpNode helpNode = (HelpNode)node.getUserObject();
        return helpNode;
    }

    public void putImage(String imageFileName, Image image) throws Exception {
        LinkedList<HelpNode> nodes = this.byDepth();
        boolean done = false;
        Iterator iter = nodes.iterator();
        while (!done && iter.hasNext()) {
            HelpNode node = (HelpNode)iter.next();
            String name = node.imageFileName();
            if (name == null || !(done = name.equalsIgnoreCase(imageFileName))) continue;
            node.putImage(image);
        }
        if (!done) {
            Utility.throwError("Matching HelpNode not found: " + imageFileName);
        }
    }

    public LinkedList<HelpNode> byDepth() {
        LinkedList<HelpNode> byDepth = new LinkedList<HelpNode>();
        Enumeration<TreeNode> en = this.iRoot.depthFirstEnumeration();
        while (en.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)en.nextElement();
            byDepth.add((HelpNode)node.getUserObject());
        }
        return byDepth;
    }

    public LinkedList<HelpNode> byBreadth() {
        LinkedList<HelpNode> byBreadth = new LinkedList<HelpNode>();
        Enumeration<TreeNode> en = this.iRoot.breadthFirstEnumeration();
        while (en.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)en.nextElement();
            byBreadth.add((HelpNode)node.getUserObject());
        }
        return byBreadth;
    }

    public LinkedList<String> imageFiles() {
        LinkedList<String> paths = new LinkedList<String>();
        LinkedList<HelpNode> byDepth = this.byDepth();
        for (HelpNode node : byDepth) {
            if (node.imageFileName() == null) continue;
            paths.add(node.imageFileName());
        }
        return paths;
    }

    public HelpNode find(String title) {
        HelpNode found = null;
        Iterator iter = this.byDepth().iterator();
        while (found == null && iter.hasNext()) {
            HelpNode helpNode = (HelpNode)iter.next();
            if (!helpNode.title().equals(title)) continue;
            found = helpNode;
        }
        return found;
    }

    public String title() {
        LinkedList<HelpNode> byDepth = this.byDepth();
        String title = byDepth.getFirst().title();
        return title;
    }

    public int numNodes() {
        LinkedList<HelpNode> byDepth = this.byDepth();
        return byDepth.size();
    }

    public void list(MLogging logger) {
        logger.writeln(this.toString(), false);
        String indent = logger.prefix();
        logger.setPrefix(String.valueOf(indent) + "   ");
        LinkedList<HelpNode> nodes = this.byDepth();
        for (HelpNode node : nodes) {
            logger.writeln("   " + node.toString(), false);
        }
        logger.setPrefix(indent);
    }

    public void writeZip() throws Exception {
        LinkedList<String> files = new LinkedList<String>();
        files.add(TREEFILENAME);
        files.addAll(this.imageFiles());
        ZipHandler.write(new File(HELPFILENAME), files);
    }

    public String toString() {
        LinkedList<HelpNode> byDepth = this.byDepth();
        String title = byDepth.getFirst().title();
        String str = "HelpTree " + title.trim() + ", " + byDepth.size() + " nodes, " + this.imageFiles().size() + " images";
        return str;
    }

    @Override
    public void showId(MLogging logger) {
        HelpNode root = (HelpNode)this.iRoot.getUserObject();
        logger.writeln(root.title(), false);
    }

    @Override
    public void showSummary(MLogging logger) throws Exception {
        logger.writeln(this.toString(), false);
    }

    @Override
    public void showDetails(MLogging logger) throws Exception {
        this.list(logger);
    }

    @Override
    public void showOther(String parm, MLogging logger) throws Exception {
        logger.writeln("show Other not defined", false);
    }

    @Override
    public void showHelp(MLogging logger) {
        String parms = "s,d";
        logger.writeln(parms, false);
    }

    public void loadImagesFromFolder(String relPath) throws Exception {
        LinkedList<HelpNode> nodes = this.byDepth();
        for (HelpNode node : nodes) {
            String name = node.imageFileName();
            if (name == null) continue;
            try (InputStream is = null;){
                relPath = relPath.trim();
                String filePath = String.valueOf(relPath) + File.separator + name;
                is = new BufferedInputStream(new FileInputStream(filePath));
                if (is == null && !filePath.startsWith(File.separator) && !filePath.startsWith("/")) {
                    filePath = String.valueOf(File.separatorChar) + filePath;
                }
                is = new BufferedInputStream(new FileInputStream(filePath));
                BufferedImage image = ImageIO.read(is);
                node.putImage(image);
            }
        }
    }

    private void loadImages(ZipFile zipFile) throws Exception {
        LinkedList<HelpNode> nodes = this.byDepth();
        for (HelpNode node : nodes) {
            String name = node.imageFileName();
            if (name == null) continue;
            ZipEntry entry = zipFile.getEntry(node.imageFileName());
            if (entry == null) {
                Utility.throwError("ZipEntry not found: " + name);
            }
            try (InputStream is = null;){
                is = new BufferedInputStream(zipFile.getInputStream(entry));
                BufferedImage image = ImageIO.read(is);
                node.putImage(image);
            }
        }
    }
}

