/*
 * Decompiled with CFR 0.152.
 */
package files;

import files.FileInfo;
import files.Filesystem;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.LinkedList;
import mlib.MEncrypter;
import mlib.MLogger;
import mlib.MLogging;
import mlib.MString;
import mlib.MWildcard;

public abstract class FtpServer {
    private Parms iParms = new Parms();
    private MLogging iLogger = new MLogger.Empty();
    private boolean iConnected = false;
    private int iHoldCount = 0;
    private int iTransferCount = 0;
    private int iNumTries = 3;
    protected LinkedList<Listener> iListeners = new LinkedList();
    private static final MEncrypter Enc = new MEncrypter(192829837423991L);
    protected static final String NOCONN = "Unable to connect to server";
    protected static final String TEMPFILE = "ftptemp.dat";
    protected static final int TIMEOUTMS = 10000;
    private static int DefHoldCount = 50;

    public static int defaultHoldCount() {
        return DefHoldCount;
    }

    public static void putDefaultHoldCount(int count) {
        DefHoldCount = count;
    }

    public void setLogger(MLogging logger) {
        if (logger != null) {
            this.iLogger = logger;
        }
    }

    public MLogging logger() {
        return this.iLogger;
    }

    public void setParms(Parms parms) {
        this.iParms = parms;
    }

    public Parms parms() {
        return this.iParms;
    }

    public boolean isConnected() {
        return this.iConnected;
    }

    public void setConnected(boolean conn) {
        this.iConnected = conn;
    }

    public int holdCount() {
        return this.iHoldCount;
    }

    public void setHoldCount(int count) throws Exception {
        this.iHoldCount = count;
        if (this.iHoldCount == 0) {
            if (this.isConnected()) {
                this.disconnect();
                this.iLogger.writeln("Released hold", false);
            } else {
                this.iLogger.writeln("Set connection hold to " + count, false);
            }
        }
    }

    public void resetTransferCount() {
        this.iTransferCount = 0;
    }

    public boolean incTransferCount(int increment) {
        boolean result;
        boolean bl = result = this.iTransferCount + increment <= this.iHoldCount;
        if (result) {
            this.iTransferCount += increment;
        }
        return result;
    }

    public int numTries() {
        return this.iNumTries;
    }

    public void setNumTries(int numTries) {
        this.iNumTries = numTries;
    }

    public void disconnectIfNotHeld() {
        if (this.holdCount() == 0) {
            try {
                this.disconnect();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void addListener(Listener lis) {
        this.iListeners.add(lis);
    }

    public void removeListener(Listener lis) {
        this.iListeners.remove(lis);
    }

    public abstract void connect() throws Exception;

    public abstract Object readObj(String var1, boolean var2) throws Exception;

    public abstract Object readGzipObjHttp(String var1) throws Exception;

    public abstract void uploadObj(String var1, Object var2, boolean var3) throws Exception;

    public abstract void downloadFile(String var1, String var2) throws Exception;

    public abstract int downloadFolder(String var1, String var2) throws Exception;

    public abstract void uploadFile(String var1, String var2) throws Exception;

    public abstract int uploadFolder(String var1, String var2) throws Exception;

    public abstract FileInfo fileExists(String var1) throws Exception;

    public abstract LinkedList<FileInfo> files(Filesystem.ApacheFtp var1, String var2, LinkedList<MWildcard> var3) throws Exception;

    public abstract void mkdir(String var1) throws Exception;

    public abstract void renameFile(String var1, String var2) throws Exception;

    public abstract void deleteFile(String var1) throws Exception;

    public abstract void deleteFolder(String var1) throws Exception;

    public abstract long fileSize(String var1) throws Exception;

    public abstract void disconnect();

    public static interface Listener {
        public void connected();

        public void disconnected();
    }

    public static class Parms
    implements Serializable {
        private MString iHostName = null;
        private MString iFolder = null;
        private MString iUserName = null;
        private MString iPassword = null;
        static final long serialVersionUID = -6008256252585756980L;

        public static Parms stuParms() {
            Parms parms = new Parms("ftp.bluemontsw.com", "student1@bluemontsw.com", "6x6Fuji100$", "harper");
            return parms;
        }

        public static Parms instrParms() {
            Parms parms = new Parms("ftp.bluemontsw.com", "harper@bluemontsw.com", "Alfa25Jetta14$", "harper");
            return parms;
        }

        public Parms(String hostName, String userName, String password, String folder) {
            this.iUserName = new MString(userName);
            this.iHostName = new MString(hostName);
            if (password.length() == 8) {
                MString work = new MString();
                int i = 0;
                while (i < password.length()) {
                    int offset = 1;
                    if (i == 0) {
                        offset = 3;
                    }
                    int chr = password.charAt(i) - offset;
                    work.concat((char)chr);
                    ++i;
                }
                password = work.toString();
            }
            this.iPassword = new MString(password);
            this.iFolder = new MString(folder);
        }

        public String folder() {
            return this.iFolder.toString();
        }

        public String hostName() {
            return this.iHostName.toString();
        }

        public String password() {
            return this.iPassword.toString();
        }

        public String userName() {
            return this.iUserName.toString();
        }

        public void setUserName(String name) {
            this.iUserName = new MString(name);
        }

        public void cipher(MEncrypter enc) {
            this.iHostName.cipher(enc);
            this.iFolder.cipher(enc);
            this.iPassword.cipher(enc);
            this.iUserName.cipher(enc);
        }

        public void writeObject(ObjectOutputStream out) throws IOException {
            this.cipher(Enc);
            out.defaultWriteObject();
        }

        public void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            this.cipher(Enc);
        }

        public void clearCache() {
        }

        public String toString() {
            String str = String.valueOf(this.folder()) + "," + this.hostName() + "," + this.password() + "," + this.userName();
            return str;
        }

        private Parms() {
        }
    }
}

