/*
 * Decompiled with CFR 0.152.
 */
package files;

import files.FileInfo;
import files.Filesystem;
import java.io.File;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import mlib.MLogging;
import mlib.MWildcard;

public class FilesystemCopier {
    private Filesystem iFromFs = null;
    private Filesystem iToFs = null;
    private MLogging iLogger = null;
    private static final int THRESHOLDSEC = 30;
    private static FileInfo.Local TMPPATH = null;
    private static final long MILLISEC = 1000L;

    static {
        try {
            Filesystem.Local fs = new Filesystem.Local(System.getProperty("java.io.tmpdir"), true);
            TMPPATH = new FileInfo.Local((Filesystem)fs, "sync.dat");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public FilesystemCopier(Filesystem fromFs, Filesystem toFs, MLogging logger) {
        this.iFromFs = fromFs;
        this.iToFs = toFs;
        this.iLogger = logger;
    }

    public void copy(LinkedList<MWildcard> excludes, boolean ignoreDates, int holdCount) throws Exception {
        String type = "Syncing ";
        if (!this.iToFs.isWriteTo()) {
            type = "Comparing ";
        }
        String msg = String.valueOf(type) + this.iFromFs + " to " + this.iToFs;
        this.iLogger.writeln(msg, false);
        this.iLogger.write("Mapping " + this.iFromFs.toString() + "...", false);
        TreeMap<String, FileInfo> fromMap = this.iFromFs.filesMap(excludes);
        this.iLogger.writeln("Found " + this.iFromFs.numFiles() + " files", false);
        this.iLogger.write("Mapping " + this.iToFs.toString() + "...", false);
        TreeMap<String, FileInfo> toMap = this.iToFs.filesMap(excludes);
        this.iLogger.writeln("Found " + this.iToFs.numFiles() + " files", false);
        int count = this.transfer(fromMap, toMap, ignoreDates, holdCount);
        this.iLogger.writeln("Copied " + count + " files", false);
    }

    private int transfer(TreeMap<String, FileInfo> fromMap, TreeMap<String, FileInfo> toMap, boolean ignoreDates, int holdCount) throws Exception {
        this.iFromFs.setHoldCount(holdCount);
        this.iToFs.setHoldCount(holdCount);
        if (this.iToFs.isWriteTo()) {
            this.createDirs(fromMap);
        }
        int count = 1;
        Set<Map.Entry<String, FileInfo>> mappings = fromMap.entrySet();
        for (Map.Entry<String, FileInfo> entry : mappings) {
            boolean update;
            FileInfo fromInfo = entry.getValue();
            if (fromInfo.isDir()) continue;
            FileInfo toInfo = toMap.get(entry.getKey());
            if (toInfo == null) {
                if (this.iToFs.isWriteTo()) {
                    String toPath = String.valueOf(this.iToFs.rootDir().path()) + fromInfo.fileSysPath();
                    this.iLogger.write("   Creating " + toPath + "...", false);
                    this.iFromFs.get(fromInfo, TMPPATH);
                    this.iToFs.put((FileInfo)TMPPATH, toPath);
                    String msg = "OK, " + count;
                    this.iLogger.writeln(msg, false);
                    toInfo = new FileInfo.Local(this.iToFs, new File(toPath));
                    toInfo.setTimestamp(fromInfo.timestamp());
                    ++count;
                    continue;
                }
                String toCreate = fromInfo.path();
                toCreate = toCreate.replace(this.iFromFs.rootDir().path(), this.iToFs.rootDir().path());
                this.iLogger.writeln("   Would create " + toCreate, false);
                continue;
            }
            long diffSec = Math.abs(fromInfo.timestamp() - toInfo.timestamp()) / 1000L;
            String diffStr = " (" + diffSec / 60L + " min) ";
            boolean bl = update = ignoreDates || diffSec > 30L;
            if (update && toInfo.fileSys().isWriteTo()) {
                this.iLogger.write("   Updating " + toInfo.path() + diffStr + "...", false);
                this.copyFile(fromInfo, toInfo);
                String msg = "OK, " + count;
                this.iLogger.writeln(msg, false);
                ++count;
                continue;
            }
            if (diffSec <= 30L) continue;
            this.iLogger.writeln("   Would update " + toInfo.path() + diffStr, false);
        }
        return count - 1;
    }

    private void copyFile(FileInfo fromInfo, FileInfo toInfo) throws Exception {
        if (!this.iFromFs.isLocal()) {
            this.iFromFs.get(fromInfo, TMPPATH);
            toInfo.fileSys().put((FileInfo)TMPPATH, toInfo);
        } else {
            toInfo.fileSys().put(fromInfo, toInfo);
        }
        toInfo.setTimestamp(fromInfo.timestamp());
    }

    private void createDirs(TreeMap<String, FileInfo> fromMap) throws Exception {
        for (FileInfo fromInfo : fromMap.values()) {
            String path;
            File file;
            if (!fromInfo.isDir() || (file = new File(path = String.valueOf(this.iToFs.rootDir().path()) + fromInfo.fileSysPath())).exists()) continue;
            this.iToFs.mkdir(path);
        }
    }
}

