/*
 * Decompiled with CFR 0.152.
 */
package filedialog;

import filedialog.FileChooser;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import swing.ColorButton;
import swing.EntryField;
import swing.PanelLabel;

public class NewFolderPanel
extends JPanel {
    private FileChooser iChooser = null;
    private ColorButton jOkButton = new ColorButton("Ok");
    private ColorButton jCancelButton = new ColorButton("Cancel");
    private EntryField jFolderName = new EntryField();
    private PanelLabel jLabel = new PanelLabel(" New folder name: ");

    public NewFolderPanel(FileChooser chooser) {
        this.iChooser = chooser;
        this.setLayout(new BoxLayout(this, 0));
        this.setBackground(PanelLabel.backColorAll());
        this.add(this.jLabel);
        this.add(this.jFolderName);
        this.add(this.jOkButton);
        this.add(this.jCancelButton);
        OkHandler handler = new OkHandler();
        this.jOkButton.addActionListener(handler);
        this.jFolderName.addActionListener(handler);
        this.jCancelButton.addActionListener(new CancelHandler());
        this.setEnabled(true);
    }

    @Override
    public void setEnabled(boolean enable) {
        this.jFolderName.setText("");
        this.jLabel.setEnabled(enable);
        this.jFolderName.setEnabled(enable);
        this.jOkButton.setEnabled(enable);
        this.jCancelButton.setEnabled(enable);
    }

    public void putFocus() {
        this.jFolderName.requestFocus();
    }

    private class CancelHandler
    implements ActionListener {
        private CancelHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            NewFolderPanel.this.setEnabled(false);
            NewFolderPanel.this.iChooser.removeNewFolder();
            NewFolderPanel.this.iChooser.enableFolderButton(true);
        }
    }

    private class OkHandler
    implements ActionListener {
        private OkHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            boolean result = NewFolderPanel.this.iChooser.createFolder(NewFolderPanel.this.jFolderName.getText());
            if (result) {
                NewFolderPanel.this.setEnabled(false);
                NewFolderPanel.this.iChooser.removeNewFolder();
                NewFolderPanel.this.iChooser.enableFolderButton(true);
            } else {
                NewFolderPanel.this.jFolderName.setText("Unable to create folder");
                NewFolderPanel.this.jFolderName.requestFocus();
            }
        }
    }
}

