/*
 * Decompiled with CFR 0.152.
 */
package combo;

import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyEditorSupport;
import javax.swing.JButton;
import javax.swing.JPanel;

public class FontForAllPanel
extends JPanel {
    private PropertyEditorSupport iEditor = null;
    private Font iCurFont = null;
    private JButton iFontName = null;
    private JButton iFontSize = null;
    private int iNameIndex = 0;
    private int iSizeIndex = 0;
    private static final String[] FONTNAMES = new String[]{"Dialog", "Serif", "SansSerif"};
    private static final int[] FONTSIZES = new int[]{12, 18, 24};

    public FontForAllPanel(PropertyEditorSupport editor) {
        this.initialize();
        this.iEditor = editor;
        this.iCurFont = (Font)this.iEditor.getValue();
        int i = 0;
        while (i < FONTNAMES.length) {
            if (FONTNAMES[i].equalsIgnoreCase(this.iCurFont.getName())) {
                this.iNameIndex = i;
                this.iFontName.setText(FONTNAMES[this.iNameIndex]);
                break;
            }
            ++i;
        }
        i = 0;
        while (i < FONTSIZES.length) {
            if (FONTSIZES[i] == this.iCurFont.getSize()) {
                this.iSizeIndex = i;
                this.iFontSize.setText(Integer.toString(FONTSIZES[this.iSizeIndex]));
                break;
            }
            ++i;
        }
    }

    private JButton getFontName() {
        if (this.iFontName == null) {
            this.iFontName = new JButton();
            this.iFontName.setBackground(SystemColor.control);
            this.iFontName.setForeground(SystemColor.controlText);
            this.iFontName.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FontForAllPanel fontForAllPanel = FontForAllPanel.this;
                    fontForAllPanel.iNameIndex = fontForAllPanel.iNameIndex + 1;
                    if (FontForAllPanel.this.iNameIndex >= FONTNAMES.length) {
                        FontForAllPanel.this.iNameIndex = 0;
                    }
                    FontForAllPanel.this.iFontName.setText(FONTNAMES[FontForAllPanel.this.iNameIndex]);
                    FontForAllPanel.this.makeFont();
                }
            });
        }
        return this.iFontName;
    }

    private JButton getFontSize() {
        if (this.iFontSize == null) {
            this.iFontSize = new JButton();
            this.iFontSize.setBackground(SystemColor.control);
            this.iFontSize.setForeground(SystemColor.controlText);
            this.iFontSize.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FontForAllPanel fontForAllPanel = FontForAllPanel.this;
                    fontForAllPanel.iSizeIndex = fontForAllPanel.iSizeIndex + 1;
                    if (FontForAllPanel.this.iSizeIndex >= FONTSIZES.length) {
                        FontForAllPanel.this.iSizeIndex = 0;
                    }
                    FontForAllPanel.this.iFontSize.setText(Integer.toString(FONTSIZES[FontForAllPanel.this.iSizeIndex]));
                    FontForAllPanel.this.makeFont();
                }
            });
        }
        return this.iFontSize;
    }

    private void initialize() {
        GridLayout layGridLayout1 = new GridLayout();
        layGridLayout1.setRows(2);
        layGridLayout1.setColumns(1);
        this.setLayout(layGridLayout1);
        this.add((Component)this.getFontName(), null);
        this.add((Component)this.getFontSize(), null);
        this.setSize(206, 104);
    }

    private void makeFont() {
        this.iCurFont = new Font(FONTNAMES[this.iNameIndex], 0, FONTSIZES[this.iSizeIndex]);
        this.iEditor.setValue(this.iCurFont);
        this.iEditor.firePropertyChange();
    }
}

