/*
 * Decompiled with CFR 0.152.
 */
package combo;

import java.awt.Color;
import java.awt.Font;
import java.awt.SystemColor;
import java.util.LinkedList;
import javax.swing.JComboBox;
import utilt.Utility;

public class FifoComboBox
extends JComboBox<Object> {
    private int iMaxItems = 10;
    private Object iLastItem = null;
    private static final int DEFAULTMAXITEMS = 10;
    private static LinkedList<FifoComboBox> Instances = new LinkedList();
    private static Color AllFore = SystemColor.controlText;
    private static Color AllBack = SystemColor.window;
    private static Font AllFont = Utility.stdFont();

    public static void putBackColorAll(Color back) {
        AllBack = back;
        for (FifoComboBox box : Instances) {
            box.setBackground(AllBack);
        }
    }

    public static void putFontAll(Font font) {
        AllFont = font;
        for (FifoComboBox box : Instances) {
            box.setFont(AllFont);
        }
    }

    public static void putForeColorAll(Color fore) {
        AllFore = fore;
        for (FifoComboBox box : Instances) {
            box.setForeground(AllFore);
        }
    }

    public FifoComboBox() {
        this.setBackground(AllBack);
        this.setForeground(AllFore);
        this.setFont(AllFont);
        Instances.add(this);
    }

    public int getMaxItems() {
        return this.iMaxItems;
    }

    public boolean putItem(Object item, boolean allowDuplicates, boolean putAtTail) {
        boolean newItem = true;
        int itemCount = this.getItemCount();
        if (!allowDuplicates) {
            int i = 0;
            while (i < itemCount) {
                if (this.getItemAt(i).equals(item)) {
                    newItem = false;
                    break;
                }
                ++i;
            }
        }
        if (newItem) {
            if (itemCount >= this.iMaxItems) {
                this.removeItemAt(itemCount - 1);
            }
            if (itemCount == 0 || putAtTail) {
                this.addItem(item);
            } else {
                this.insertItemAt(item, 0);
            }
            this.setSelectedIndex(0);
            this.iLastItem = item;
        }
        return newItem;
    }

    public void setMaxItems(int maxItems) {
        this.iMaxItems = maxItems;
    }

    public void setToTop() {
        if (this.iLastItem != null) {
            super.setSelectedItem(this.iLastItem);
        }
    }
}

