/*
 * Decompiled with CFR 0.152.
 */
package clp;

import clp.Clp;
import clp.ColorMap;
import clp.EntryLogger;
import clp.ScriptButton;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.StringTokenizer;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import mlib.MString;
import mswing.WindowPos;
import swing.AdjustableDigit;
import swing.ColorButton;
import swing.ColorPanel;
import swing.ControlButton;
import swing.EntryField;
import swing.PanelLabel;
import swing.Selector;
import swing.StatusBox;
import swing.SwingProgram;
import utilt.GifIconMgr;
import utilt.Utility;

public abstract class AbstractClpGui
extends SwingProgram {
    private ColorPanel iContentPane = new ColorPanel();
    private ColorPanel iAppPanel = null;
    private ColorPanel iMsgPanel = new MsgPanel();
    private EntryLogger iEntryLogger = new EntryLogger();
    private Clp iClp = null;
    public static final String SETUPCMDFILEARG = "u";
    public static final Color BACKGROUND = new Color(240, 240, 240);
    public static final Color SELECT = new Color(220, 220, 220);
    public static final String BUTTONSPANELPARM = "buttonspanel";
    private static final float WINSIZE = 0.75f;
    private static final char DELIM = '|';
    private static final GifIconMgr IconMgr = new GifIconMgr(AbstractClpGui.class, "/icons");

    private static void setup() {
        ColorPanel.putBackColorAll(BACKGROUND);
        ColorButton.putBackColorAll(BACKGROUND);
        PanelLabel.putBackColorAll(BACKGROUND);
        AdjustableDigit.putSelectionColorAll(SELECT);
        AdjustableDigit.putBackColorAll(ColorPanel.backColorAll());
        Selector.putHilightColorAll(SELECT);
        Selector.putBackColorAll(ColorPanel.backColorAll());
        EntryField.putForeColorAll(PanelLabel.foreColorAll());
        EntryField.putFontAll(PanelLabel.fontAll());
    }

    public AbstractClpGui() throws Exception {
        this.iContentPane.setLayout(new BorderLayout());
        this.setContentPane(this.iContentPane);
        this.addWindowListener(new WindowHandler());
        AbstractClpGui.setup();
        String root = System.getProperty("user.dir");
        this.progArgs().addArg("rootdir", "Path of root folder for command files", root, false, 1, 1);
        this.progArgs().addArg("startfile", "Startup command file", null, false, 1, 1);
        this.progArgs().addArg("showhelp", "Show help at startup", null, false, 0, 0);
    }

    protected void setClp(Clp clp) {
        this.iClp = clp;
    }

    protected Clp clp() {
        return this.iClp;
    }

    public void startGui(ColorPanel appPanel, String progTitle) {
        if (appPanel != null) {
            ColorPanel panel = new ColorPanel();
            panel.setLayout(new BorderLayout());
            panel.add((Component)appPanel, "Center");
            ButtonsPanel bPanel = new ButtonsPanel(this.iClp);
            panel.add((Component)bPanel, "South");
            this.iAppPanel = panel;
        }
        StatusBox.singleton().showMsg(Utility.javaEnv(), false);
        StatusBox.singleton().showMsg(progTitle, false);
        this.updateGui(true);
        this.setVisible(true);
        this.iEntryLogger.requestFocus();
        this.iEntryLogger.writeln("startup", false);
        try {
            this.clp().runInitScript();
            if (this.progArgs().argSupplied("startfile")) {
                String name = this.progArgs().argValue("startfile", 0);
                this.clp().runStartScript(name);
            }
        }
        catch (Exception xcp) {
            StatusBox.singleton().showMsg(xcp.toString(), true);
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    protected void startClp() throws Exception {
        String root = this.progArgs().argValue("rootdir", 0);
        if (root == null) {
            root = System.getProperty("user.dir");
        }
        this.iClp.setScriptsRoot(new File(root));
        this.iEntryLogger.setClp(this.iClp);
        this.setLogger(this.iEntryLogger);
        this.iClp.setLogger(this.iEntryLogger);
        this.logger().writeln(this.iClp.toString(), false);
        String script = this.progArgs().argValue(SETUPCMDFILEARG, 0);
        if (script != null) {
            this.iClp.execFile(script);
        }
    }

    protected void updateGui(boolean cmdLine) {
        this.iContentPane.removeAll();
        this.iContentPane.add((Component)this.iMsgPanel, "North");
        if (cmdLine || this.iAppPanel == null) {
            this.iContentPane.add((Component)this.iEntryLogger, "Center");
            this.iEntryLogger.write("", false);
        } else {
            this.iContentPane.add((Component)this.iAppPanel, "Center");
        }
        if (System.getSecurityManager() == null) {
            String path = String.valueOf(System.getProperty("user.dir")) + File.separator + "win.pos";
            try {
                if (!WindowPos.restore(path, this)) {
                    this.centerRel(0.75, 0.75);
                }
            }
            catch (Exception xcp) {
                this.centerRel(0.75, 0.75);
            }
        } else {
            this.centerRel(0.75, 0.75);
        }
        this.validate();
    }

    protected Color findColor(String label) {
        Color color = null;
        ColorMap colors = (ColorMap)this.clp().state().parm("$colormap");
        if (colors != null && (color = colors.color(label)) == null) {
            color = Color.blue;
        }
        return color;
    }

    public static class ButtonsPanel
    extends ColorPanel {
        public ButtonsPanel(Clp clp) {
            this.setLayout(new GridLayout(0, 1));
            LinkedList panels = (LinkedList)clp.state().parm(AbstractClpGui.BUTTONSPANELPARM);
            if (panels != null) {
                for (MString panel : panels) {
                    String[] buttons;
                    String panelName = null;
                    StringTokenizer tken = new StringTokenizer(panel.toString(), ";");
                    if (tken.countTokens() == 2) {
                        panelName = tken.nextToken();
                    }
                    ColorPanel right = new ColorPanel();
                    right.setLayout(new FlowLayout());
                    if (!tken.hasMoreTokens()) continue;
                    MString allButtons = new MString(tken.nextToken());
                    allButtons.trim('|');
                    String[] stringArray = buttons = Utility.strTokens(allButtons.toString(), '|');
                    int n = buttons.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String button = stringArray[n2];
                        String[] buttonTokens = Utility.strTokens(button, '=');
                        String name = buttonTokens[0];
                        MString script = new MString(buttonTokens[1]);
                        String hover = null;
                        if (buttonTokens.length == 3) {
                            hover = buttonTokens[2];
                        }
                        script.remove(".clp", 1, 0);
                        ScriptButton aButton = new ScriptButton(name, script.toString(), hover, clp);
                        right.add(aButton);
                        ++n2;
                    }
                    if (panelName == null) {
                        right.setBorder(SwingProgram.STDBORDER);
                        this.add(right);
                        continue;
                    }
                    ColorPanel row = new ColorPanel();
                    row.setLayout(new BorderLayout());
                    PanelLabel label = new PanelLabel(" " + panelName + ": ");
                    label.setBackground(ColorPanel.backColorAll());
                    label.setMinimumSize(new Dimension(75, 5));
                    row.add((Component)label, "West");
                    row.add((Component)right, "Center");
                    row.setBorder(SwingProgram.STDBORDER);
                    this.add(row);
                }
            }
        }
    }

    private class MsgPanel
    extends ColorPanel {
        private JButton jCmdWinButton = null;
        private boolean iCmdWindowOpen = false;

        public MsgPanel() {
            this.setLayout(new BoxLayout(this, 0));
            this.add(StatusBox.singleton());
            this.add(this.getCmdWinButton());
        }

        private JButton getCmdWinButton() {
            if (this.jCmdWinButton == null) {
                ImageIcon icon = IconMgr.icon("list");
                this.jCmdWinButton = new ControlButton("Toggle command window", icon, 'c');
                this.jCmdWinButton.setEnabled(true);
                this.jCmdWinButton.addActionListener(new CmdButtonHandler());
                this.jCmdWinButton.setToolTipText("Toggle command line display");
            }
            return this.jCmdWinButton;
        }

        private class CmdButtonHandler
        implements ActionListener {
            private CmdButtonHandler() {
            }

            @Override
            public void actionPerformed(ActionEvent event) {
                MsgPanel.this.iCmdWindowOpen = !MsgPanel.this.iCmdWindowOpen;
                AbstractClpGui.this.updateGui(MsgPanel.this.iCmdWindowOpen);
            }
        }
    }

    private class WindowHandler
    extends WindowAdapter {
        private WindowHandler() {
        }

        @Override
        public void windowClosing(WindowEvent event) {
            if (System.getSecurityManager() == null) {
                String path = String.valueOf(System.getProperty("user.dir")) + File.separator + "win.pos";
                WindowPos pos = new WindowPos(AbstractClpGui.this);
                try {
                    pos.write(path);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            System.exit(0);
        }
    }
}

