/*
 * Decompiled with CFR 0.152.
 */
package chart;

import chart.Chart;
import chart.ChartPanel;
import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.Iterator;
import math.Dataset;
import math.DistStats;
import math.XYpoint;
import mswing.StdColor;
import utilt.Utility;

public class HorzOverlapDrawer
extends ChartPanel.Drawer {
    private static HorzOverlapDrawer Singleton = new HorzOverlapDrawer();
    private int iNumBars = 0;
    private float iMinX = Float.MAX_VALUE;
    private float iMaxX = -3.4028235E38f;
    private static final int MINPIX = 2;
    private static final int BARGAP = 25;
    private static final int CONFIDENCELEVEL = 2;

    public static HorzOverlapDrawer singleton() {
        return Singleton;
    }

    private static void checkData(Collection<Dataset.List<XYpoint.Float>> sets) throws Exception {
        for (Dataset.List<XYpoint.Float> set : sets) {
            Iterator<XYpoint.Float> iter = set.iterator();
            while (iter.hasNext()) {
                XYpoint.Float point = iter.next();
                if (point.x() == -99999.0) {
                    Utility.throwError("HorzOverlapDrawer: x required");
                }
                if (point.y() == -99999.0) {
                    Utility.throwError("HorzOverlapDrawer: y (bar width) required");
                    continue;
                }
                if (!(point.y() < 2.0)) continue;
                Utility.throwError("HorzOverlapDrawer: y (bar width) must be >= 2");
            }
        }
    }

    @Override
    public boolean yMinAlwaysZero() {
        return false;
    }

    @Override
    public float minX(Chart chart) {
        this.setup(chart);
        return this.iMinX;
    }

    @Override
    public float maxX(Chart chart) {
        this.setup(chart);
        return this.iMaxX;
    }

    @Override
    public float minY(Chart chart) {
        this.setup(chart);
        return 0.0f;
    }

    @Override
    public float maxY(Chart chart) {
        this.setup(chart);
        return this.iNumBars;
    }

    @Override
    public void draw(Chart chart, ChartPanel panel, Graphics2D g2) throws Exception {
        Chart.HorzOverlapAppearance app = (Chart.HorzOverlapAppearance)chart.appearance();
        Collection<Dataset.List<XYpoint.Float>> sets = chart.sets();
        HorzOverlapDrawer.checkData(sets);
        float panelHeight = panel.innerBoundary().getHeight();
        float spacing = 0.05f * panelHeight;
        float avail = panelHeight - spacing - (float)((this.iNumBars - 1) * 25);
        float barHeight = avail / (float)this.iNumBars;
        if (barHeight < 2.0f) {
            Utility.throwError("HorzOverlapDrawer: not enough space for bars");
        }
        float yTop = panel.innerBoundary().getY() + 0.5f * spacing;
        for (Dataset.List<XYpoint.Float> set : sets) {
            Iterator<XYpoint.Float> iter = set.iterator();
            while (iter.hasNext()) {
                XYpoint.Float point = iter.next();
                XYpoint.Float xLeft = new XYpoint.Float((float)point.x(), 0.0f);
                XYpoint.Float xRight = new XYpoint.Float((float)(point.x() + point.y()), 0.0f);
                float width = panel.xPos(xRight) - panel.xPos(xLeft);
                XYpoint.Float barPoint = new XYpoint.Float((float)xLeft.x(), yTop);
                Rectangle2D.Float bar = new Rectangle2D.Float(panel.xPos(barPoint), yTop, width, barHeight);
                StdColor color = point.stdColor();
                if (color == null) {
                    color = app.defaultItemColor();
                }
                g2.setPaint(color.color());
                g2.fill(bar);
                Object obj = point.persistObject();
                if (obj == null) {
                    obj = point.object();
                }
                if (obj != null && obj.getClass() == DistStats.class) {
                    HorzOverlapDrawer.drawDistStats(chart, panel, bar, (DistStats)obj, g2);
                }
                yTop += barHeight + 25.0f;
            }
        }
    }

    private static void drawDistStats(Chart chart, ChartPanel panel, Rectangle2D bar, DistStats stats, Graphics2D g2) {
        Chart.HorzOverlapAppearance app = (Chart.HorzOverlapAppearance)chart.appearance();
        float stroke = app.emphasisLineWidth().intValue();
        float halfStroke = 0.5f * stroke;
        float x = (float)stats.avg();
        XYpoint.Float xLine = new XYpoint.Float(x, 0.0f);
        float xPos = panel.xPos(xLine);
        Point2D.Float top = new Point2D.Float(xPos, (float)(bar.getY() + (double)halfStroke));
        Point2D.Float bottom = new Point2D.Float(xPos, (float)(bar.getY() + bar.getHeight() - (double)halfStroke));
        Line2D.Float line = new Line2D.Float(top, bottom);
        g2.setPaint(StdColor.BLACK.color());
        g2.setStroke(new BasicStroke(stroke));
        g2.draw(line);
        g2.setStroke(new BasicStroke(app.boundaryWidth().intValue()));
        x = (float)(stats.avg() - 2.0 * stats.sigmaOfAvg());
        xLine = new XYpoint.Float(x, 0.0f);
        xPos = panel.xPos(xLine);
        top = new Point2D.Float(xPos, (float)(bar.getY() + (double)halfStroke));
        bottom = new Point2D.Float(xPos, (float)(bar.getY() + bar.getHeight() - (double)halfStroke));
        line = new Line2D.Float(top, bottom);
        g2.draw(line);
        x = (float)(stats.avg() + 2.0 * stats.sigmaOfAvg());
        xLine = new XYpoint.Float(x, 0.0f);
        xPos = panel.xPos(xLine);
        top = new Point2D.Float(xPos, (float)(bar.getY() + (double)halfStroke));
        bottom = new Point2D.Float(xPos, (float)(bar.getY() + bar.getHeight() - (double)halfStroke));
        line = new Line2D.Float(top, bottom);
        g2.draw(line);
    }

    private void setup(Chart chart) {
        if (this.iNumBars == 0) {
            Collection<Dataset.List<XYpoint.Float>> sets = chart.sets();
            for (Dataset.List<XYpoint.Float> set : sets) {
                Iterator<XYpoint.Float> iter = set.iterator();
                while (iter.hasNext()) {
                    float max;
                    XYpoint.Float point = iter.next();
                    ++this.iNumBars;
                    float min = (float)point.x();
                    if (min < this.iMinX) {
                        this.iMinX = min;
                    }
                    if (!((max = (float)(point.x() + point.y())) > this.iMaxX)) continue;
                    this.iMaxX = max;
                }
            }
        }
    }

    private HorzOverlapDrawer() {
    }
}

