/*
 * Decompiled with CFR 0.152.
 */
package chart;

import chart.Chart;
import java.awt.BasicStroke;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import math.Dataset;
import math.XYpoint;
import mlib.MString;
import mswing.StdColor;
import swing.ColorPanel;
import swing.HoverMgr;
import swing.StatusBox;

public class ChartPanel
extends ColorPanel {
    private Chart iChart = null;
    private int iLeftMargin = 0;
    private int iRightMargin = 0;
    private Rectangle iOuterBoundary = null;
    private Rectangle iInnerBoundary = null;
    private float iMinScaleY = -99999.0f;
    private float iMaxScaleY = -99999.0f;
    private float iMinScaleX = -99999.0f;
    private float iMaxScaleX = -99999.0f;
    private HoverMgr iHoverMgr = null;
    private static final int TICKLEN = 5;
    private static final int UNCERLINEWIDTH = 1;
    private static final String LINESGROUP = "lines";
    private static final String FUNCSGROUP = "functions";

    private static int labelGap() {
        Toolkit tKit = Toolkit.getDefaultToolkit();
        Dimension screen = tKit.getScreenSize();
        int gap = (int)(0.5 + (double)screen.width * 0.01);
        return gap;
    }

    private static float adjustScale(float value, DecimalFormat format, boolean up) {
        char[] chars;
        char last;
        float result = value;
        boolean carry = false;
        String formatted = format.format(Math.abs(value));
        MString str = new MString(formatted);
        if (str.equals("0")) {
            result = 0.0f;
        } else if (str.length() > 1 && (last = (chars = str.toCharArray())[chars.length - 1]) != '0') {
            int i = chars.length - 1;
            chars[i--] = 48;
            if (up || value < 0.0f) {
                carry = true;
                while (i >= 0 && carry) {
                    if (chars[i] != '.') {
                        if (chars[i] <= '8') {
                            int n = i;
                            chars[n] = (char)(chars[n] + '\u0001');
                            carry = false;
                        } else if (chars[i] == '9') {
                            chars[i] = 48;
                            carry = true;
                        }
                    }
                    --i;
                }
            }
            str = new MString(chars);
            try {
                if (up && carry) {
                    str.insert('1', 0);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            result = Float.parseFloat(str.toString());
            if (value < 0.0f && result > Float.MIN_VALUE) {
                result *= -1.0f;
            }
        }
        return result;
    }

    public ChartPanel(Chart chart) throws Exception {
        this.iChart = chart;
        this.iHoverMgr = new HoverMgr(this);
    }

    public Chart chart() {
        return this.iChart;
    }

    public Rectangle innerBoundary() {
        return this.iInnerBoundary;
    }

    public HoverMgr hoverMgr() {
        return this.iHoverMgr;
    }

    public float xPos(XYpoint.Float point) {
        return this.xPos((float)point.x());
    }

    public float yPos(XYpoint.Float point) {
        return this.yPos((float)point.y());
    }

    public float minScaleY() {
        return this.iMinScaleY;
    }

    public float maxScaleY() {
        return this.iMaxScaleY;
    }

    public float minScaleX() {
        return this.iMinScaleX;
    }

    public float maxScaleX() {
        return this.iMaxScaleX;
    }

    public void rescale() {
        this.iMinScaleY = -99999.0f;
        this.iMaxScaleY = -99999.0f;
        this.iMinScaleX = -99999.0f;
        this.iMaxScaleX = -99999.0f;
    }

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        super.paintComponent(g2);
        Chart.Appearance app = this.iChart.appearance();
        this.setBackground(app.pageColor().color());
        if (this.iChart.sets().size() > 0) {
            this.scaleX(app);
            this.scaleY(app);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            this.drawBoundary(g2);
            if (this.iChart.xLabel().length() > 0) {
                this.drawXLabel(g2);
            }
            if (this.iChart.yLabel().length() > 0) {
                this.drawYLabel(g2);
            }
            if (this.iChart.title().length() > 0) {
                this.drawTitle(g2);
            }
            if (app.isShowYTicks().booleanValue()) {
                this.drawYTicks(g2);
            }
            if (app.isShowXTicks().booleanValue()) {
                this.drawXTicks(g2);
            }
            if (app.isShowXScales().booleanValue()) {
                this.drawXScales(g2);
            }
            if (app.isShowLegend().booleanValue()) {
                this.drawLegend(g2);
            }
            this.iHoverMgr.clear(LINESGROUP);
            this.iHoverMgr.clear(FUNCSGROUP);
            try {
                Collection<FuncDrawer> funcs = this.iChart.funcs();
                for (FuncDrawer func : funcs) {
                    func.draw(this, g2);
                }
                Collection<Dataset.List<XYpoint.Float>> sets = this.iChart.sets();
                for (Dataset.List<XYpoint.Float> set : sets) {
                    this.iHoverMgr.clear(set.name());
                }
                this.iChart.drawer().draw(this.iChart, this, g2);
                Collection<Chart.HorzLine> horzLines = this.iChart.horzLines();
                for (Chart.HorzLine line : horzLines) {
                    if (!(line.yPos() > this.iMinScaleY) || !(line.yPos() < this.iMaxScaleY)) continue;
                    this.drawLine(line, g2);
                }
                Collection<Chart.VertLine> vertLines = this.iChart.vertLines();
                for (Chart.VertLine line : vertLines) {
                    if (!(line.xPos() > this.iMinScaleX) || !(line.xPos() < this.iMaxScaleX)) continue;
                    this.drawLine(line, g2);
                }
            }
            catch (Exception xcp) {
                StatusBox.singleton().showMsg(xcp.toString(), true);
            }
        }
    }

    private void drawBoundary(Graphics2D g2) {
        float width = this.getSize().width;
        float height = this.getSize().height;
        DecimalFormat format = new DecimalFormat(this.iChart.appearance().yScalesFormat());
        String topVertLabel = format.format(this.iMaxScaleY);
        String botVertLabel = format.format(this.iMinScaleY);
        g2.setPaint(this.iChart.appearance().axesColor().color());
        float boundaryWidth = this.iChart.appearance().boundaryWidth().intValue();
        float halfBoundary = 0.5f * boundaryWidth;
        this.iLeftMargin = this.leftMargin(g2, topVertLabel, botVertLabel);
        this.iRightMargin = this.rightMargin(g2);
        int vertMargin = this.iChart.appearance().vertMargin();
        width = width - (float)this.iLeftMargin - (float)this.iRightMargin;
        Rectangle2D.Float boundary = new Rectangle2D.Float(this.iLeftMargin, vertMargin, width, height -= (float)(2 * vertMargin));
        g2.setStroke(new BasicStroke(boundaryWidth));
        g2.draw(boundary);
        this.iOuterBoundary = new Rectangle((float)this.iLeftMargin - halfBoundary, (float)vertMargin - halfBoundary, width + boundaryWidth, height + boundaryWidth);
        this.iInnerBoundary = new Rectangle((float)this.iLeftMargin + halfBoundary, (float)vertMargin + halfBoundary, width -= boundaryWidth, height -= boundaryWidth);
        g2.setPaint(this.iChart.appearance().chartColor().color());
        g2.fill(this.iInnerBoundary.getRect());
        if (this.iChart.appearance().isShowYScales().booleanValue()) {
            this.drawYScales(g2, topVertLabel, botVertLabel);
        }
    }

    private int leftMargin(Graphics2D g2, String topVertLabel, String botVertLabel) {
        FontRenderContext context;
        float boundaryWidth = this.iChart.appearance().boundaryWidth().intValue();
        float halfBoundary = 0.5f * boundaryWidth;
        int margin = this.iChart.appearance().leftMargin();
        Font font = this.iChart.appearance().scalesFont();
        Rectangle2D bounds = font.getStringBounds(topVertLabel, context = g2.getFontRenderContext());
        float aMargin = halfBoundary + (float)bounds.getWidth() + (float)ChartPanel.labelGap();
        if (aMargin > (float)margin) {
            margin = (int)((double)aMargin + 0.5);
        }
        if ((aMargin = (float)(bounds = font.getStringBounds(botVertLabel, context)).getWidth() + halfBoundary + (float)ChartPanel.labelGap()) > (float)margin) {
            margin = (int)((double)aMargin + 0.5);
        }
        return margin;
    }

    private int rightMargin(Graphics2D g2) {
        Collection<Chart.LegendItem> items;
        Chart.Appearance app = this.iChart.appearance();
        int margin = app.leftMargin() / 2;
        if (app.isShowLegend().booleanValue() && (items = this.iChart.legendItems()).size() > 0) {
            float maxSize = 0.0f;
            Font font = app.labelsFont();
            FontRenderContext context = g2.getFontRenderContext();
            for (Chart.LegendItem item : items) {
                Rectangle2D bounds = font.getStringBounds(item.text(), context);
                if (!((float)bounds.getWidth() > maxSize)) continue;
                maxSize = (float)bounds.getWidth();
            }
            if ((maxSize += (float)(2 * ChartPanel.labelGap())) > (float)margin) {
                margin = (int)((double)maxSize + 0.5);
            }
        }
        return margin;
    }

    private void drawTitle(Graphics2D g2) {
        Font font = this.iChart.appearance().titleFont();
        g2.setFont(font);
        String title = this.iChart.title();
        FontRenderContext context = g2.getFontRenderContext();
        float descent = font.getLineMetrics(title, context).getDescent();
        Rectangle2D bounds = font.getStringBounds(title, context);
        float y = this.iOuterBoundary.getY() - 3.0f * descent;
        float x = this.iInnerBoundary.getX() + (this.iInnerBoundary.getWidth() - (float)bounds.getWidth()) / 2.0f;
        g2.setPaint(this.iChart.appearance().titleColor().color());
        g2.drawString(title, (int)x, (int)y);
    }

    private void drawYLabel(Graphics2D g2) {
        float height = this.getSize().height;
        Font font = this.iChart.appearance().labelsFont();
        g2.setFont(font);
        String label = this.iChart.yLabel();
        FontRenderContext context = g2.getFontRenderContext();
        Rectangle2D bounds = font.getStringBounds(label, context);
        float y = this.iOuterBoundary.getX() - (float)(2 * ChartPanel.labelGap());
        float x = -1.0f * (height / 2.0f + (float)bounds.getWidth() / 2.0f);
        AffineTransform save = g2.getTransform();
        AffineTransform at = new AffineTransform();
        at.setToRotation(-1.5707963267948966, 0.0, 0.0);
        g2.setTransform(at);
        g2.setPaint(this.iChart.appearance().labelsColor().color());
        g2.drawString(label, (int)x, (int)y);
        g2.setTransform(save);
    }

    private void drawYTicks(Graphics2D g2) {
        Chart.Appearance app = this.iChart.appearance();
        float tickWidth = app.tickWidth().intValue();
        float halfTick = tickWidth / 2.0f;
        g2.setStroke(new BasicStroke(tickWidth));
        g2.setPaint(app.ticksColor().color());
        float yGap = this.iInnerBoundary.getHeight() / (float)(app.numYTicks() + 1);
        float y = this.iInnerBoundary.getY() + yGap;
        float yMax = this.iInnerBoundary.getY() + this.iInnerBoundary.getHeight();
        while (y < yMax) {
            Line2D.Float line;
            Point2D.Float right;
            Point2D.Float left;
            float x;
            if (!app.isExtendTicks().booleanValue()) {
                x = this.iInnerBoundary.getX() + halfTick;
                left = new Point2D.Float(x, y);
                right = new Point2D.Float(x + 5.0f, y);
                line = new Line2D.Float(left, right);
                g2.draw(line);
                x = this.iInnerBoundary.getX() + this.iInnerBoundary.getWidth() - halfTick;
                left = new Point2D.Float(x, y);
                right = new Point2D.Float(x - 5.0f, y);
                line = new Line2D.Float(left, right);
                g2.draw(line);
            } else {
                x = this.iInnerBoundary.getX() + halfTick;
                left = new Point2D.Float(x, y);
                right = new Point2D.Float(x + this.iInnerBoundary.getWidth() - tickWidth, y);
                line = new Line2D.Float(left, right);
                g2.draw(line);
            }
            y += yGap;
        }
    }

    private void drawYScales(Graphics2D g2, String topLabel, String botLabel) {
        float halfBoundary = this.iChart.appearance().boundaryWidth() / 2;
        Font font = this.iChart.appearance().scalesFont();
        g2.setFont(font);
        g2.setPaint(this.iChart.appearance().scalesColor().color());
        FontRenderContext context = g2.getFontRenderContext();
        Rectangle2D bounds = font.getStringBounds(topLabel, context);
        float descent = font.getLineMetrics(topLabel, context).getDescent();
        float x = (float)((double)this.iOuterBoundary.getX() - bounds.getWidth() - (double)ChartPanel.labelGap());
        float y = this.iOuterBoundary.getY() + halfBoundary + descent;
        g2.drawString(topLabel, (int)x, (int)y);
        bounds = font.getStringBounds(botLabel, context);
        descent = font.getLineMetrics(botLabel, context).getDescent();
        x = this.iOuterBoundary.getX() - (float)bounds.getWidth() - (float)ChartPanel.labelGap();
        y = this.iOuterBoundary.getY() + this.iOuterBoundary.getHeight() - halfBoundary + descent;
        g2.drawString(botLabel, (int)x, (int)y);
    }

    private void drawXLabel(Graphics2D g2) {
        Font font = this.iChart.appearance().labelsFont();
        g2.setFont(font);
        String label = this.iChart.xLabel();
        FontRenderContext context = g2.getFontRenderContext();
        Rectangle2D bounds = font.getStringBounds(label, context);
        float x = this.iInnerBoundary.getX() + (this.iInnerBoundary.getWidth() - (float)bounds.getWidth()) / 2.0f;
        float y = this.iOuterBoundary.getY() + this.iOuterBoundary.getHeight() + (float)bounds.getHeight() + (float)ChartPanel.labelGap() * 0.5f;
        g2.setPaint(this.iChart.appearance().labelsColor().color());
        g2.drawString(label, (int)x, (int)y);
    }

    private void drawXTicks(Graphics2D g2) {
        Chart.Appearance app = this.iChart.appearance();
        float tickWidth = app.tickWidth().intValue();
        float halfTick = tickWidth / 2.0f;
        g2.setStroke(new BasicStroke(app.tickWidth().intValue()));
        g2.setPaint(this.iChart.appearance().ticksColor().color());
        float xGap = this.iInnerBoundary.getWidth() / (float)(app.numXTicks() + 1);
        float x = this.iInnerBoundary.getX() + xGap;
        float xMax = this.iInnerBoundary.getX() + this.iInnerBoundary.getWidth();
        while (x < xMax) {
            Line2D.Float line;
            Point2D.Float top;
            Point2D.Float bottom;
            float y;
            if (!this.iChart.appearance().isExtendTicks().booleanValue()) {
                y = this.iInnerBoundary.getY() + this.iInnerBoundary.getHeight() - halfTick;
                bottom = new Point2D.Float(x, y);
                top = new Point2D.Float(x, y - 5.0f);
                line = new Line2D.Float(bottom, top);
                g2.draw(line);
                y = this.iInnerBoundary.getY() + halfTick;
                top = new Point2D.Float(x, y);
                bottom = new Point2D.Float(x, y + 5.0f);
                line = new Line2D.Float(top, bottom);
                g2.draw(line);
            } else {
                y = this.iInnerBoundary.getY() + this.iInnerBoundary.getHeight() - halfTick;
                g2.setStroke(new BasicStroke(tickWidth));
                bottom = new Point2D.Float(x, y);
                top = new Point2D.Float(x, this.iInnerBoundary.getY() + tickWidth / 2.0f);
                line = new Line2D.Float(bottom, top);
                g2.draw(line);
            }
            x += xGap;
        }
    }

    private void drawXScales(Graphics2D g2) {
        float halfBoundary = this.iChart.appearance().boundaryWidth() / 2;
        DecimalFormat format = new DecimalFormat(this.iChart.appearance().xScalesFormat());
        String leftLabel = format.format(this.iMinScaleX);
        String rightLabel = format.format(this.iMaxScaleX);
        Font font = this.iChart.appearance().scalesFont();
        g2.setFont(font);
        g2.setPaint(this.iChart.appearance().scalesColor().color());
        FontRenderContext context = g2.getFontRenderContext();
        Rectangle2D bounds = font.getStringBounds(leftLabel, context);
        float x = this.iOuterBoundary.getX() - (float)bounds.getWidth() / 2.0f + halfBoundary;
        float y = this.iOuterBoundary.getY() + this.iOuterBoundary.getHeight() + (float)bounds.getHeight() + (float)(ChartPanel.labelGap() / 2);
        g2.drawString(leftLabel, (int)x, (int)y);
        bounds = font.getStringBounds(rightLabel, context);
        x = (float)((double)(this.iOuterBoundary.getX() + this.iOuterBoundary.getWidth() - halfBoundary) - bounds.getWidth() / 2.0);
        g2.drawString(rightLabel, (int)x, (int)y);
    }

    private void scaleX(Chart.Appearance app) {
        DecimalFormat format;
        this.iMinScaleX = app.minX().floatValue();
        if (this.iMinScaleX == -99999.0f && this.iMinScaleX == -99999.0f) {
            format = new DecimalFormat(this.iChart.appearance().xScalesFormat());
            this.iMinScaleX = ChartPanel.adjustScale(this.iChart.drawer().minX(this.iChart), format, false);
        }
        this.iMaxScaleX = app.maxX().floatValue();
        if (this.iMaxScaleX == -99999.0f && this.iMaxScaleX == -99999.0f) {
            format = new DecimalFormat(this.iChart.appearance().xScalesFormat());
            this.iMaxScaleX = ChartPanel.adjustScale(this.iChart.drawer().maxX(this.iChart), format, true);
        }
    }

    private void scaleY(Chart.Appearance app) {
        DecimalFormat format;
        this.iMinScaleY = app.minY().floatValue();
        if (this.iMinScaleY == -99999.0f && this.iMinScaleY == -99999.0f) {
            format = new DecimalFormat(this.iChart.appearance().yScalesFormat());
            this.iMinScaleY = ChartPanel.adjustScale(this.iChart.drawer().minY(this.iChart), format, false);
        }
        this.iMaxScaleY = app.maxY().floatValue();
        if (this.iMaxScaleY == -99999.0f && this.iMaxScaleY == -99999.0f) {
            format = new DecimalFormat(this.iChart.appearance().yScalesFormat());
            this.iMaxScaleY = ChartPanel.adjustScale(this.iChart.drawer().maxY(this.iChart), format, true);
        }
    }

    private void drawLine(Chart.HorzLine line, Graphics2D g2) {
        float boundaryWidth = this.iChart.appearance().boundaryWidth().intValue();
        float halfBoundary = boundaryWidth / 2.0f;
        float y = this.yPos(line.yPos());
        float x = this.iInnerBoundary.getX() + halfBoundary;
        Point2D.Float left = new Point2D.Float(x, y);
        float xRight = this.iInnerBoundary.getX() + this.iInnerBoundary.getWidth() - halfBoundary;
        Point2D.Float right = new Point2D.Float(xRight, y);
        Line2D.Float line2d = new Line2D.Float(left, right);
        g2.setPaint(line.color().color());
        float width = line.width();
        if (width <= 1.0f) {
            width = 2.0f;
        }
        g2.setStroke(new BasicStroke(width));
        g2.draw(line2d);
        Rectangle2D.Float rect = new Rectangle2D.Float(x, y - halfBoundary, this.iInnerBoundary.getWidth() - halfBoundary, boundaryWidth);
        this.hoverMgr().add(LINESGROUP, line.label(), rect);
        if (line.uncer() != -1.0f) {
            y = this.yPos(line.yPos() - line.uncer());
            left = new Point2D.Float(x, y);
            right = new Point2D.Float(xRight, y);
            line2d = new Line2D.Float(left, right);
            g2.setStroke(new BasicStroke(1.0f));
            g2.draw(line2d);
            y = this.yPos(line.yPos() + line.uncer());
            left = new Point2D.Float(x, y);
            right = new Point2D.Float(xRight, y);
            line2d = new Line2D.Float(left, right);
            g2.draw(line2d);
        }
    }

    private void drawLine(Chart.VertLine line, Graphics2D g2) {
        float width = line.width();
        float halfWidth = width / 2.0f;
        if (width <= 1.0f) {
            width = 2.0f;
        }
        float boundaryWidth = this.iChart.appearance().boundaryWidth().intValue();
        float halfBoundary = boundaryWidth / 2.0f;
        float x = this.xPos(line.xPos());
        float y = this.iInnerBoundary.getY() + this.iInnerBoundary.getHeight() - halfWidth;
        g2.setStroke(new BasicStroke(width));
        g2.setPaint(line.color().color());
        Point2D.Float bottom = new Point2D.Float(x, y);
        Point2D.Float top = new Point2D.Float(x, this.iInnerBoundary.getY() + halfWidth);
        Line2D.Float line2d = new Line2D.Float(bottom, top);
        g2.draw(line2d);
        Rectangle2D.Float rect = new Rectangle2D.Float(x - halfBoundary, this.iInnerBoundary.getY(), boundaryWidth, this.iInnerBoundary.getY() + this.iInnerBoundary.getHeight());
        this.hoverMgr().add(LINESGROUP, line.label(), rect);
        if (line.uncer() != -1.0f) {
            float halfUncer = 0.0f;
            x = this.xPos(line.xPos() - line.uncer());
            y = this.iInnerBoundary.getY() + this.iInnerBoundary.getHeight() - halfUncer;
            g2.setStroke(new BasicStroke(1.0f));
            bottom = new Point2D.Float(x, y);
            top = new Point2D.Float(x, this.iInnerBoundary.getY() + halfUncer);
            line2d = new Line2D.Float(bottom, top);
            g2.draw(line2d);
            x = this.xPos(line.xPos() + line.uncer());
            bottom = new Point2D.Float(x, y - halfUncer);
            top = new Point2D.Float(x, this.iInnerBoundary.getY() + halfUncer);
            line2d = new Line2D.Float(bottom, top);
            g2.draw(line2d);
        }
    }

    private void drawLegend(Graphics2D g2) {
        Collection<Chart.LegendItem> items = this.iChart.legendItems();
        if (items.size() > 0) {
            Font font = this.iChart.appearance().labelsFont();
            g2.setFont(font);
            FontRenderContext context = g2.getFontRenderContext();
            Iterator<Chart.LegendItem> iter = items.iterator();
            Rectangle2D bounds = font.getStringBounds(iter.next().text(), context);
            float height = (float)(items.size() + 1) * (float)bounds.getHeight() * 2.0f;
            float y = this.iOuterBoundary.getY() + (float)bounds.getHeight() + (this.iOuterBoundary.getHeight() - height) / 2.0f;
            float xLeft = this.iOuterBoundary.getX() + this.iOuterBoundary.getWidth();
            for (Chart.LegendItem item : items) {
                g2.setPaint(item.color().color());
                bounds = font.getStringBounds(item.text(), context);
                float x = xLeft + ((float)this.iRightMargin - (float)bounds.getWidth()) / 2.0f;
                MString text = new MString(item.text());
                text.capFirstChar();
                g2.drawString(text.toString(), (int)x, (int)y);
                y = (float)((double)y + bounds.getHeight());
                g2.drawString("", (int)x, (int)y);
                y = (float)((double)y + bounds.getHeight());
            }
        }
    }

    private float xPos(float x) {
        double width = this.iInnerBoundary.getWidth();
        double factor = (x - this.iMinScaleX) / (this.iMaxScaleX - this.iMinScaleX);
        double pos = (double)this.iInnerBoundary.getX() + width * factor;
        return (float)pos;
    }

    private float yPos(float y) {
        double height = this.iInnerBoundary.getHeight();
        double factor = (y - this.iMinScaleY) / (this.iMaxScaleY - this.iMinScaleY);
        double pos = (double)this.iInnerBoundary.getY() + height - height * factor;
        return (float)pos;
    }

    public static abstract class Drawer {
        public abstract void draw(Chart var1, ChartPanel var2, Graphics2D var3) throws Exception;

        public float minX(Chart chart) {
            return chart.minX();
        }

        public float maxX(Chart chart) {
            return chart.maxX();
        }

        public float minY(Chart chart) {
            return chart.minY();
        }

        public float maxY(Chart chart) {
            return chart.maxY();
        }

        public abstract boolean yMinAlwaysZero();
    }

    public static abstract class FuncDrawer
    implements Serializable {
        private int iLineWidth = 3;
        private StdColor iColor = null;
        private String iLabel = null;
        private static final long serialVersionUID = 1433480262372468556L;

        public FuncDrawer(int lineWidth, StdColor color, String label) {
            this.iColor = color;
            this.iLabel = label;
            this.iLineWidth = lineWidth;
            int rem = this.iLineWidth % 2;
            if (rem == 0) {
                ++this.iLineWidth;
            }
        }

        public int lineWidth() {
            return this.iLineWidth;
        }

        public StdColor color() {
            return this.iColor;
        }

        public String label() {
            return this.iLabel;
        }

        public abstract float xInc(ChartPanel var1);

        public abstract void draw(ChartPanel var1, Graphics2D var2) throws Exception;

        protected void drawPoints(ChartPanel panel, LinkedList<Point2D.Float> points, Graphics2D g2) {
            Rectangle inner = panel.innerBoundary();
            Rectangle boundary = new Rectangle(inner.getX() - (float)this.iLineWidth, inner.getY() + (float)this.iLineWidth, inner.getWidth() - (float)(2 * this.iLineWidth), inner.getHeight() - (float)(2 * this.iLineWidth));
            float lastXPix = Float.MIN_VALUE;
            float lastYPix = Float.MIN_VALUE;
            g2.setPaint(this.iColor.color());
            g2.setStroke(new BasicStroke(this.iLineWidth));
            for (Point2D.Float point : points) {
                float xPix = panel.xPos((float)point.getX());
                float yPix = panel.yPos((float)point.getY());
                if (!boundary.getRect().contains(xPix, yPix)) continue;
                if (lastXPix != Float.MIN_VALUE) {
                    g2.drawLine((int)lastXPix, (int)lastYPix, (int)xPix, (int)yPix);
                }
                lastXPix = xPix;
                lastYPix = yPix;
            }
            Rectangle2D.Float shape = new Rectangle2D.Float(lastXPix - (float)this.iLineWidth, lastYPix - (float)this.iLineWidth, 2 * this.iLineWidth, 2 * this.iLineWidth);
            g2.fill(shape);
            panel.hoverMgr().add(ChartPanel.FUNCSGROUP, this.iLabel, shape);
        }
    }

    public static class LineDrawer
    extends FuncDrawer {
        private float iInter = 0.0f;
        private float iSlope = 0.0f;
        private static final long serialVersionUID = 1338398450620382286L;

        public LineDrawer(int lineWidth, StdColor color, String label, float inter, float slope) throws Exception {
            super(lineWidth, color, label);
            this.iInter = inter;
            this.iSlope = slope;
        }

        @Override
        public float xInc(ChartPanel panel) {
            float inc = (panel.maxScaleX() - panel.minScaleX()) / panel.innerBoundary().getWidth();
            return inc;
        }

        @Override
        public void draw(ChartPanel panel, Graphics2D g2) {
            LinkedList<Point2D.Float> points = new LinkedList<Point2D.Float>();
            float inc = this.xInc(panel);
            float x = panel.minScaleX();
            while (x < panel.maxScaleX()) {
                float y = this.iSlope * x + this.iInter;
                points.add(new Point2D.Float(x, y));
                x += inc;
            }
            this.drawPoints(panel, points, g2);
        }
    }

    public static class Rectangle {
        private Rectangle2D.Float iRect = null;

        public Rectangle(float x, float y, float width, float height) {
            this.iRect = new Rectangle2D.Float(x, y, width, height);
        }

        public float getX() {
            return (float)this.iRect.getX();
        }

        public float getY() {
            return (float)this.iRect.getY();
        }

        public float getWidth() {
            return (float)this.iRect.getWidth();
        }

        public float getHeight() {
            return (float)this.iRect.getHeight();
        }

        public Rectangle2D.Float getRect() {
            return this.iRect;
        }
    }
}

