/*
 * Decompiled with CFR 0.152.
 */
package chart;

import chart.ChartPanel;
import chart.HorzOverlapDrawer;
import chart.ScatterDrawer;
import chart.VertBarDrawer;
import java.awt.Font;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.TreeSet;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import math.Dataset;
import math.XYpoint;
import mlib.MString;
import mlib.MTextDataTable;
import mswing.StdColor;
import utilt.Utility;

public class Chart
implements Serializable {
    private String iTitle = "";
    private String iXLabel = "";
    private String iYLabel = "";
    private LinkedList<Dataset.List<XYpoint.Float>> iSets = new LinkedList();
    private LinkedList<HorzLine> iHorzLines = new LinkedList();
    private LinkedList<VertLine> iVertLines = new LinkedList();
    private LinkedList<LegendItem> iLegendItems = new LinkedList();
    private LinkedList<ChartPanel.FuncDrawer> iFuncs = new LinkedList();
    private Appearance iAppearance = null;
    private transient ChartPanel.Drawer iDrawer = null;
    public static final String FILEEXT = ".cht";
    public static final String APPEXT = ".cap";
    public static final float NOUNCER = -1.0f;
    private static final long serialVersionUID = 6984814297663672441L;

    public static Chart read(String path) throws Exception {
        GZIPInputStream zipin = new GZIPInputStream(new FileInputStream(path));
        ObjectInputStream in = new ObjectInputStream(zipin);
        Chart chart = (Chart)in.readObject();
        in.close();
        return chart;
    }

    public Chart(String xLabel, String yLabel, String title, Appearance appearance) {
        this.iXLabel = xLabel;
        this.iYLabel = yLabel;
        this.iTitle = title;
        this.iAppearance = appearance;
        this.setupDrawer();
    }

    public String xLabel() {
        return this.iXLabel;
    }

    public void setXLabel(String xLabel) {
        this.iXLabel = xLabel;
    }

    public String yLabel() {
        return this.iYLabel;
    }

    public void setYLabel(String yLabel) {
        this.iYLabel = yLabel;
    }

    public String title() {
        return this.iTitle;
    }

    public void setTitle(String title) {
        this.iTitle = title;
    }

    public ChartPanel.Drawer drawer() {
        return this.iDrawer;
    }

    public Appearance appearance() {
        return this.iAppearance;
    }

    public void addLegend(LegendItem item) {
        this.iLegendItems.add(item);
    }

    public Collection<LegendItem> legendItems() {
        return this.iLegendItems;
    }

    public void addHorzLine(HorzLine line) {
        this.iHorzLines.add(line);
    }

    public Collection<HorzLine> horzLines() {
        return this.iHorzLines;
    }

    public void addVertLine(VertLine line) {
        this.iVertLines.add(line);
    }

    public Collection<VertLine> vertLines() {
        return this.iVertLines;
    }

    public void addDrawer(ChartPanel.FuncDrawer func) {
        this.iFuncs.add(func);
    }

    public Collection<ChartPanel.FuncDrawer> funcs() {
        return this.iFuncs;
    }

    public void addDataset(Dataset.Set<XYpoint.Float> dataset) throws Exception {
        if (dataset.size() == 0) {
            Utility.throwError("dataset must not be empty");
        } else if (this.getDataset(dataset.name()) != null) {
            Utility.throwError("dataset already exists: " + dataset.name());
        } else {
            Dataset.List<XYpoint.Float> list = new Dataset.List<XYpoint.Float>(dataset.name());
            Iterator<XYpoint.Float> iter = dataset.iterator();
            while (iter.hasNext()) {
                list.add(iter.next());
            }
            this.iSets.add(list);
        }
    }

    public void addDataset(Dataset.List<XYpoint.Float> dataset) throws Exception {
        if (dataset.size() == 0) {
            Utility.throwError("dataset must not be empty");
        } else if (this.getDataset(dataset.name()) != null) {
            Utility.throwError("dataset already exists: " + dataset.name());
        } else {
            this.iSets.add(dataset);
        }
    }

    public Dataset.List<XYpoint.Float> getDataset(String name) {
        Dataset.List theSet = null;
        for (Dataset.List list : this.iSets) {
            if (!list.name().equalsIgnoreCase(name)) continue;
            theSet = list;
        }
        return theSet;
    }

    public Collection<Dataset.List<XYpoint.Float>> sets() {
        return this.iSets;
    }

    public float minX() {
        float min = Float.MAX_VALUE;
        for (Dataset.List list : this.iSets) {
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                XYpoint.Float point = (XYpoint.Float)iter.next();
                float value = (float)point.x();
                if (!(value < min)) continue;
                min = value;
            }
        }
        return min;
    }

    public float maxX() {
        float max = -3.4028235E38f;
        for (Dataset.List list : this.iSets) {
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                XYpoint.Float point = (XYpoint.Float)iter.next();
                float value = (float)point.x();
                if (!(value > max)) continue;
                max = value;
            }
        }
        return max;
    }

    public float minY() {
        float min = Float.MAX_VALUE;
        for (Dataset.List list : this.iSets) {
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                XYpoint.Float point = (XYpoint.Float)iter.next();
                float value = (float)point.y();
                if (!(value < min)) continue;
                min = value;
            }
        }
        return min;
    }

    public float maxY() {
        float max = -3.4028235E38f;
        for (Dataset.List list : this.iSets) {
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                XYpoint.Float point = (XYpoint.Float)iter.next();
                float value = (float)point.y();
                if (!(value > max)) continue;
                max = value;
            }
        }
        return max;
    }

    public String defaultFileName() {
        MString name = new MString(String.valueOf(this.title()) + FILEEXT);
        name.replaceRepetition(' ');
        name.replace(' ', '-');
        name.toLowerCase();
        return name.toString();
    }

    public void write(String path) throws Exception {
        GZIPOutputStream zipout = new GZIPOutputStream(new FileOutputStream(path));
        ObjectOutputStream out = new ObjectOutputStream(zipout);
        out.writeObject(this);
        out.close();
    }

    public MTextDataTable export() throws Exception {
        MTextDataTable table = new MTextDataTable(this.title());
        int nextCol = 1;
        nextCol = this.exportFullSets(table, nextCol);
        nextCol = this.exportColorSets(table, nextCol);
        return table;
    }

    private void setupDrawer() {
        this.iDrawer = this.iAppearance.getClass() == ScatterAppearance.class ? ScatterDrawer.singleton() : (this.iAppearance.getClass() == VertBarAppearance.class ? VertBarDrawer.singleton() : HorzOverlapDrawer.singleton());
    }

    private int exportFullSets(MTextDataTable table, int col) throws Exception {
        int count = 0;
        DecimalFormat format = new DecimalFormat("0.000");
        for (Dataset.List list : this.iSets) {
            String xColName = "x-set" + ++count;
            table.add(new MTextDataTable.Field(xColName, col));
            String yColName = "y-set" + count;
            table.add(new MTextDataTable.Field(yColName, col + 1));
            String[] xValues = new String[list.size()];
            String[] yValues = new String[list.size()];
            Iterator iter = list.iterator();
            int num = 0;
            while (iter.hasNext()) {
                XYpoint.Float point = (XYpoint.Float)iter.next();
                xValues[num] = format.format(point.x());
                yValues[num] = format.format(point.y());
                ++num;
            }
            table.putColumn(xColName, xValues);
            table.putColumn(yColName, yValues);
            col += 2;
        }
        return col;
    }

    private int exportColorSets(MTextDataTable table, int col) throws Exception {
        TreeSet<StdColor> colors = new TreeSet<StdColor>();
        for (Dataset.List list : this.iSets) {
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                XYpoint.Float point = (XYpoint.Float)iter.next();
                if (point.stdColor() == null) continue;
                colors.add(point.stdColor());
            }
        }
        for (StdColor stdColor : colors) {
            String xColName = "x-" + stdColor.name();
            table.add(new MTextDataTable.Field(xColName, col));
            String yColName = "y-" + stdColor.name();
            table.add(new MTextDataTable.Field(yColName, col + 1));
            LinkedList<XYpoint.Float> points = new LinkedList<XYpoint.Float>();
            for (Dataset.List list : this.iSets) {
                Iterator iter = list.iterator();
                while (iter.hasNext()) {
                    XYpoint.Float point = (XYpoint.Float)iter.next();
                    if (!point.stdColor().equals(stdColor)) continue;
                    points.add(point);
                }
            }
            DecimalFormat decimalFormat = new DecimalFormat(this.appearance().xScalesFormat());
            DecimalFormat yFormat = new DecimalFormat(this.appearance().yScalesFormat());
            String[] xValues = new String[points.size()];
            String[] yValues = new String[points.size()];
            int num = 0;
            for (XYpoint.Float point : points) {
                xValues[num] = decimalFormat.format(point.x());
                yValues[num] = yFormat.format(point.y());
                ++num;
            }
            table.putColumn(xColName, xValues);
            table.putColumn(yColName, yValues);
            col += 2;
        }
        return col;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.setupDrawer();
    }

    public static abstract class Appearance
    implements Serializable {
        private StdColor iPageColor = StdColor.WHITE;
        private StdColor iChartColor = StdColor.PALEYELLOW;
        private StdColor iAxesColor = StdColor.BLACK;
        private StdColor iDefaultItemColor = StdColor.SLATEBLUE;
        private Integer iBoundaryWidth = 1;
        private Integer iEmphasisLineWidth = 3;
        private Integer iTickWidth = 1;
        private Font iTitleFont = null;
        private StdColor iTitleColor = StdColor.BLUE;
        private Font iLabelsFont = null;
        private StdColor iLabelsColor = StdColor.BLUE;
        private Font iScalesFont = null;
        private StdColor iScalesColor = StdColor.BLUE;
        private StdColor iTicksColor = StdColor.GRAY;
        private String iXScalesFormat = "0";
        private String iYScalesFormat = "0";
        private Integer iNumXTicks = 4;
        private Integer iNumYTicks = 4;
        private Boolean iShowXScales = true;
        private Boolean iShowYScales = true;
        private Boolean iExtendTicks = false;
        private Boolean iShowXTicks = true;
        private Boolean iShowYTicks = true;
        private Boolean iShowLegend = true;
        private Integer iLeftMargin = 75;
        private Integer iRightMargin = 75;
        private Integer iVertMargin = 50;
        private Float iMinX = Float.valueOf(-99999.0f);
        private Float iMaxX = Float.valueOf(-99999.0f);
        private Float iMinY = Float.valueOf(-99999.0f);
        private Float iMaxY = Float.valueOf(-99999.0f);
        private static final long serialVersionUID = 2725872628058956085L;

        public Appearance() {
            int fontSize = Utility.stdFontSize();
            this.iScalesFont = this.iLabelsFont = new Font("Dialog", 1, fontSize);
            this.iTitleFont = new Font("Dialog", 1, (int)(1.5 * (double)fontSize));
        }

        public StdColor pageColor() {
            return this.iPageColor;
        }

        public void setPageColor(StdColor pageColor) {
            this.iPageColor = pageColor;
        }

        public StdColor chartColor() {
            return this.iChartColor;
        }

        public void setChartColor(StdColor color) {
            if (color != null) {
                this.iChartColor = color;
            }
        }

        public StdColor defaultItemColor() {
            return this.iDefaultItemColor;
        }

        public void setDefaultItemColor(StdColor color) {
            if (color != null) {
                this.iDefaultItemColor = color;
            }
        }

        public Font titleFont() {
            return this.iTitleFont;
        }

        public void setTitleFont(Font font) {
            if (font != null) {
                this.iTitleFont = font;
            }
        }

        public StdColor titleColor() {
            return this.iTitleColor;
        }

        public void setTitleColor(StdColor color) {
            if (color != null) {
                this.iTitleColor = color;
            }
        }

        public StdColor labelsColor() {
            return this.iLabelsColor;
        }

        public void setLabelsColor(StdColor color) {
            if (color != null) {
                this.iLabelsColor = color;
            }
        }

        public Font labelsFont() {
            return this.iLabelsFont;
        }

        public void setLabelsFont(Font font) {
            if (font != null) {
                this.iLabelsFont = font;
            }
        }

        public Font scalesFont() {
            return this.iScalesFont;
        }

        public void setScalesFont(Font scalesFont) {
            this.iScalesFont = scalesFont;
        }

        public StdColor scalesColor() {
            return this.iScalesColor;
        }

        public void setScalesColor(StdColor scalesColor) {
            this.iScalesColor = scalesColor;
        }

        public StdColor axesColor() {
            return this.iAxesColor;
        }

        public void setAxesColor(StdColor color) {
            if (color != null) {
                this.iAxesColor = color;
            }
        }

        public Integer leftMargin() {
            return this.iLeftMargin;
        }

        public void setLeftMargin(int margin) {
            this.iLeftMargin = margin;
        }

        public Integer rightMargin() {
            return this.iRightMargin;
        }

        public void setRightMargin(int margin) {
            this.iRightMargin = margin;
        }

        public Integer vertMargin() {
            return this.iVertMargin;
        }

        public void setVertMargin(int margin) {
            this.iVertMargin = margin;
        }

        public Integer boundaryWidth() {
            return this.iBoundaryWidth;
        }

        public void setBoundaryWidth(int width) {
            this.iBoundaryWidth = width;
        }

        public Integer emphasisLineWidth() {
            return this.iEmphasisLineWidth;
        }

        public void setEmphasisLineWidth(int width) {
            this.iEmphasisLineWidth = width;
        }

        public Integer tickWidth() {
            return this.iTickWidth;
        }

        public void setTickWidth(Integer width) {
            this.iTickWidth = width;
        }

        public Integer numYTicks() {
            return this.iNumYTicks;
        }

        public void setNumYTicks(int num) {
            this.iNumYTicks = num;
        }

        public Integer numXTicks() {
            return this.iNumXTicks;
        }

        public void setNumXTicks(int num) {
            this.iNumXTicks = num;
        }

        public Boolean isExtendTicks() {
            return this.iExtendTicks;
        }

        public void setExtendTicks(boolean extendTicks) {
            this.iExtendTicks = extendTicks;
        }

        public StdColor ticksColor() {
            return this.iTicksColor;
        }

        public void setTicksColor(StdColor ticksColor) {
            this.iTicksColor = ticksColor;
        }

        public void setShowYScales(boolean show) {
            this.iShowYScales = show;
        }

        public Boolean isShowYScales() {
            return this.iShowYScales;
        }

        public String xScalesFormat() {
            return this.iXScalesFormat;
        }

        public void setXScalesFormat(String format) {
            this.iXScalesFormat = format;
        }

        public String yScalesFormat() {
            return this.iYScalesFormat;
        }

        public void setYScalesFormat(String format) {
            this.iYScalesFormat = format;
        }

        public Boolean isShowXTicks() {
            return this.iShowXTicks;
        }

        public void setShowXTicks(boolean showXTicks) {
            this.iShowXTicks = showXTicks;
        }

        public Boolean isShowYTicks() {
            return this.iShowYTicks;
        }

        public void setShowYTicks(boolean showYTicks) {
            this.iShowYTicks = showYTicks;
        }

        public void setShowXScales(boolean show) {
            this.iShowXScales = show;
        }

        public Boolean isShowXScales() {
            return this.iShowXScales;
        }

        public Boolean isShowLegend() {
            return this.iShowLegend;
        }

        public void setShowLegend(Boolean showLegend) {
            this.iShowLegend = showLegend;
        }

        public Float minX() {
            return this.iMinX;
        }

        public void setMinX(Float minX) {
            this.iMinX = minX;
        }

        public Float maxX() {
            return this.iMaxX;
        }

        public void setMaxX(Float maxX) {
            this.iMaxX = maxX;
        }

        public Float minY() {
            return this.iMinY;
        }

        public void setMinY(Float minY) {
            this.iMinY = minY;
        }

        public Float maxY() {
            return this.iMaxY;
        }

        public void setMaxY(Float maxY) {
            this.iMaxY = maxY;
        }
    }

    public static class HorzLine
    implements Serializable {
        private float iYpos = 0.0f;
        private StdColor iColor = null;
        private String iLabel = null;
        private float iUncer = -1.0f;
        private int iWidth = 0;
        private static final long serialVersionUID = -8681199722559793856L;

        public HorzLine(float y, StdColor color, String label, int width, float uncer) {
            this.iYpos = y;
            this.iColor = color;
            this.iLabel = label;
            this.iUncer = uncer;
            this.iWidth = width;
        }

        public HorzLine(float y, StdColor color, String label, Appearance app) {
            this.iYpos = y;
            this.iColor = color;
            this.iLabel = label;
            this.iWidth = app.boundaryWidth();
        }

        public float yPos() {
            return this.iYpos;
        }

        public StdColor color() {
            return this.iColor;
        }

        public String label() {
            return this.iLabel;
        }

        public float uncer() {
            return this.iUncer;
        }

        public int width() {
            return this.iWidth;
        }
    }

    public static class HorzOverlapAppearance
    extends Appearance {
    }

    public static class LegendItem
    implements Serializable {
        private String iText = null;
        private StdColor iColor = null;
        private static final long serialVersionUID = -8126244469105394056L;

        public LegendItem(String text, StdColor color) {
            this.iText = text;
            this.iColor = color;
        }

        public String text() {
            return this.iText;
        }

        public StdColor color() {
            return this.iColor;
        }
    }

    public static class ScatterAppearance
    extends Appearance {
        private Type iType = Type.OPENCIRCLE;
        private Boolean iShowCenterDot = false;
        private Integer iMinPointSize = 0;
        private static final long serialVersionUID = 6984814297663672441L;

        public Integer getMinPointSize() {
            return this.iMinPointSize;
        }

        public void setMinPointSize(int size) {
            int rem = size % 2;
            if (rem > 0) {
                ++size;
            }
            this.iMinPointSize = size;
        }

        public Type type() {
            return this.iType;
        }

        public void setType(Type type) {
            this.iType = type;
        }

        public Boolean isShowCenterDot() {
            return this.iShowCenterDot;
        }

        public void setShowCenterDot(Boolean show) {
            this.iShowCenterDot = show;
        }

        public static class Type
        implements Comparable<Type>,
        Serializable {
            private String iName = null;
            public static final Type SOLIDSQUARE = new Type("SolidSquare");
            public static final Type OPENSQUARE = new Type("OpenSquare");
            public static final Type SOLIDCIRCLE = new Type("SolidCircle");
            public static final Type OPENCIRCLE = new Type("OpenCircle");
            private static Type[] Types = new Type[]{SOLIDSQUARE, OPENSQUARE, SOLIDCIRCLE, OPENCIRCLE};
            private static final long serialVersionUID = 5560850726403860734L;

            public static String[] names() {
                int i = 0;
                String[] names = new String[Types.length];
                Type[] typeArray = Types;
                int n = Types.length;
                int n2 = 0;
                while (n2 < n) {
                    Type type = typeArray[n2];
                    names[i++] = type.name();
                    ++n2;
                }
                return names;
            }

            public static Type forName(String name) {
                Type type = null;
                int i = 0;
                while (i < Types.length && type == null) {
                    if (Type.Types[i].iName.equals(name)) {
                        type = Types[i];
                    }
                    ++i;
                }
                return type;
            }

            public static String nameForType(Type type) {
                String name = null;
                int i = 0;
                while (i < Types.length && type == null) {
                    if (!Types[i].equals(type)) continue;
                    name = Type.Types[i].iName;
                }
                return name;
            }

            public String name() {
                return this.iName;
            }

            @Override
            public int compareTo(Type type) {
                int result = 0;
                if (type != this) {
                    result = -1;
                    if (type != null) {
                        result = this.iName.compareTo(type.iName);
                    }
                }
                return result;
            }

            public boolean equals(Object obj) {
                return this.compareTo((Type)obj) == 0;
            }

            public int hashCode() {
                return this.iName.toLowerCase().hashCode();
            }

            private Type(String name) {
                this.iName = name;
            }
        }
    }

    public static class VertBarAppearance
    extends Appearance {
        private Type iType = Type.NOTSTACKED;
        private Integer iBarSpacing = 5;
        private Integer iDatasetSpacing = 25;
        private StdColor iUncerColor = StdColor.LIGHTGRAY;
        private StdColor iUncerLineColor = StdColor.BLACK;
        private static final long serialVersionUID = 7981987642468935744L;

        public Integer barSpacing() {
            return this.iBarSpacing;
        }

        public void setBarSpacing(int spacing) {
            this.iBarSpacing = spacing;
        }

        public Integer datasetSpacing() {
            return this.iDatasetSpacing;
        }

        public void setDatasetSpacing(int spacing) {
            this.iDatasetSpacing = spacing;
        }

        public Type type() {
            return this.iType;
        }

        public void setType(Type type) {
            this.iType = type;
        }

        public StdColor uncerLineColor() {
            return this.iUncerLineColor;
        }

        public void setUncerLineColor(StdColor color) {
            if (color != null) {
                this.iUncerLineColor = color;
            }
        }

        public StdColor uncerColor() {
            return this.iUncerColor;
        }

        public void setUncerColor(StdColor color) {
            this.iUncerColor = color;
        }

        public static class Type
        implements Comparable<Type>,
        Serializable {
            private String iName = null;
            public static final Type NOTSTACKED = new Type("NotStacked");
            public static final Type STACKED = new Type("Stacked");
            public static final Type STACKEDWITHUNCER = new Type("StackedWithUncer");
            private static final long serialVersionUID = -6807060042488567444L;
            private static Type[] Types = new Type[]{NOTSTACKED, STACKED, STACKEDWITHUNCER};

            public static String[] names() {
                int i = 0;
                String[] names = new String[Types.length];
                Type[] typeArray = Types;
                int n = Types.length;
                int n2 = 0;
                while (n2 < n) {
                    Type type = typeArray[n2];
                    names[i++] = type.name();
                    ++n2;
                }
                return names;
            }

            public static Type forName(String name) {
                Type type = null;
                int i = 0;
                while (i < Types.length && type == null) {
                    if (Type.Types[i].iName.equals(name)) {
                        type = Types[i];
                    }
                    ++i;
                }
                return type;
            }

            public static String nameForType(Type type) {
                String name = null;
                int i = 0;
                while (i < Types.length && type == null) {
                    if (!Types[i].equals(type)) continue;
                    name = Type.Types[i].iName;
                }
                return name;
            }

            public String name() {
                return this.iName;
            }

            @Override
            public int compareTo(Type type) {
                int result = 0;
                if (type != this) {
                    result = -1;
                    if (type != null) {
                        result = this.iName.compareTo(type.iName);
                    }
                }
                return result;
            }

            public boolean equals(Object obj) {
                return this.compareTo((Type)obj) == 0;
            }

            public int hashCode() {
                return this.iName.toLowerCase().hashCode();
            }

            private Type(String name) {
                this.iName = name;
            }
        }
    }

    public static class VertLine
    implements Serializable {
        private float iXpos = 0.0f;
        private StdColor iColor = null;
        private String iLabel = null;
        private float iUncer = -1.0f;
        private int iWidth = 0;
        private static final long serialVersionUID = 6251151774371000453L;

        public VertLine(float x, StdColor color, String label, int width, float uncer) {
            this.iXpos = x;
            this.iColor = color;
            this.iLabel = label;
            this.iUncer = uncer;
            this.iWidth = width;
        }

        public float xPos() {
            return this.iXpos;
        }

        public StdColor color() {
            return this.iColor;
        }

        public String label() {
            return this.iLabel;
        }

        public float uncer() {
            return this.iUncer;
        }

        public int width() {
            return this.iWidth;
        }
    }
}

