/*
 * Decompiled with CFR 0.152.
 */
package unoofc;

import com.sun.star.awt.FontSlant;
import com.sun.star.beans.XPropertySet;
import com.sun.star.drawing.FillStyle;
import com.sun.star.drawing.LineStyle;
import com.sun.star.uno.Exception;
import com.sun.star.util.DateTime;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import unoofc.OColor;
import unoofc.OEnv;
import unoofc.OPropObj;
import unoofc.OProps;

public abstract class OUtil {
    public static String toUrl(String url) {
        return url.replace('\\', '/');
    }

    public static String urlFromPath(String path) {
        String url = "";
        if (OUtil.isWindows()) {
            url = "file:///" + path;
            url = url.replace('\\', '/');
        } else {
            url = "file://" + path;
        }
        return url;
    }

    public static int loUnitsFromMM(int mm) {
        return mm * 100;
    }

    public static Calendar calFromdateTime(DateTime dt) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(dt.Year, dt.Month - 1, dt.Day, dt.Hours, dt.Minutes, dt.Seconds);
        return cal;
    }

    protected static XPropertySet propSet(Object obj) throws Exception {
        return (XPropertySet)OEnv.obj().obtain(XPropertySet.class, obj);
    }

    protected static Object prop(Object obj, String propName) throws Exception {
        return OUtil.propSet(obj).getPropertyValue(propName);
    }

    protected static void setProp(Object obj, String propName, Object value) throws Exception {
        OUtil.propSet(obj).setPropertyValue(propName, value);
    }

    protected static LinkedList<String> arrayToColl(String[] strs) {
        LinkedList<String> list = new LinkedList<String>();
        String[] stringArray = strs;
        int n = strs.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            list.add(str);
            ++n2;
        }
        return list;
    }

    protected static boolean isWindows() {
        String osName = System.getProperty("os.name").toLowerCase();
        boolean isUnix = osName.indexOf("inux") >= 0;
        isUnix |= osName.indexOf("unix") >= 0;
        return !(isUnix |= osName.indexOf("os x") >= 0);
    }

    private OUtil() {
    }

    public static class CharProps
    extends PropGroup {
        public CharProps() {
            this.setProp(OProps.Char.CharFontName, "Times New Roman");
            this.setProp(OProps.Char.CharHeight, 12);
            this.setProp(OProps.Char.CharPosture, FontSlant.NONE);
            this.setProp(OProps.Char.CharWeight, Float.valueOf(100.0f));
        }

        public Object prop(OProps.Char prop) {
            return this.props().get(prop.toString());
        }

        public void setProp(OProps.Char prop, Object value) {
            this.props().put(prop.toString(), value);
        }
    }

    public static class FillProps
    extends PropGroup {
        public FillProps() {
            this.setProp(OProps.Fill.FillBackground, true);
            this.setProp(OProps.Fill.FillStyle, FillStyle.SOLID);
            this.setProp(OProps.Fill.FillColor, OColor.LIGHTGRAY);
        }

        public Object prop(OProps.Fill prop) {
            return this.props().get(prop.toString());
        }

        public void setProp(OProps.Fill prop, Object value) {
            this.props().put(prop.toString(), value);
        }
    }

    public static class LineProps
    extends PropGroup {
        public LineProps() {
            this.setProp(OProps.Line.LineStyle, LineStyle.SOLID);
            this.setProp(OProps.Line.LineColor, OColor.BLACK);
            this.setProp(OProps.Line.LineWidth, 10);
        }

        public Object prop(OProps.Line prop) {
            return this.props().get(prop.toString());
        }

        public void setProp(OProps.Line prop, Object value) {
            this.props().put(prop.toString(), value);
        }
    }

    public static abstract class PropGroup {
        private TreeMap<String, Object> iProps = new TreeMap();

        public void applyTo(OPropObj obj) throws Exception, Exception {
            Set<Map.Entry<String, Object>> mappings = this.iProps.entrySet();
            for (Map.Entry<String, Object> entry : mappings) {
                Object value = entry.getValue();
                if (value instanceof OColor) {
                    value = ((OColor)value).value();
                }
                obj.setProp(entry.getKey(), value);
            }
        }

        protected PropGroup() {
        }

        protected TreeMap<String, Object> props() {
            return this.iProps;
        }

        protected void applyToX(XPropertySet set) throws Exception {
            Set<Map.Entry<String, Object>> mappings = this.iProps.entrySet();
            for (Map.Entry<String, Object> entry : mappings) {
                Object value = entry.getValue();
                if (value instanceof OColor) {
                    value = ((OColor)value).value();
                }
                set.setPropertyValue(entry.getKey(), value);
            }
        }
    }
}

