/*
 * Decompiled with CFR 0.152.
 */
package unoofc;

import com.sun.star.beans.XPropertySet;
import com.sun.star.style.ParagraphAdjust;
import com.sun.star.table.CellContentType;
import com.sun.star.table.XCell;
import com.sun.star.table.XCellRange;
import com.sun.star.text.XParagraphCursor;
import com.sun.star.text.XText;
import com.sun.star.text.XTextCursor;
import com.sun.star.text.XTextTable;
import com.sun.star.text.XTextTableCursor;
import com.sun.star.uno.Exception;
import com.sun.star.uno.XInterface;
import unoofc.OEnumPropObj;
import unoofc.OEnv;
import unoofc.OProps;
import unoofc.OStyle;
import unoofc.OUserMsgs;
import unoofc.OWriterDoc;
import unoofc.UserMsg;

public class OTable
extends OEnumPropObj {
    private XTextTable iXTable = null;
    private int iNumRows = 0;
    private int iNumCols = 0;
    private String iTitle = null;

    public OTable(OWriterDoc doc, int numRows, int numCols) throws Exception {
        Object obj = doc.xGetMSFactory().createInstance("com.sun.star.text.TextTable");
        this.iXTable = (XTextTable)OEnv.obj().obtain(XTextTable.class, obj);
        this.iXTable.initialize(numRows, numCols);
        this.iNumRows = numRows;
        this.iNumCols = numCols;
        this.initPropObj();
        this.setProp(OProps.TextTable.TopMargin, (Object)500);
        this.setProp(OProps.TextTable.BottomMargin, (Object)500);
    }

    public int numRows() {
        return this.iNumRows;
    }

    public int numColumns() {
        return this.iNumCols;
    }

    public CellRange tableRange() throws Exception {
        XCellRange tableRange = (XCellRange)OEnv.obj().obtain(XCellRange.class, this.iXTable);
        return new CellRange(tableRange, this.iNumRows, this.iNumCols);
    }

    public CellRange rowRange(int rowNum) throws Exception {
        CellRange range = null;
        XCellRange tableRange = (XCellRange)OEnv.obj().obtain(XCellRange.class, this.iXTable);
        XCellRange rowRange = tableRange.getCellRangeByPosition(0, rowNum, this.iNumCols - 1, rowNum);
        range = new CellRange(rowRange, 1, this.iNumCols);
        return range;
    }

    public CellRange columnRange(int colNum) throws Exception {
        CellRange range = null;
        XCellRange tableRange = (XCellRange)OEnv.obj().obtain(XCellRange.class, this.iXTable);
        int firstRow = 0;
        if (this.iTitle != null) {
            ++firstRow;
        }
        XCellRange colRange = tableRange.getCellRangeByPosition(colNum, firstRow, colNum, this.iNumRows - 1);
        range = new CellRange(colRange, this.iNumRows - 1, 1);
        return range;
    }

    public void insertRowsBelow(int atRowNum, int numRows) {
        this.iXTable.getRows().insertByIndex(atRowNum, numRows);
        this.iNumRows += numRows;
    }

    public void deleteRowsBelow(int atRowNum, int numRows) {
        this.iXTable.getRows().removeByIndex(atRowNum, numRows);
        this.iNumRows -= numRows;
    }

    public void insertColumnsRight(int atColNum, int numCols) {
        this.iXTable.getColumns().insertByIndex(atColNum, numCols);
        this.iNumCols += numCols;
    }

    public void deleteColumnsRight(int atColNum, int numCols) {
        this.iXTable.getColumns().removeByIndex(atColNum, numCols);
        this.iNumCols -= numCols;
    }

    public CellRange addTitleRow(String title, OStyle.Para style) throws Exception {
        this.insertRowsBelow(0, 1);
        this.mergeRow(0);
        this.iTitle = title;
        XCellRange tableRange = (XCellRange)OEnv.obj().obtain(XCellRange.class, this.iXTable);
        XCellRange xRowRange = tableRange.getCellRangeByPosition(0, 0, 0, 0);
        CellRange rowRange = new CellRange(xRowRange, 1, 1);
        rowRange.setText(title);
        if (style != null) {
            rowRange.setStyle(style);
        }
        return rowRange;
    }

    public void centerCellContents() throws Exception {
        Cell[][] cells = this.tableRange().cells();
        int i = 0;
        while (i < cells.length) {
            int j = 0;
            while (j < cells[0].length) {
                cells[i][j].centerContents();
                ++j;
            }
            ++i;
        }
    }

    public void indent(int leftRightMargin) throws Exception {
        this.setProp(OProps.TextTable.HoriOrient, (Object)0);
        this.setProp(OProps.TextTable.LeftMargin, (Object)leftRightMargin);
        this.setProp(OProps.TextTable.RightMargin, (Object)leftRightMargin);
    }

    public static String columnNameFromNum(int number) {
        String name = null;
        int num1 = (number - 1) % 26;
        char chr = (char)(65 + num1);
        int num2 = (number - 1) / 26;
        name = num2 > 0 ? String.valueOf(OTable.columnNameFromNum(num2)) + chr : "" + chr;
        return name;
    }

    public static int[] colRowFromAddr(String addr) {
        int[] colAndRow = new int[2];
        int index = 0;
        while (Character.isAlphabetic(addr.charAt(index))) {
            ++index;
        }
        String colStr = addr.substring(0, index);
        int col = 0;
        int multiplier = 1;
        int i = colStr.length() - 1;
        while (i >= 0) {
            int digit = colStr.charAt(i) - 65 + 1;
            col += digit * multiplier;
            multiplier *= 26;
            --i;
        }
        colAndRow[0] = col - 1;
        String rowStr = addr.substring(index);
        int row = 0;
        multiplier = 1;
        int i2 = rowStr.length() - 1;
        while (i2 >= 0) {
            int digit = rowStr.charAt(i2) - 48;
            row += digit * multiplier;
            multiplier *= 10;
            --i2;
        }
        colAndRow[1] = row - 1;
        return colAndRow;
    }

    public XTextTable xGetXTable() {
        return this.iXTable;
    }

    @Override
    protected void initPropObj() throws Exception {
        this.setXObj((XInterface)this.iXTable);
    }

    private void mergeRow(int rowNum) {
        String name = "A" + (rowNum + 1);
        XTextTableCursor cursor = this.iXTable.createCursorByCellName(name);
        name = String.valueOf(OTable.columnNameFromNum(this.iNumCols)) + 1;
        cursor.gotoCellByName(name, true);
        cursor.mergeRange();
    }

    public static class Cell
    extends OEnumPropObj {
        private XCell iXCell = null;

        public String getFormula() {
            return this.iXCell.getFormula();
        }

        public double getValue() {
            return this.iXCell.getValue();
        }

        public CellContentType getType() {
            return this.iXCell.getType();
        }

        public long getError() {
            return this.iXCell.getError();
        }

        public void setFormula(String formula) {
            this.iXCell.setFormula(formula);
        }

        public void setValue(double value) {
            this.iXCell.setValue(value);
        }

        public void setText(String text) throws Exception {
            XText cellText = (XText)OEnv.obj().obtain(XText.class, this.iXCell);
            cellText.setString(text);
        }

        public void setStyle(OStyle.Para style) throws Exception {
            XText xText = (XText)OEnv.obj().obtain(XText.class, this.iXCell);
            XTextCursor tCursor = xText.createTextCursor();
            XPropertySet props = (XPropertySet)OEnv.obj().obtain(XPropertySet.class, tCursor);
            props.setPropertyValue(OProps.Para.ParaStyleName.toString(), (Object)style.name());
        }

        public void centerContents() throws Exception {
            this.setProp(OProps.Cell.VertOrient, (Object)2);
            XText xText = (XText)OEnv.obj().obtain(XText.class, this.iXCell);
            XTextCursor tCursor = xText.createTextCursor();
            XParagraphCursor pCursor = (XParagraphCursor)OEnv.obj().create(XParagraphCursor.class, tCursor);
            XPropertySet props = (XPropertySet)OEnv.obj().obtain(XPropertySet.class, pCursor);
            props.setPropertyValue(OProps.Para.ParaAdjust.toString(), (Object)ParagraphAdjust.CENTER);
        }

        public XCell xGetXCell() {
            return this.iXCell;
        }

        protected Cell(XCell cell) throws Exception {
            this.iXCell = cell;
            this.initPropObj();
        }

        @Override
        protected void initPropObj() throws Exception {
            this.setXObj((XInterface)this.iXCell);
        }
    }

    public static enum CellNumberFormat {
        DATE,
        TIME,
        CURRENCY,
        NUMBER,
        SCIENTIFIC,
        FRACTION,
        PERCENT,
        TEXT,
        DATETIME,
        LOGICAL;

    }

    public class CellRange
    extends OEnumPropObj {
        private XCellRange iXRange = null;
        private int iNumRows = 0;
        private int iNumCols = 0;

        public int numRows() {
            return this.iNumRows;
        }

        public int numCols() {
            return this.iNumCols;
        }

        public Cell[][] cells() throws Exception {
            Cell[][] cells = new Cell[this.iNumRows][this.iNumCols];
            int row = 0;
            while (row < this.iNumRows) {
                int col = 0;
                while (col < this.iNumCols) {
                    XCell xCell = this.iXRange.getCellByPosition(col, row);
                    cells[row][col] = new Cell(xCell);
                    ++col;
                }
                ++row;
            }
            return cells;
        }

        public void setStyle(OStyle.Para style) throws Exception {
            Cell[][] cells = this.cells();
            int i = 0;
            while (i < cells.length) {
                int j = 0;
                while (j < cells[0].length) {
                    cells[i][j].setStyle(style);
                    ++j;
                }
                ++i;
            }
        }

        public void setText(String text) throws Exception {
            Cell[][] cells = this.cells();
            int i = 0;
            while (i < cells.length) {
                int j = 0;
                while (j < cells[0].length) {
                    cells[i][j].setText(text);
                    ++j;
                }
                ++i;
            }
        }

        public void setText(String[][] strings) throws Exception {
            Cell[][] cells = this.cells();
            if (cells[0].length * cells.length != strings[0].length * strings.length) {
                UserMsg msg = OUserMsgs.msg("data-mismatch");
                OEnv.throwError(msg.format());
            } else {
                int i = 0;
                while (i < cells.length) {
                    int j = 0;
                    while (j < cells[0].length) {
                        cells[i][j].setText(strings[i][j]);
                        ++j;
                    }
                    ++i;
                }
            }
        }

        public XCellRange xGetXRange() {
            return this.iXRange;
        }

        @Override
        protected void initPropObj() throws Exception {
            this.setXObj((XInterface)this.iXRange);
        }

        protected CellRange(XCellRange range, int numRows, int numCols) throws Exception {
            this.iXRange = range;
            this.iNumRows = numRows;
            this.iNumCols = numCols;
            this.initPropObj();
        }
    }
}

