/*
 * Decompiled with CFR 0.152.
 */
package unoofc;

import com.sun.star.container.XNameAccess;
import com.sun.star.container.XNameContainer;
import com.sun.star.drawing.FillStyle;
import com.sun.star.style.ParagraphAdjust;
import com.sun.star.style.XStyle;
import com.sun.star.style.XStyleFamiliesSupplier;
import com.sun.star.text.XText;
import com.sun.star.text.XTextContent;
import com.sun.star.text.XTextCursor;
import com.sun.star.text.XTextRange;
import com.sun.star.uno.Exception;
import com.sun.star.uno.XInterface;
import com.sun.star.util.CellProtection;
import java.util.TreeMap;
import unoofc.OColor;
import unoofc.OEnumPropObj;
import unoofc.OEnv;
import unoofc.ONumbering;
import unoofc.OProps;
import unoofc.ORootDoc;
import unoofc.OWriterDoc;

public abstract class OStyle
extends OEnumPropObj
implements Comparable<OStyle> {
    private Family iFamily;
    private String iName = null;
    private ORootDoc iDoc = null;
    private XStyle iXStyle = null;

    public ORootDoc doc() {
        return this.iDoc;
    }

    public Family family() {
        return this.iFamily;
    }

    public String name() {
        return this.iName;
    }

    public boolean isUserDefined() {
        return this.iXStyle.isUserDefined();
    }

    public boolean isInUse() {
        return this.iXStyle.isInUse();
    }

    public String parentStyle() {
        return this.iXStyle.getParentStyle();
    }

    @Override
    public int compareTo(OStyle style) {
        int result = 0;
        if (style != this) {
            result = -1;
            if (style != null) {
                result = this.id().compareTo(style.id());
            }
        }
        return result;
    }

    public boolean equals(OStyle style) {
        return this.compareTo(style) == 0;
    }

    public ONumbering numbering() {
        return new ONumbering(this);
    }

    public String toString() {
        String str = String.valueOf(this.iFamily.toString()) + ", " + this.iName;
        return str;
    }

    public void setParentStyle(String parentName) throws Exception {
        this.iXStyle.setParentStyle(parentName);
    }

    public void setFillColor(OColor color) throws Exception {
        this.setProp(OProps.Fill.FillColor, (Object)color);
        this.setProp(OProps.Fill.FillStyle, (Object)FillStyle.SOLID);
    }

    public XStyle xGetXStyle() {
        return this.iXStyle;
    }

    @Override
    protected void initPropObj() throws Exception {
        this.setXObj((XInterface)this.iXStyle);
    }

    protected String id() {
        return String.valueOf(this.iFamily.name()) + "." + this.iName;
    }

    protected OStyle(ORootDoc doc, Family family, String name) throws Exception {
        XStyleFamiliesSupplier supplier = (XStyleFamiliesSupplier)OEnv.obj().obtain(XStyleFamiliesSupplier.class, doc.xGetXComp());
        XNameAccess accessor = supplier.getStyleFamilies();
        accessor = (XNameAccess)OEnv.obj().obtain(XNameAccess.class, accessor.getByName(family.name()));
        XNameContainer container = (XNameContainer)OEnv.obj().obtain(XNameContainer.class, accessor);
        this.iDoc = doc;
        this.iFamily = family;
        this.iName = name;
        String serviceName = "com.sun.star.style." + family.name();
        if (serviceName.endsWith("s")) {
            int len = serviceName.length();
            serviceName = serviceName.substring(0, len - 1);
        }
        try {
            this.iXStyle = (XStyle)OEnv.obj().obtain(XStyle.class, container.getByName(name));
        }
        catch (Exception xcp) {
            Object obj = this.iDoc.xGetMSFactory().createInstance(serviceName);
            this.iXStyle = (XStyle)OEnv.obj().obtain(XStyle.class, obj);
            container.insertByName(name, (Object)this.iXStyle);
        }
        this.setXObj((XInterface)this.iXStyle);
    }

    public static class Cell
    extends OStyle {
        public Cell(ORootDoc doc, String name) throws Exception {
            super(doc, Family.CELL, name);
        }

        public void unlock(boolean unlock) throws Exception {
            CellProtection prot = (CellProtection)this.prop(OProps.Cell.CellProtection);
            prot.IsLocked = !unlock;
            this.setProp(OProps.Cell.CellProtection, (Object)prot);
        }
    }

    public static class Char
    extends OStyle {
        public Char(ORootDoc doc, String name) throws Exception {
            super(doc, Family.CHARACTER, name);
        }
    }

    protected static class Default
    extends OStyle {
        public Default(ORootDoc doc, String name) throws Exception {
            super(doc, Family.Default, name);
        }
    }

    public static class DrawCell
    extends OStyle {
        public DrawCell(ORootDoc doc, String name) throws Exception {
            super(doc, Family.DRAWCELL, name);
        }
    }

    public static class DrawTable
    extends OStyle {
        public DrawTable(ORootDoc doc, String name) throws Exception {
            super(doc, Family.DRAWTABLE, name);
        }
    }

    public static class Family
    implements Comparable<Family> {
        private String iName = null;
        public static final Family CHARACTER = new Family("CharacterStyles");
        public static final Family PARAGRAPH = new Family("ParagraphStyles");
        public static final Family FRAME = new Family("FrameStyles");
        public static final Family PAGE = new Family("PageStyles");
        public static final Family NUMBERING = new Family("NumberingStyles");
        public static final Family TABLE = new Family("TableStyles");
        public static final Family CELL = new Family("CellStyles");
        public static final Family SHAPE = new Family("ShapeStyles");
        public static final Family GRAPHICS = new Family("graphics");
        public static final Family DRAWCELL = new Family("cell");
        public static final Family DRAWTABLE = new Family("table");
        public static final Family Default = new Family("Default");
        private static TreeMap<String, Family> Families = new TreeMap();

        static {
            Families.put(CHARACTER.name(), CHARACTER);
            Families.put(PARAGRAPH.name(), PARAGRAPH);
            Families.put(FRAME.name(), FRAME);
            Families.put(PAGE.name(), PAGE);
            Families.put(NUMBERING.name(), NUMBERING);
            Families.put(TABLE.name(), CELL);
            Families.put(CELL.name(), CELL);
            Families.put(SHAPE.name(), SHAPE);
            Families.put(GRAPHICS.name(), GRAPHICS);
            Families.put(DRAWCELL.name(), DRAWCELL);
            Families.put(DRAWTABLE.name(), DRAWTABLE);
            Families.put(Default.name(), Default);
        }

        public static Family byName(String name) {
            return Families.get(name);
        }

        public String name() {
            return this.iName;
        }

        @Override
        public int compareTo(Family family) {
            int result = 0;
            if (family != this) {
                result = -1;
                if (family != null) {
                    result = this.iName.compareTo(family.iName);
                }
            }
            return result;
        }

        public boolean equals(Family family) {
            return this.compareTo(family) == 0;
        }

        public String toString() {
            return this.iName;
        }

        private Family(String name) {
            this.iName = name;
        }
    }

    public static class Frame
    extends OStyle {
        public Frame(ORootDoc doc, String name) throws Exception {
            super(doc, Family.FRAME, name);
        }
    }

    public static class Graphics
    extends OStyle {
        public Graphics(ORootDoc doc, String name) throws Exception {
            super(doc, Family.GRAPHICS, name);
        }
    }

    public static class Numbering
    extends OStyle {
        public Numbering(ORootDoc doc, String name) throws Exception {
            super(doc, Family.NUMBERING, name);
        }
    }

    public static class Page
    extends OStyle {
        public Page(ORootDoc doc, String name) throws Exception {
            super(doc, Family.PAGE, name);
        }

        public void setupHeader(String text, ParagraphAdjust adjust, boolean pageNumbering) throws Exception {
            this.setProp(OProps.Page.HeaderIsOn, (Object)Boolean.TRUE);
            XText xText = (XText)OEnv.obj().obtain(XText.class, this.prop(OProps.Page.HeaderText));
            XTextCursor cursor = xText.createTextCursor();
            this.setupText(cursor, text, adjust, pageNumbering);
        }

        public void setupFooter(String text, ParagraphAdjust adjust, boolean pageNumbering) throws Exception {
            this.setProp(OProps.Page.FooterIsOn, (Object)Boolean.TRUE);
            XText xText = (XText)OEnv.obj().obtain(XText.class, this.prop(OProps.Page.HeaderText));
            XTextCursor cursor = xText.createTextCursor();
            this.setupText(cursor, text, adjust, pageNumbering);
        }

        private void setupText(XTextCursor cursor, String text, ParagraphAdjust adjust, boolean pageNumbering) throws Exception {
            OWriterDoc doc = (OWriterDoc)this.doc();
            Para header = new Para(doc, "Header");
            int margin = (Integer)this.prop(OProps.Page.TopMargin);
            this.setProp(OProps.Page.HeaderBodyDistance, (Object)(margin / 10));
            header.setProp(OProps.Para.ParaAdjust, (Object)adjust);
            OWriterDoc oWriterDoc = doc;
            oWriterDoc.getClass();
            OWriterDoc.Field pageNumber = new OWriterDoc.Field(oWriterDoc, OWriterDoc.TextFieldType.PageNumber);
            pageNumber.setProp(OProps.Numbering.NumberingType, (Object)4);
            OWriterDoc oWriterDoc2 = doc;
            oWriterDoc2.getClass();
            OWriterDoc.Field pageCount = new OWriterDoc.Field(oWriterDoc2, OWriterDoc.TextFieldType.PageCount);
            pageCount.setProp(OProps.Numbering.NumberingType, (Object)4);
            cursor.setString(text);
            cursor.gotoEnd(false);
            if (pageNumbering) {
                cursor.setString("Page ");
                cursor.gotoEnd(false);
                XText xText = cursor.getText();
                xText.insertTextContent((XTextRange)cursor, (XTextContent)pageNumber.xGetXField(), false);
                cursor.setString(" of ");
                cursor.gotoEnd(false);
                xText.insertTextContent((XTextRange)cursor, (XTextContent)pageCount.xGetXField(), false);
            }
        }
    }

    public static class Para
    extends OStyle {
        public Para(ORootDoc doc, String name) throws Exception {
            super(doc, Family.PARAGRAPH, name);
        }
    }

    public static class Shape
    extends OStyle {
        public Shape(ORootDoc doc, String name) throws Exception {
            super(doc, Family.SHAPE, name);
        }
    }

    public static class Table
    extends OStyle {
        public Table(ORootDoc doc, String name) throws Exception {
            super(doc, Family.TABLE, name);
        }
    }
}

