/*
 * Decompiled with CFR 0.152.
 */
package unoofc;

import com.sun.star.beans.PropertyValue;
import com.sun.star.container.XIndexAccess;
import com.sun.star.container.XIndexReplace;
import com.sun.star.uno.Exception;
import unoofc.OColor;
import unoofc.OEnv;
import unoofc.OProps;
import unoofc.OStyle;
import unoofc.OUserMsgs;
import unoofc.UserMsg;

public class ONumbering {
    private OStyle iStyle = null;
    private XIndexAccess iAccess = null;
    private XIndexReplace iReplace = null;
    private Object iRules = null;

    public ONumbering(OStyle style) {
        this.iStyle = style;
        try {
            this.iRules = style.prop(OProps.Para.NumberingRules.toString());
            this.iAccess = (XIndexAccess)OEnv.obj().obtain(XIndexAccess.class, this.iRules);
            this.iReplace = (XIndexReplace)OEnv.obj().obtain(XIndexReplace.class, this.iRules);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public OStyle style() {
        return this.iStyle;
    }

    public Object prop(OProps.Numbering prop, int level) throws Exception {
        this.checkLevel(level);
        Object theProp = null;
        String name = prop.toString();
        PropertyValue[] values = (PropertyValue[])this.iAccess.getByIndex(level);
        int i = 0;
        while (theProp == null && i < values.length) {
            PropertyValue pValue = values[i];
            if (pValue.Name.equals(name)) {
                theProp = pValue.Value;
            }
            ++i;
        }
        if (theProp == null) {
            UserMsg msg = OUserMsgs.msg("no-property");
            OEnv.throwError(msg.format(prop.toString()));
        }
        return theProp;
    }

    public void setProp(OProps.Numbering prop, int level, Object value) throws Exception {
        this.checkLevel(level);
        PropertyValue theProp = null;
        String name = prop.toString();
        PropertyValue[] values = (PropertyValue[])this.iAccess.getByIndex(level);
        int i = 0;
        while (theProp == null && i < values.length) {
            if (values[i].Name.equals(name)) {
                if (value instanceof OColor) {
                    value = ((OColor)value).value();
                }
                values[i].Value = value;
                this.iReplace.replaceByIndex(level, (Object)values);
                theProp = values[i];
            }
            ++i;
        }
        if (theProp == null) {
            UserMsg msg = OUserMsgs.msg("no-property");
            OEnv.throwError(msg.format(prop.toString()));
        } else {
            this.iStyle.setProp(OProps.Para.NumberingRules, this.iRules);
        }
    }

    private void checkLevel(int level) throws Exception {
        if (level < 0 || level > this.iAccess.getCount()) {
            UserMsg msg = OUserMsgs.msg("invalid-parm");
            OEnv.throwError(msg.format("level"));
        }
    }
}

