/*
 * Decompiled with CFR 0.152.
 */
package unoofc;

import com.sun.star.container.XIndexAccess;
import com.sun.star.drawing.XDrawPage;
import com.sun.star.drawing.XDrawPages;
import com.sun.star.drawing.XDrawPagesSupplier;
import com.sun.star.drawing.XMasterPagesSupplier;
import com.sun.star.drawing.XShape;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.presentation.XPresentationPage;
import com.sun.star.text.XText;
import com.sun.star.text.XTextRange;
import com.sun.star.uno.Exception;
import com.sun.star.uno.XInterface;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.TreeMap;
import unoofc.OColor;
import unoofc.ODrawArea;
import unoofc.ODrawDoc;
import unoofc.OEnv;
import unoofc.OFileFilter;
import unoofc.OProps;
import unoofc.OShape;
import unoofc.OUtil;

public class OImpressDoc
extends ODrawDoc {
    private static final String NEWDOCURL = "private:factory/simpress";

    public OImpressDoc(String url) throws Exception {
        if (url == null) {
            url = NEWDOCURL;
        }
        url = OUtil.toUrl(url);
        this.makeXComp(url);
        this.setMSFactory((XMultiServiceFactory)OEnv.obj().obtain(XMultiServiceFactory.class, this.xGetXComp()));
    }

    public ArrayList<Slide> slides() throws Exception {
        return this.pages(this.getXPages());
    }

    public ArrayList<Slide> masterSlides() throws Exception {
        return this.pages(this.getXMasterPages());
    }

    public Slide insertSlide(int number, SlideLayout layout) throws Exception {
        XDrawPage page = this.getXPages().insertNewByIndex(number);
        OUtil.setProp(page, OProps.PresPage.Layout.toString(), layout.iNumber);
        Slide slide = new Slide(page);
        slide.setProp(OProps.PresPage.IsPageNumberVisible, (Object)Boolean.TRUE);
        slide.setProp(OProps.PresPage.IsDateTimeVisible, (Object)Boolean.TRUE);
        return slide;
    }

    public Slide insertTitleSlide(int number, String title, String subTitle) throws Exception {
        Slide slide = this.insertSlide(number, SlideLayout.TITLESUBTITLE);
        ArrayList<OShape> shapes = slide.shapesByType(ShapeType.TITLETEXT);
        Iterator iter = shapes.iterator();
        ((OShape)iter.next()).setText(title);
        shapes = slide.shapesByType(ShapeType.SUBTITLE);
        iter = shapes.iterator();
        ((OShape)iter.next()).setText(subTitle);
        if (number == 0) {
            this.removeSlide(0);
        }
        return slide;
    }

    public Slide insertBulletSlide(int number, String title, Collection<Bullet> bullets, String bulletsStyle) throws Exception {
        Slide slide = this.insertSlide(number, SlideLayout.TITLEBULLETS);
        ArrayList<OShape> shapes = slide.shapesByType(ShapeType.TITLETEXT);
        Iterator iter = shapes.iterator();
        OShape shape = (OShape)iter.next();
        shape.setText(title);
        shapes = slide.shapesByType(ShapeType.OUTLINER);
        iter = shapes.iterator();
        shape = (OShape)iter.next();
        XText xText = (XText)OEnv.obj().obtain(XText.class, shape.xGetXObj());
        int count = 0;
        for (Bullet bullet : bullets) {
            XTextRange bulletsEnd = (XTextRange)OEnv.obj().obtain(XTextRange.class, xText.getEnd());
            OUtil.setProp(bulletsEnd, OProps.Para.NumberingLevel.toString(), (short)bullet.level());
            OUtil.setProp(bulletsEnd, OProps.Char.CharFontStyleName.toString(), bulletsStyle);
            String str = bullet.text();
            if (++count < bullets.size()) {
                str = String.valueOf(str) + "\n";
            }
            bulletsEnd.setString(str);
        }
        return slide;
    }

    public Slide insertBitmapSlide(int number, String title, String bitmapUrl) throws Exception {
        bitmapUrl = OUtil.toUrl(bitmapUrl);
        Slide slide = this.insertSlide(number, SlideLayout.TITLECONTENT);
        ArrayList<OShape> shapes = slide.shapesByType(ShapeType.TITLETEXT);
        Iterator<Object> iter = shapes.iterator();
        ((OShape)iter.next()).setText(title);
        iter = slide.shapesByType(ShapeType.OUTLINER).iterator();
        OShape outliner = (OShape)iter.next();
        ODrawArea bitmapArea = new ODrawArea(outliner.position(), outliner.size());
        ODrawDoc.PageLayer layer = slide.backgroundLayer();
        layer.remove(outliner);
        ODrawDoc.BitmapShape shape = new ODrawDoc.BitmapShape(this, bitmapArea, true, bitmapUrl);
        shape.setProp(OProps.Line.LineColor, (Object)OColor.GREEN);
        layer.add(shape);
        return slide;
    }

    public void removeSlide(int number) throws Exception {
        this.removePage(number);
    }

    public void setupMaster() throws Exception {
    }

    public String writeOdp(String url) throws Exception {
        return this.write(url, OFileFilter.ODP);
    }

    @Override
    protected void initPropObj() throws Exception {
        this.setXObj((XInterface)this.xGetXComp());
    }

    @Override
    protected XDrawPages getXPages() throws Exception {
        XDrawPages pages = null;
        XDrawPagesSupplier supplier = (XDrawPagesSupplier)OEnv.obj().obtain(XDrawPagesSupplier.class, this.xGetXDoc());
        if (supplier != null) {
            pages = supplier.getDrawPages();
        }
        return pages;
    }

    @Override
    protected XDrawPages getXMasterPages() throws Exception {
        XDrawPages pages = null;
        XMasterPagesSupplier supplier = (XMasterPagesSupplier)OEnv.obj().obtain(XMasterPagesSupplier.class, this.xGetXDoc());
        if (supplier != null) {
            pages = supplier.getMasterPages();
        }
        return pages;
    }

    private ArrayList<Slide> pages(XDrawPages xPages) throws Exception {
        ArrayList<Slide> pages = new ArrayList<Slide>();
        XIndexAccess access = (XIndexAccess)OEnv.obj().obtain(XIndexAccess.class, xPages);
        int i = 0;
        while (i < access.getCount()) {
            XDrawPage page = (XDrawPage)OEnv.obj().obtain(XDrawPage.class, xPages.getByIndex(i));
            XPresentationPage ppage = (XPresentationPage)OEnv.obj().obtain(XPresentationPage.class, page);
            pages.add(new Slide((XDrawPage)ppage));
            ++i;
        }
        return pages;
    }

    public static class Bullet {
        private int iLevel = 0;
        private String iText = null;

        public Bullet(int level, String text) {
            this.iLevel = level;
            this.iText = text;
        }

        public int level() {
            return this.iLevel;
        }

        public String text() {
            return this.iText;
        }

        public String toString() {
            return this.iText;
        }
    }

    public static class DateTimeShape
    extends OShape {
        public DateTimeShape(OImpressDoc doc, ODrawArea area) throws Exception {
            super(doc, ShapeType.DATETIME.name(), area);
        }

        protected DateTimeShape(XShape shape) throws Exception {
            this.iXShape = shape;
            this.initPropObj();
        }
    }

    public static class FooterShape
    extends OShape {
        public FooterShape(OImpressDoc doc, ODrawArea area) throws Exception {
            super(doc, ShapeType.FOOTER.name(), area);
        }

        protected FooterShape(XShape shape) throws Exception {
            this.iXShape = shape;
            this.initPropObj();
        }
    }

    public static class OutlinerShape
    extends OShape {
        public OutlinerShape(OImpressDoc doc, ODrawArea area) throws Exception {
            super(doc, ShapeType.OUTLINER.name(), area);
        }

        protected OutlinerShape(XShape shape) throws Exception {
            this.iXShape = shape;
            this.initPropObj();
        }
    }

    public static class ShapeType {
        private String iName = null;
        private static final String PACKAGE = "com.sun.star.presentation.";
        public static final ShapeType TITLETEXT = new ShapeType("com.sun.star.presentation.TitleTextShape");
        public static final ShapeType SUBTITLE = new ShapeType("com.sun.star.presentation.SubtitleShape");
        public static final ShapeType TITLEBULLETS = new ShapeType("com.sun.star.presentation.TitleBulletsShape");
        public static final ShapeType OUTLINER = new ShapeType("com.sun.star.presentation.OutlinerShape");
        public static final ShapeType NOTES = new ShapeType("com.sun.star.presentation.NotesShape");
        public static final ShapeType PAGE = new ShapeType("com.sun.star.presentation.PageShape");
        public static final ShapeType FOOTER = new ShapeType("com.sun.star.presentation.FooterShape");
        public static final ShapeType DATETIME = new ShapeType("com.sun.star.presentation.DateTimeShape");
        public static final ShapeType SLIDENUMBER = new ShapeType("com.sun.star.presentation.SlideNumberShape");

        public String name() {
            return this.iName;
        }

        private ShapeType(String name) {
            this.iName = name;
        }
    }

    public class Slide
    extends ODrawDoc.Page {
        public SlideLayout getLayout() throws Exception {
            int layout = (Integer)OUtil.prop(this.xGetXObj(), OProps.PresPage.Layout.toString());
            return SlideLayout.byNumber(layout);
        }

        public ArrayList<OShape> shapesByType(ShapeType type) throws Exception {
            ArrayList<OShape> shapes = new ArrayList<OShape>();
            for (OShape next : this.shapes()) {
                if (!type.name().equals(next.xGetXShape().getShapeType())) continue;
                shapes.add(next);
            }
            return shapes;
        }

        protected Slide(XDrawPage drawPage) throws Exception {
            super(drawPage);
        }
    }

    public static class SlideLayout {
        private int iNumber = 0;
        private String iDesc = null;
        private static TreeMap<Integer, SlideLayout> Layouts = new TreeMap();
        public static final SlideLayout TITLESUBTITLE = new SlideLayout(0, "title and subtitle");
        public static final SlideLayout TITLEBULLETS = new SlideLayout(1, "title and bullets");
        public static final SlideLayout TITLECONTENT = new SlideLayout(2, "title and content");
        public static final SlideLayout TITLEOLE = new SlideLayout(11, "title and OLE object");
        public static final SlideLayout TITLEONLY = new SlideLayout(19, "title only");
        public static final SlideLayout BLANK = new SlideLayout(20, "blank");
        public static final SlideLayout CENTEREDTEXT = new SlideLayout(32, "centered text");

        static {
            Layouts.put(SlideLayout.TITLESUBTITLE.iNumber, TITLESUBTITLE);
            Layouts.put(SlideLayout.TITLEBULLETS.iNumber, TITLEBULLETS);
            Layouts.put(SlideLayout.TITLECONTENT.iNumber, TITLECONTENT);
            Layouts.put(SlideLayout.TITLEOLE.iNumber, TITLEOLE);
            Layouts.put(SlideLayout.TITLEONLY.iNumber, TITLEONLY);
            Layouts.put(SlideLayout.BLANK.iNumber, BLANK);
            Layouts.put(SlideLayout.CENTEREDTEXT.iNumber, CENTEREDTEXT);
        }

        public String toString() {
            return "Layout: " + this.iDesc;
        }

        protected static SlideLayout byNumber(int number) {
            return Layouts.get(number);
        }

        private SlideLayout(int number, String desc) {
            this.iNumber = number;
            this.iDesc = desc;
        }
    }

    public static class SlideNumberShape
    extends OShape {
        public SlideNumberShape(OImpressDoc doc, ODrawArea area) throws Exception {
            super(doc, ShapeType.SLIDENUMBER.name(), area);
        }

        protected SlideNumberShape(XShape shape) throws Exception {
            this.iXShape = shape;
            this.initPropObj();
        }
    }

    public static class SubtitleShape
    extends OShape {
        public SubtitleShape(OImpressDoc doc, ODrawArea area) throws Exception {
            super(doc, ShapeType.SUBTITLE.name(), area);
        }

        protected SubtitleShape(XShape shape) throws Exception {
            this.iXShape = shape;
            this.initPropObj();
        }
    }

    public static class TitleTextShape
    extends OShape {
        public TitleTextShape(OImpressDoc doc, ODrawArea area) throws Exception {
            super(doc, ShapeType.TITLETEXT.name(), area);
        }

        protected TitleTextShape(XShape shape) throws Exception {
            this.iXShape = shape;
            this.initPropObj();
        }
    }
}

