/*
 * Decompiled with CFR 0.152.
 */
package unoofc;

import com.sun.star.awt.Point;
import com.sun.star.awt.Size;
import com.sun.star.awt.XBitmap;
import com.sun.star.beans.XPropertySet;
import com.sun.star.container.XIndexAccess;
import com.sun.star.container.XNameAccess;
import com.sun.star.drawing.ConnectorType;
import com.sun.star.drawing.XDrawPage;
import com.sun.star.drawing.XDrawPages;
import com.sun.star.drawing.XDrawPagesSupplier;
import com.sun.star.drawing.XLayer;
import com.sun.star.drawing.XLayerSupplier;
import com.sun.star.drawing.XMasterPagesSupplier;
import com.sun.star.drawing.XShape;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.Exception;
import com.sun.star.uno.XInterface;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import unoofc.ODrawArea;
import unoofc.OEnumPropObj;
import unoofc.OEnv;
import unoofc.OFileFilter;
import unoofc.OProps;
import unoofc.ORootDoc;
import unoofc.OShape;
import unoofc.OUserMsgs;
import unoofc.OUtil;
import unoofc.UserMsg;

public class ODrawDoc
extends ORootDoc {
    private static final String NEWDOCURL = "private:factory/sdraw";

    public ODrawDoc(String url) throws Exception {
        if (url == null) {
            url = NEWDOCURL;
        }
        url = OUtil.toUrl(url);
        this.makeXComp(url);
        this.setMSFactory((XMultiServiceFactory)OEnv.obj().obtain(XMultiServiceFactory.class, this.xGetXComp()));
        this.initPropObj();
    }

    public Page page(int number) throws Exception {
        this.testnumber(number);
        XDrawPages xPages = this.getXPages();
        XDrawPage page = (XDrawPage)OEnv.obj().obtain(XDrawPage.class, xPages.getByIndex(number));
        return new Page(page);
    }

    public ArrayList<Page> pages() throws Exception {
        return this.pages(this.getXPages());
    }

    public ArrayList<Page> masterPages() throws Exception {
        return this.pages(this.getXMasterPages());
    }

    public Page insertPage(int number) throws Exception {
        return new Page(number);
    }

    public void removePage(int number) throws Exception {
        if (this.numPages() == 1) {
            UserMsg msg = OUserMsgs.msg("last-page");
            OEnv.throwError(msg.format());
        } else {
            this.testnumber(number);
            this.getXPages().remove(this.page(number).xGetXPage());
        }
    }

    public String writeOdg(String url) throws Exception {
        return this.write(url, OFileFilter.ODG);
    }

    public XComponent xGetXDoc() {
        return this.xGetXComp();
    }

    @Override
    protected void initPropObj() throws Exception {
        this.setXObj((XInterface)this.xGetXComp());
    }

    @Override
    protected XDrawPages getXPages() throws Exception {
        XDrawPages pages = null;
        XDrawPagesSupplier supplier = (XDrawPagesSupplier)OEnv.obj().obtain(XDrawPagesSupplier.class, this.xGetXDoc());
        if (supplier != null) {
            pages = supplier.getDrawPages();
        }
        return pages;
    }

    protected XDrawPages getXMasterPages() throws Exception {
        XDrawPages pages = null;
        XMasterPagesSupplier supplier = (XMasterPagesSupplier)OEnv.obj().obtain(XMasterPagesSupplier.class, this.xGetXDoc());
        if (supplier != null) {
            pages = supplier.getMasterPages();
        }
        return pages;
    }

    protected void testnumber(int number) throws Exception {
        if (number < 0 || number >= this.numPages()) {
            UserMsg msg = OUserMsgs.msg("no-page");
            OEnv.throwError(msg.format(Integer.toString(number)));
        }
    }

    private ArrayList<Page> pages(XDrawPages xPages) throws Exception {
        ArrayList<Page> pages = new ArrayList<Page>();
        XIndexAccess access = (XIndexAccess)OEnv.obj().obtain(XIndexAccess.class, xPages);
        int i = 0;
        while (i < access.getCount()) {
            XDrawPage page = (XDrawPage)OEnv.obj().obtain(XDrawPage.class, xPages.getByIndex(i));
            pages.add(new Page(page));
            ++i;
        }
        return pages;
    }

    protected ODrawDoc() {
    }

    @Override
    protected void logDetails() throws Exception {
    }

    public static class BitmapShape
    extends OShape {
        public BitmapShape(ORootDoc doc, ODrawArea area, boolean scale, String url) throws Exception {
            super(doc, ShapeType.GRAPHIC.name(), area);
            url = OUtil.toUrl(url);
            XBitmap bitmap = doc.readBitmap(url);
            this.setProp(OProps.Graphic.Graphic.toString(), (Object)bitmap);
            if (scale) {
                area = area.fitToBitmap(doc, url);
            }
            this.setSize(area.size());
            this.setPosition(area.position());
        }

        protected BitmapShape(XShape shape) throws Exception {
            this.iXShape = shape;
            this.initPropObj();
        }
    }

    public static class ConnectorShape
    extends OShape {
        public ConnectorShape(ORootDoc doc, OShape shape1, OProps.Connector gluePoint1, OShape shape2, OProps.Connector gluePoint2, ConnectorType type) throws Exception {
            super(doc, ShapeType.CONNECTOR.name(), null);
            this.setProp(OProps.Connector.StartShape.toString(), (Object)shape1.xGetXObj());
            int number = ConnectorShape.gluePointNumber(gluePoint1.toString());
            this.setProp(OProps.Connector.StartGluePointIndex.toString(), (Object)number);
            this.setProp(OProps.Connector.EndShape.toString(), (Object)shape2.xGetXObj());
            number = ConnectorShape.gluePointNumber(gluePoint2.toString());
            this.setProp(OProps.Connector.EndGluePointIndex.toString(), (Object)number);
            this.setProp(OProps.Connector.EdgeKind.toString(), (Object)type);
        }

        protected ConnectorShape(XShape shape) throws Exception {
            this.iXShape = shape;
            this.initPropObj();
        }

        private static int gluePointNumber(String name) {
            int result = 0;
            if (name.equals(OProps.Connector.Top.toString())) {
                result = 0;
            } else if (name.equals(OProps.Connector.Bottom.toString())) {
                result = 2;
            } else if (name.equals(OProps.Connector.Left.toString())) {
                result = 1;
            } else if (name.equals(OProps.Connector.Right.toString())) {
                result = 3;
            }
            return result;
        }
    }

    public static class EllipseShape
    extends OShape {
        public EllipseShape(ORootDoc doc, ODrawArea area) throws Exception {
            super(doc, ShapeType.ELLIPSE.name(), area);
        }

        protected EllipseShape(XShape shape) throws Exception {
            this.iXShape = shape;
            this.initPropObj();
        }
    }

    public static class LineDash {
        private com.sun.star.drawing.LineDash iDash = new com.sun.star.drawing.LineDash();

        public LineDash(int numDots, int dotLen, int numDashes, int dashLen, int distance) {
            this.iDash.Dots = (short)numDots;
            this.iDash.DotLen = (short)dotLen;
            this.iDash.Dashes = (short)numDashes;
            this.iDash.DashLen = dashLen;
            this.iDash.Distance = distance;
        }

        protected com.sun.star.drawing.LineDash getDash() {
            return this.iDash;
        }
    }

    public static class LineShape
    extends OShape {
        public LineShape(ORootDoc doc, Point pos1, Point pos2) throws Exception {
            super(doc, ShapeType.LINE.name(), null);
            this.xGetXShape().setPosition(pos1);
            Size size = new Size();
            size.Width = pos2.X - pos1.X;
            size.Height = pos2.Y - pos1.Y;
            this.setSize(size);
        }

        protected LineShape(XShape shape) throws Exception {
            this.iXShape = shape;
            this.initPropObj();
        }
    }

    public class Page
    extends OEnumPropObj {
        private XDrawPage iXPage = null;

        public ArrayList<PageLayer> layers() throws Exception {
            String[] names;
            ArrayList<PageLayer> layers = new ArrayList<PageLayer>();
            XLayerSupplier supplier = (XLayerSupplier)OEnv.obj().obtain(XLayerSupplier.class, ODrawDoc.this.xGetXDoc());
            XNameAccess access = supplier.getLayerManager();
            String[] stringArray = names = access.getElementNames();
            int n = names.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                layers.add(this.layer(this, name));
                ++n2;
            }
            return layers;
        }

        public int numShapes() {
            return this.iXPage.getCount();
        }

        public Collection<OShape> shapes() throws Exception {
            LinkedList<OShape> shapes = new LinkedList<OShape>();
            int i = 0;
            while (i < this.iXPage.getCount()) {
                XShape shape = (XShape)OEnv.obj().obtain(XShape.class, this.iXPage.getByIndex(i));
                shapes.add(OShape.copy(shape));
                ++i;
            }
            return shapes;
        }

        public Collection<OShape> shapesByType(ShapeType type) throws Exception {
            LinkedList<OShape> shapes = new LinkedList<OShape>();
            for (OShape next : this.shapes()) {
                if (!type.name().equals(next.xGetXShape().getShapeType())) continue;
                shapes.add(next);
            }
            return shapes;
        }

        public ODrawArea area() throws Exception {
            int left = (Integer)this.prop(OProps.DrawPage.BorderLeft);
            int right = (Integer)this.prop(OProps.DrawPage.BorderRight);
            int top = (Integer)this.prop(OProps.DrawPage.BorderTop);
            int bottom = (Integer)this.prop(OProps.DrawPage.BorderBottom);
            Point pos = new Point(left, top);
            int width = (Integer)this.prop(OProps.DrawPage.Width) - left - right;
            int height = (Integer)this.prop(OProps.DrawPage.Height) - top - bottom;
            Size size = new Size(width, height);
            return new ODrawArea(pos, size);
        }

        public PageLayer backgroundLayer() throws Exception {
            return this.layer(this, "background");
        }

        public PageLayer layoutLayer() throws Exception {
            return this.layer(this, "layout");
        }

        public PageLayer backObjectsLayer() throws Exception {
            return this.layer(this, "backgroundobjects");
        }

        public void invert() throws Exception {
            int width = (Integer)this.prop(OProps.DrawPage.Width);
            int height = (Integer)this.prop(OProps.DrawPage.Height);
            this.setProp(OProps.DrawPage.Width, (Object)height);
            this.setProp(OProps.DrawPage.Height, (Object)width);
        }

        public XDrawPage xGetXPage() {
            return this.iXPage;
        }

        protected Page(int number) throws Exception {
            this.iXPage = ODrawDoc.this.getXPages().insertNewByIndex(number);
            this.setXObj((XInterface)this.iXPage);
        }

        protected Page(XDrawPage drawPage) throws Exception {
            this.iXPage = drawPage;
            this.setXObj((XInterface)this.iXPage);
        }

        @Override
        protected void initPropObj() throws Exception {
            this.setXObj((XInterface)this.iXPage);
        }

        private PageLayer layer(Page page, String name) throws Exception {
            XLayerSupplier supplier = (XLayerSupplier)OEnv.obj().obtain(XLayerSupplier.class, ODrawDoc.this.xGetXDoc());
            XLayer xLayer = (XLayer)OEnv.obj().obtain(XLayer.class, supplier.getLayerManager().getByName(name));
            return new PageLayer(page, xLayer);
        }
    }

    public class PageLayer
    extends OEnumPropObj {
        private XLayer iXLayer = null;
        private Page iPage = null;

        @Override
        public Object prop(OProps.Layer prop) throws Exception {
            XPropertySet propSet = (XPropertySet)OEnv.obj().obtain(XPropertySet.class, this.iXLayer);
            return propSet.getPropertyValue(prop.toString());
        }

        public void add(OShape shape) throws Exception {
            if (shape != null) {
                int layerId = (Integer)shape.prop("LayerID");
                shape.setProp("LayerID", (Object)layerId);
                this.iPage.xGetXPage().add(shape.xGetXShape());
            }
        }

        public void remove(OShape shape) {
            if (shape != null) {
                this.iPage.xGetXPage().remove(shape.xGetXShape());
            }
        }

        public void fillWithBitmap(String bitmapUrl) throws Exception {
            BitmapShape shape = new BitmapShape(ODrawDoc.this, this.iPage.area(), true, bitmapUrl);
            this.add(shape);
        }

        @Override
        public void setProp(OProps.Layer prop, Object value) throws Exception {
            XPropertySet propSet = (XPropertySet)OEnv.obj().obtain(XPropertySet.class, this.iXLayer);
            propSet.setPropertyValue(prop.toString(), value);
        }

        public XLayer xGetXLayer() {
            return this.iXLayer;
        }

        @Override
        protected void initPropObj() throws Exception {
            this.setXObj((XInterface)this.iXLayer);
        }

        protected PageLayer(Page page, XLayer layer) throws Exception {
            this.iXLayer = layer;
            this.iPage = page;
            this.setXObj((XInterface)this.iXLayer);
        }
    }

    public static class RectangleShape
    extends OShape {
        public RectangleShape(ORootDoc doc, ODrawArea area) throws Exception {
            super(doc, ShapeType.RECTANGLE.name(), area);
        }

        protected RectangleShape(XShape shape) throws Exception {
            this.iXShape = shape;
            this.initPropObj();
        }
    }

    public static class ShapeType {
        private String iName = null;
        private static final String PACKAGE = "com.sun.star.drawing.";
        public static final ShapeType RECTANGLE = new ShapeType("com.sun.star.drawing.RectangleShape");
        public static final ShapeType ELLIPSE = new ShapeType("com.sun.star.drawing.EllipseShape");
        public static final ShapeType TEXT = new ShapeType("com.sun.star.drawing.TextShape");
        public static final ShapeType GRAPHIC = new ShapeType("com.sun.star.drawing.GraphicObjectShape");
        public static final ShapeType LINE = new ShapeType("com.sun.star.drawing.LineShape");
        public static final ShapeType CONNECTOR = new ShapeType("com.sun.star.drawing.ConnectorShape");

        public String name() {
            return this.iName;
        }

        private ShapeType(String name) {
            this.iName = name;
        }
    }

    public static class TextShape
    extends OShape {
        public TextShape(ORootDoc doc, ODrawArea area) throws Exception {
            super(doc, ShapeType.TEXT.name(), area);
        }

        protected TextShape(XShape shape) throws Exception {
            this.iXShape = shape;
            this.initPropObj();
        }
    }
}

