/*
 * Decompiled with CFR 0.152.
 */
package unoofc;

import com.sun.star.awt.Point;
import com.sun.star.awt.Rectangle;
import com.sun.star.awt.Size;
import com.sun.star.awt.XBitmap;
import com.sun.star.uno.Exception;
import unoofc.OEnv;
import unoofc.ORootDoc;
import unoofc.OUserMsgs;
import unoofc.UserMsg;

public class ODrawArea
implements Cloneable {
    private Point iPos = null;
    private Size iSize = null;

    public ODrawArea(Point position, Size size) {
        this.iPos = position;
        this.iSize = size;
    }

    public ODrawArea(Rectangle rect) {
        this.iPos = new Point();
        this.iPos.X = rect.X;
        this.iPos.Y = rect.Y;
        this.iSize = new Size();
        this.iSize.Width = rect.Width;
        this.iSize.Height = rect.Height;
    }

    public Point position() {
        return this.iPos;
    }

    public Size size() {
        return this.iSize;
    }

    public int width() {
        return this.iSize.Width;
    }

    public int height() {
        return this.iSize.Height;
    }

    public int xPos() {
        return this.iPos.X;
    }

    public int yPos() {
        return this.iPos.Y;
    }

    public Point endPos() {
        Point pos = new Point(this.iPos.X, this.iPos.Y);
        pos.X += this.iSize.Width;
        pos.Y += this.iSize.Height;
        return pos;
    }

    public Rectangle rectangle() {
        Rectangle rect = new Rectangle();
        rect.X = this.iPos.X;
        rect.Y = this.iPos.Y;
        rect.Width = this.iSize.Width;
        rect.Height = this.iSize.Height;
        return rect;
    }

    public String toString() {
        String str = "x=" + this.iPos.X + ", y=" + this.iPos.Y + ", width=" + this.iSize.Width + ", height=" + this.iSize.Height;
        return str;
    }

    public ODrawArea changeX(int amount) {
        this.iPos.X += amount;
        return this;
    }

    public ODrawArea changeY(int amount) {
        this.iPos.Y += amount;
        return this;
    }

    public ODrawArea changeWidth(int amount) {
        this.iSize.Width += amount;
        return this;
    }

    public ODrawArea changeHeight(int amount) {
        this.iSize.Height += amount;
        return this;
    }

    public ODrawArea reshape(float widthFrac, float heightFrac) throws Exception {
        if (widthFrac <= 0.0f || widthFrac > 1.0f) {
            UserMsg msg = OUserMsgs.msg("invalid-parm");
            OEnv.throwError(msg.format("toWidthFrac"));
        } else if (heightFrac <= 0.0f || heightFrac > 1.0f) {
            UserMsg msg = OUserMsgs.msg("invalid-parm");
            OEnv.throwError(msg.format("toHeightFrac"));
        } else {
            float newWidth = widthFrac * (float)this.iSize.Width;
            float newHeight = heightFrac * (float)this.iSize.Height;
            this.iPos.X += (int)(0.5f + 0.5f * ((float)this.iSize.Width - newWidth));
            this.iPos.Y += (int)(0.5f + 0.5f * ((float)this.iSize.Height - newHeight));
            this.iSize.Width = (int)(0.5f + newWidth);
            this.iSize.Height = (int)(0.5f + newHeight);
        }
        return this;
    }

    public ODrawArea fitToBitmap(ORootDoc doc, String bitmapUrl) throws Exception {
        XBitmap bitmap = doc.readBitmap(bitmapUrl);
        float areaRatio = 1.0f * (float)this.size().Width / (float)this.size().Height;
        float imageRatio = 1.0f * (float)bitmap.getSize().Width / (float)bitmap.getSize().Height;
        if (areaRatio >= imageRatio) {
            int origWidth = this.size().Width;
            this.iSize.Width = (int)(0.5f + (float)this.iSize.Height * imageRatio);
            this.iPos.X += (int)(0.5f + (float)(origWidth - this.iSize.Width) * 0.5f);
        } else {
            int origHeight = this.size().Height;
            this.iSize.Height = (int)(0.5f + (float)this.iSize.Width / imageRatio);
            this.iPos.Y += (int)(0.5f + (float)(origHeight - this.iSize.Height) * 0.5f);
        }
        return this;
    }

    public Object clone() {
        ODrawArea copy = null;
        try {
            copy = (ODrawArea)super.clone();
            copy.iPos = new Point(this.iPos.X, this.iPos.Y);
            copy.iSize = new Size(this.iSize.Width, this.iSize.Height);
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return copy;
    }
}

