/*
 * Decompiled with CFR 0.152.
 */
package unoofc;

import com.sun.star.awt.Rectangle;
import com.sun.star.awt.Size;
import com.sun.star.beans.XPropertySet;
import com.sun.star.chart2.ScaleData;
import com.sun.star.chart2.Symbol;
import com.sun.star.chart2.SymbolStyle;
import com.sun.star.chart2.XAxis;
import com.sun.star.chart2.XChartDocument;
import com.sun.star.chart2.XChartType;
import com.sun.star.chart2.XChartTypeContainer;
import com.sun.star.chart2.XChartTypeManager;
import com.sun.star.chart2.XChartTypeTemplate;
import com.sun.star.chart2.XCoordinateSystem;
import com.sun.star.chart2.XCoordinateSystemContainer;
import com.sun.star.chart2.XDataSeries;
import com.sun.star.chart2.XDataSeriesContainer;
import com.sun.star.chart2.XDiagram;
import com.sun.star.chart2.XFormattedString;
import com.sun.star.chart2.XLegend;
import com.sun.star.chart2.XScaling;
import com.sun.star.chart2.XTitle;
import com.sun.star.chart2.XTitled;
import com.sun.star.chart2.data.XDataProvider;
import com.sun.star.chart2.data.XDataSequence;
import com.sun.star.chart2.data.XDataSink;
import com.sun.star.chart2.data.XDataSource;
import com.sun.star.chart2.data.XLabeledDataSequence;
import com.sun.star.container.XNameAccess;
import com.sun.star.document.XEmbeddedObjectSupplier;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.table.CellRangeAddress;
import com.sun.star.table.XTableChart;
import com.sun.star.table.XTableCharts;
import com.sun.star.table.XTableChartsSupplier;
import com.sun.star.uno.XInterface;
import unoofc.OCalcDoc;
import unoofc.OColor;
import unoofc.ODrawArea;
import unoofc.OEnumPropObj;
import unoofc.OEnv;
import unoofc.OPropObj;
import unoofc.OProps;
import unoofc.OUserMsgs;
import unoofc.OUtil;
import unoofc.UserMsg;

public class OChartDoc
extends OPropObj {
    private XChartDocument iXChartDoc = null;
    private XTableChart iXChart = null;
    private XDiagram iXDiagram = null;
    private String iType = null;
    private String iName = null;

    public OChartDoc(BasicType type, OCalcDoc.Sheet chartSheet, OCalcDoc.Sheet dataSheet, OCalcDoc.Sheet.CellRange[] dataRanges, ODrawArea drawArea, LabelsLocation labels, String name) throws com.sun.star.uno.Exception {
        this(type.toString(), chartSheet, dataSheet, dataRanges, drawArea, labels, name);
    }

    public OChartDoc(String type, OCalcDoc.Sheet chartSheet, OCalcDoc.Sheet dataSheet, OCalcDoc.Sheet.CellRange[] dataRanges, ODrawArea drawArea, LabelsLocation labels, String name) throws com.sun.star.uno.Exception {
        XTableChartsSupplier supplier = (XTableChartsSupplier)OEnv.obj().obtain(XTableChartsSupplier.class, chartSheet.xGetXSheet());
        XTableCharts xCharts = supplier.getCharts();
        Rectangle rect = drawArea.rectangle();
        boolean colLabels = false;
        boolean rowLabels = false;
        if (labels == LabelsLocation.FIRSTCOLUMN) {
            colLabels = false;
            rowLabels = true;
        } else if (labels == LabelsLocation.FIRSTROW) {
            colLabels = true;
            rowLabels = false;
        }
        CellRangeAddress[] addrs = new CellRangeAddress[dataRanges.length];
        int i = 0;
        while (i < dataRanges.length) {
            addrs[i] = dataSheet.rangeAddress(dataRanges[i]);
            ++i;
        }
        xCharts.addNewByName(name, rect, addrs, colLabels, rowLabels);
        XNameAccess access = (XNameAccess)OEnv.obj().obtain(XNameAccess.class, xCharts);
        Object any = access.getByName(name);
        this.iName = name;
        this.iXChart = (XTableChart)OEnv.obj().obtain(XTableChart.class, any);
        XEmbeddedObjectSupplier eSupplier = (XEmbeddedObjectSupplier)OEnv.obj().obtain(XEmbeddedObjectSupplier.class, this.iXChart);
        this.iXChartDoc = (XChartDocument)OEnv.obj().obtain(XChartDocument.class, eSupplier.getEmbeddedObject());
        this.setType(type);
        Legend legend = new Legend();
        legend.setProp(OProps.Legend.Show, (Object)true);
        legend.setProp(OProps.Char.CharHeight, (Object)7);
        this.iXDiagram.setLegend(legend.xGetXLegend());
        this.initPropObj();
    }

    public String type() {
        return this.iType;
    }

    public String name() {
        return this.iName;
    }

    public Title title() throws com.sun.star.uno.Exception {
        XTitled xTitled = (XTitled)OEnv.obj().obtain(XTitled.class, this.iXChartDoc);
        return new Title(xTitled);
    }

    public Legend legend() throws com.sun.star.uno.Exception {
        XLegend xLegend = this.iXDiagram.getLegend();
        return new Legend(xLegend);
    }

    public Background background() throws com.sun.star.uno.Exception {
        return new Background();
    }

    public Wall wall() throws com.sun.star.uno.Exception {
        return new Wall();
    }

    public Axis axis(AxisId type) throws com.sun.star.uno.Exception {
        return new Axis(type);
    }

    public DataSeries[] allDataSeries() throws com.sun.star.uno.Exception {
        XDataSeries[] allXSeries = this.allXDataSeries();
        DataSeries[] series = new DataSeries[allXSeries.length];
        int i = 0;
        while (i < allXSeries.length) {
            series[i] = new DataSeries(i);
            ++i;
        }
        return series;
    }

    public String[] availTypes() throws com.sun.star.uno.Exception {
        XChartTypeManager chartMgr = this.iXChartDoc.getChartTypeManager();
        XMultiServiceFactory factory = (XMultiServiceFactory)OEnv.obj().obtain(XMultiServiceFactory.class, chartMgr);
        String[] services = factory.getAvailableServiceNames();
        int i = 0;
        while (i < services.length) {
            int index = services[i].lastIndexOf(46);
            services[i] = services[i].substring(index + 1);
            ++i;
        }
        return services;
    }

    public void setType(BasicType type) throws com.sun.star.uno.Exception {
        this.setType(type.toString());
    }

    public void setType(String type) throws com.sun.star.uno.Exception {
        XChartTypeManager chartMgr = this.iXChartDoc.getChartTypeManager();
        XMultiServiceFactory factory = (XMultiServiceFactory)OEnv.obj().obtain(XMultiServiceFactory.class, chartMgr);
        String templateName = "com.sun.star.chart2.template." + type;
        XChartTypeTemplate template = (XChartTypeTemplate)OEnv.obj().obtain(XChartTypeTemplate.class, factory.createInstance(templateName));
        this.iXDiagram = this.iXChartDoc.getFirstDiagram();
        template.changeDiagram(this.iXDiagram);
        this.iType = type;
    }

    public void setDataRanges(OCalcDoc.Sheet.CellRange[] ranges) throws com.sun.star.uno.Exception {
        CellRangeAddress[] addrs = new CellRangeAddress[ranges.length];
        int i = 0;
        while (i < ranges.length) {
            addrs[i] = ranges[i].rangeAddress();
            ++i;
        }
        this.iXChart.setRanges(addrs);
    }

    public void showYErrorBars(String dataSeries, OCalcDoc.Sheet dataSheet, OCalcDoc.Sheet.CellRange errDataRange, OUtil.LineProps props) throws com.sun.star.uno.Exception {
        if (this.type().indexOf("Scatter") < 0) {
            UserMsg msg = OUserMsgs.msg("not-scatter");
            OEnv.throwError(msg.format());
        } else {
            XPropertySet errorProps = (XPropertySet)OEnv.obj().create(XPropertySet.class, "com.sun.star.chart2.ErrorBar");
            errorProps.setPropertyValue("ErrorBarStyle", (Object)7);
            errorProps.setPropertyValue("ShowPositiveError", (Object)true);
            errorProps.setPropertyValue("ShowNegativeError", (Object)true);
            XDataSink sink = (XDataSink)OEnv.obj().obtain(XDataSink.class, errorProps);
            LabeledDataSeq posSeq = new LabeledDataSeq(dataSheet, errDataRange, "error-bars-y-positive", dataSeries);
            LabeledDataSeq negSeq = new LabeledDataSeq(dataSheet, errDataRange, "error-bars-y-negative", dataSeries);
            XLabeledDataSequence[] array = new XLabeledDataSequence[]{posSeq.iXSeq, negSeq.iXSeq};
            sink.setData(array);
            XDataSeries[] allSeries = this.allXDataSeries();
            if (props != null) {
                props.applyToX(errorProps);
            }
            OUtil.setProp(allSeries[0], "ErrorBarY", errorProps);
        }
    }

    public XChartDocument xGetXDoc() {
        return this.iXChartDoc;
    }

    private XCoordinateSystem coordSystem() throws com.sun.star.uno.Exception {
        XCoordinateSystemContainer container = (XCoordinateSystemContainer)OEnv.obj().obtain(XCoordinateSystemContainer.class, this.iXDiagram);
        XCoordinateSystem[] coordSys = container.getCoordinateSystems();
        return coordSys[0];
    }

    private XDataSeries[] allXDataSeries() throws com.sun.star.uno.Exception {
        XChartTypeContainer typeContainer = (XChartTypeContainer)OEnv.obj().obtain(XChartTypeContainer.class, this.coordSystem());
        XChartType xType = typeContainer.getChartTypes()[0];
        XDataSeriesContainer seriesContainer = (XDataSeriesContainer)OEnv.obj().obtain(XDataSeriesContainer.class, xType);
        return seriesContainer.getDataSeries();
    }

    @Override
    protected void initPropObj() throws com.sun.star.uno.Exception {
        this.setXObj((XInterface)this.iXChartDoc);
    }

    public class Axis
    extends OEnumPropObj {
        private XAxis iXAxis = null;

        protected Axis(AxisId axis) throws com.sun.star.uno.Exception {
            int num = 0;
            if (axis == AxisId.Y) {
                num = 1;
            } else if (axis == AxisId.Z) {
                num = 2;
            }
            this.iXAxis = OChartDoc.this.coordSystem().getAxisByDimension(num, 0);
            this.initPropObj();
        }

        public Title title() throws com.sun.star.uno.Exception {
            XTitled xTitled = (XTitled)OEnv.obj().obtain(XTitled.class, this.iXAxis);
            return new Title(xTitled);
        }

        public void setScaling(AxisScalingType type) throws com.sun.star.uno.Exception {
            ScaleData scaleData = this.iXAxis.getScaleData();
            scaleData.Scaling = type == AxisScalingType.LOGARITHMIC ? (XScaling)OEnv.obj().create(XScaling.class, "com.sun.star.chart2.LogarithmicScaling") : (XScaling)OEnv.obj().create(XScaling.class, "com.sun.star.chart2.LinearScaling");
            this.iXAxis.setScaleData(scaleData);
        }

        public void setScaleMin(double min) {
            ScaleData scaleData = this.iXAxis.getScaleData();
            scaleData.Minimum = min;
            this.iXAxis.setScaleData(scaleData);
        }

        public void setScaleMax(double max) {
            ScaleData scaleData = this.iXAxis.getScaleData();
            scaleData.Maximum = max;
            this.iXAxis.setScaleData(scaleData);
        }

        public void setType(AxisType type) {
            ScaleData scaleData = this.iXAxis.getScaleData();
            scaleData.AxisType = type == AxisType.REALNUMBER ? 0 : (type == AxisType.PERCENT ? 1 : (type == AxisType.CATEGORY ? 2 : (type == AxisType.SERIES ? 3 : 4)));
            this.iXAxis.setScaleData(scaleData);
        }

        public void setGridProps(OUtil.LineProps props, boolean show) throws com.sun.star.uno.Exception {
            XPropertySet set = this.iXAxis.getGridProperties();
            props.applyToX(set);
            set.setPropertyValue(OProps.Legend.Show.toString(), (Object)show);
        }

        public XAxis xGetXAxis() {
            return this.iXAxis;
        }

        @Override
        protected void initPropObj() throws com.sun.star.uno.Exception {
            this.setXObj((XInterface)this.iXAxis);
        }
    }

    public static enum AxisId {
        X,
        Y,
        Z;

    }

    public static enum AxisScalingType {
        LINEAR,
        LOGARITHMIC;

    }

    public static enum AxisType {
        REALNUMBER,
        PERCENT,
        CATEGORY,
        SERIES,
        DATE;

    }

    public class Background
    extends OEnumPropObj {
        protected Background() throws com.sun.star.uno.Exception {
            this.initPropObj();
        }

        @Override
        protected void initPropObj() throws com.sun.star.uno.Exception {
            this.setXObj((XInterface)OChartDoc.this.iXChartDoc.getPageBackground());
        }
    }

    public static enum BasicType {
        Column,
        Bar,
        Pie,
        Area,
        Line,
        ScatterSymbol,
        StackedColumn;

    }

    public static enum DataPointSymbol {
        SQUARE,
        DIAMOND,
        TRIANGLE,
        BOWTIE,
        SANDGLASS,
        CIRCLE,
        X;

    }

    public class DataSeries
    extends OEnumPropObj {
        private XDataSeries iXSeries = null;

        protected DataSeries(int number) throws com.sun.star.uno.Exception {
            XChartTypeContainer typeContainer = (XChartTypeContainer)OEnv.obj().obtain(XChartTypeContainer.class, OChartDoc.this.coordSystem());
            XChartType xType = typeContainer.getChartTypes()[0];
            XDataSeriesContainer seriesContainer = (XDataSeriesContainer)OEnv.obj().obtain(XDataSeriesContainer.class, xType);
            this.iXSeries = seriesContainer.getDataSeries()[number];
            this.initPropObj();
        }

        public String dataRange() throws com.sun.star.uno.Exception {
            XDataSource source = (XDataSource)OEnv.obj().obtain(XDataSource.class, this.iXSeries);
            XLabeledDataSequence[] labeledSeqs = source.getDataSequences();
            String rangeText = labeledSeqs[0].getValues().getSourceRangeRepresentation();
            return rangeText;
        }

        public Object[] dataValues() throws com.sun.star.uno.Exception {
            XDataSource source = (XDataSource)OEnv.obj().obtain(XDataSource.class, this.iXSeries);
            XLabeledDataSequence[] array = source.getDataSequences();
            Object[] values = array[0].getValues().getData();
            return values;
        }

        public String toString() {
            String str = "unavailable";
            try {
                str = String.valueOf(str) + this.dataRange();
                XDataSource source = (XDataSource)OEnv.obj().obtain(XDataSource.class, this.iXSeries);
                XLabeledDataSequence[] seqs = source.getDataSequences();
                Object[] values = seqs[0].getValues().getData();
                str = String.valueOf(str) + ", " + values.length + " points";
            }
            catch (Exception exception) {
                // empty catch block
            }
            return str;
        }

        public void setPointSymbol(DataPointSymbol symbol, Size size) throws com.sun.star.uno.Exception {
            Symbol sym = (Symbol)this.prop("Symbol");
            sym.Style = SymbolStyle.STANDARD;
            sym.StandardSymbol = symbol == DataPointSymbol.SQUARE ? 0 : (symbol == DataPointSymbol.DIAMOND ? 1 : (symbol == DataPointSymbol.TRIANGLE ? 3 : (symbol == DataPointSymbol.BOWTIE ? 6 : (symbol == DataPointSymbol.SANDGLASS ? 7 : (symbol == DataPointSymbol.CIRCLE ? 8 : (symbol == DataPointSymbol.X ? 10 : 0))))));
            if (size != null) {
                sym.Size = size;
            }
            this.setProp("Symbol", (Object)sym);
        }

        public void set3DShape(Shape3D shape) throws com.sun.star.uno.Exception {
            int geo = 0;
            geo = shape == Shape3D.CYLINDER ? 1 : (shape == Shape3D.CONE ? 2 : 3);
            this.setProp("Geometry3D", (Object)geo);
        }

        public XDataSeries xGetXSeries() {
            return this.iXSeries;
        }

        @Override
        protected void initPropObj() throws com.sun.star.uno.Exception {
            this.setXObj((XInterface)this.iXSeries);
        }
    }

    private class LabeledDataSeq {
        private XLabeledDataSequence iXSeq = null;

        private LabeledDataSeq(OCalcDoc.Sheet sheet, OCalcDoc.Sheet.CellRange dataRange, String role, String dataLabel) throws com.sun.star.uno.Exception {
            XDataProvider provider = OChartDoc.this.iXChartDoc.getDataProvider();
            XDataSequence labelSeq = provider.createDataSequenceByRangeRepresentation(dataLabel);
            String range = String.valueOf(sheet.name()) + "." + dataRange.absoluteAddrRange();
            XDataSequence dataSeq = provider.createDataSequenceByRangeRepresentation(range);
            OUtil.setProp(dataSeq, "Role", role);
            this.iXSeq = (XLabeledDataSequence)OEnv.obj().create(XLabeledDataSequence.class, "com.sun.star.chart2.data.LabeledDataSequence");
            this.iXSeq.setLabel(labelSeq);
            this.iXSeq.setValues(dataSeq);
        }
    }

    public static enum LabelsLocation {
        FIRSTCOLUMN,
        FIRSTROW,
        NEITHER;

    }

    public class Legend
    extends OEnumPropObj {
        private XLegend iXLegend = null;

        protected XLegend xGetXLegend() {
            return this.iXLegend;
        }

        protected Legend() throws com.sun.star.uno.Exception {
            this.iXLegend = (XLegend)OEnv.obj().create(XLegend.class, "com.sun.star.chart2.Legend");
            OChartDoc.this.iXDiagram.setLegend(this.iXLegend);
            this.initPropObj();
        }

        protected Legend(XLegend legend) throws com.sun.star.uno.Exception {
            this.iXLegend = legend;
            this.initPropObj();
        }

        @Override
        protected void initPropObj() throws com.sun.star.uno.Exception {
            this.setXObj((XInterface)this.iXLegend);
        }
    }

    public static enum Shape3D {
        CUBOID,
        CYLINDER,
        CONE,
        PYRAMID;

    }

    public class Title
    extends OEnumPropObj {
        private XTitled iXTitled = null;
        private XTitle iXTitle = null;

        public String text() {
            XFormattedString[] xStr = this.iXTitle.getText();
            return xStr[0].getString();
        }

        @Override
        public Object prop(OProps.Char prop) throws com.sun.star.uno.Exception {
            XFormattedString[] xStr = this.iXTitle.getText();
            Object value = OUtil.prop(xStr[0], prop.toString());
            return value;
        }

        public void setText(String text) {
            XFormattedString[] xStr = this.iXTitle.getText();
            xStr[0].setString(text);
            this.iXTitle.setText(xStr);
            this.iXTitled.setTitleObject(this.iXTitle);
        }

        @Override
        public void setProp(OProps.Char prop, Object value) throws com.sun.star.uno.Exception {
            XFormattedString[] xStr = this.iXTitled.getTitleObject().getText();
            if (value instanceof OColor) {
                value = ((OColor)value).value();
            }
            OUtil.setProp(xStr[0], prop.toString(), value);
        }

        public XTitle xGetXTitle() {
            return this.iXTitled.getTitleObject();
        }

        @Override
        protected void setProp(String prop, Object value) throws com.sun.star.uno.Exception {
            XFormattedString[] xStr = this.iXTitled.getTitleObject().getText();
            OUtil.setProp(xStr[0], prop, value);
        }

        private Title(XTitled xTitled) throws com.sun.star.uno.Exception {
            this.iXTitled = xTitled;
            this.iXTitle = xTitled.getTitleObject();
            if (this.iXTitle == null) {
                this.iXTitle = (XTitle)OEnv.obj().create(XTitle.class, "com.sun.star.chart2.Title");
            }
            String serviceName = "com.sun.star.chart2.FormattedString";
            XFormattedString xStr = (XFormattedString)OEnv.obj().create(XFormattedString.class, serviceName);
            xStr.setString("");
            XFormattedString[] array = new XFormattedString[]{xStr};
            this.iXTitle.setText(array);
            this.initPropObj();
        }

        @Override
        protected void initPropObj() throws com.sun.star.uno.Exception {
            this.setXObj((XInterface)this.iXTitle);
        }
    }

    public class Wall
    extends OEnumPropObj {
        protected Wall() throws com.sun.star.uno.Exception {
            this.initPropObj();
        }

        @Override
        protected void initPropObj() throws com.sun.star.uno.Exception {
            this.setXObj((XInterface)OChartDoc.this.iXDiagram.getWall());
        }
    }
}

