/*
 * Decompiled with CFR 0.152.
 */
package utilt;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.TreeSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import mlib.MLogger;
import mlib.MLogging;
import mlib.MString;

public class ZipHandler {
    public static void main(String[] args) {
        try {
            ZipFile zipFile = new ZipFile("c:\\java\\eclipse\\bpm\\bpm-prog.zip");
            File toFolder = new File("c:\\misc\\x");
            String[] toSkip = new String[]{};
            int count = ZipHandler.extract(zipFile, toFolder, toSkip, new MLogger.System());
            zipFile.close();
            System.out.println(count);
            LinkedList<String> paths = new LinkedList<String>();
            paths.add("c:\\misc\\harper-map.jpg");
            paths.add("c:\\misc\\books\\midwestbook.lwp");
            File zip = new File("c:\\misc\\x\\out.zip");
            ZipHandler.write(zip, paths);
        }
        catch (Exception xcp) {
            System.out.println(xcp);
        }
    }

    public static int write(File zip, LinkedList<String> filePaths) throws Exception {
        int count = 0;
        ZipOutputStream out = null;
        InputStream fis = null;
        try {
            TreeSet<String> written = new TreeSet<String>();
            out = new ZipOutputStream(new FileOutputStream(zip));
            byte[] buffer = new byte[1024];
            for (String path : filePaths) {
                if (written.contains(path)) continue;
                File file = new File(path);
                fis = new FileInputStream(file);
                ZipEntry zipEntry = new ZipEntry(path);
                out.putNextEntry(zipEntry);
                long bytesLeft = file.length();
                while (bytesLeft > 0L) {
                    long bytesToRead = buffer.length;
                    if (bytesLeft < bytesToRead) {
                        bytesToRead = bytesLeft;
                    }
                    fis.read(buffer, 0, (int)bytesToRead);
                    out.write(buffer, 0, (int)bytesToRead);
                    bytesLeft -= bytesToRead;
                }
                fis.close();
                written.add(path);
                ++count;
            }
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (fis != null) {
                fis.close();
            }
        }
        return count;
    }

    public static int extract(ZipFile from, File toFolder, String[] filesToSkip, MLogging logger) throws Exception {
        int count = 0;
        InputStream ins = null;
        OutputStream outs = null;
        try {
            byte[] buffer = new byte[2048];
            Enumeration<? extends ZipEntry> enumer = from.entries();
            while (enumer.hasMoreElements()) {
                boolean extract;
                ZipEntry entry = enumer.nextElement();
                String path = String.valueOf(toFolder.getAbsolutePath()) + File.separator + entry.getName();
                File file = new File(path);
                boolean bl = extract = !file.exists();
                if (!extract) {
                    boolean isOnce = false;
                    int i = 0;
                    while (i < filesToSkip.length && !isOnce) {
                        isOnce = entry.getName().equals(filesToSkip[i]);
                        ++i;
                    }
                    boolean bl2 = extract = !isOnce;
                }
                if (!extract) {
                    logger.writeln("Skipped one-time file " + entry.getName());
                    continue;
                }
                MString fileName = new MString(entry.getName());
                LinkedList<MString> tokens = fileName.tokenize("/'", false);
                path = toFolder.getAbsolutePath();
                for (MString name : tokens) {
                    int index = name.indexOf('.');
                    if (index >= 0) continue;
                    path = String.valueOf(path) + File.separator + name.toString();
                    File dir = new File(path);
                    dir.mkdir();
                }
                ++count;
                ins = new BufferedInputStream(from.getInputStream(entry));
                file.createNewFile();
                outs = new BufferedOutputStream(new FileOutputStream(file));
                while (ins.available() > 0) {
                    long bytesToRead = ins.available();
                    if (bytesToRead > (long)buffer.length) {
                        bytesToRead = buffer.length;
                    }
                    ins.read(buffer, 0, (int)bytesToRead);
                    outs.write(buffer, 0, (int)bytesToRead);
                }
                outs.close();
                ins.close();
                ++count;
                logger.writeln("Extracted file " + entry.getName());
            }
        }
        finally {
            if (ins != null) {
                ins.close();
            }
            if (outs != null) {
                outs.close();
            }
        }
        from.close();
        return count;
    }
}

